@extends('layouts.app')

@section('title', 'تفاصيل الخزينة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">معلومات الخزينة</h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-registers.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 40%">الاسم</th>
                            <td>{{ $cashRegister->name }}</td>
                        </tr>
                        <tr>
                            <th>الكود</th>
                            <td>{{ $cashRegister->code }}</td>
                        </tr>
                        <tr>
                            <th>الفرع</th>
                            <td>{{ $cashRegister->branch ? $cashRegister->branch->name : 'غير محدد' }}</td>
                        </tr>
                        <tr>
                            <th>المسؤول</th>
                            <td>{{ $cashRegister->responsibleUser ? $cashRegister->responsibleUser->name : 'غير محدد' }}</td>
                        </tr>
                        <tr>
                            <th>الرصيد الافتتاحي</th>
                            <td>{{ number_format($cashRegister->initial_balance, 2) }} {{ $cashRegister->currency }}</td>
                        </tr>
                        <tr>
                            <th>الرصيد الحالي</th>
                            <td>{{ number_format($cashRegister->current_balance, 2) }} {{ $cashRegister->currency }}</td>
                        </tr>
                        <tr>
                            <th>الحالة</th>
                            <td>
                                @if($cashRegister->is_active)
                                    <span class="badge badge-success">نشط</span>
                                @else
                                    <span class="badge badge-danger">غير نشط</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>النوع</th>
                            <td>
                                @if($cashRegister->is_main)
                                    <span class="badge badge-primary">الخزينة الرئيسية</span>
                                @else
                                    <span class="badge badge-secondary">خزينة فرعية</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>تاريخ الإنشاء</th>
                            <td>{{ $cashRegister->created_at->format('Y-m-d H:i') }}</td>
                        </tr>
                        <tr>
                            <th>آخر تحديث</th>
                            <td>{{ $cashRegister->updated_at->format('Y-m-d H:i') }}</td>
                        </tr>
                    </table>

                    <div class="mt-3">
                        <a href="{{ route('cash-registers.edit', $cashRegister->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إحصائيات الخزينة</h3>
                </div>
                <div class="card-body">
                    <div class="info-box bg-success">
                        <span class="info-box-icon"><i class="fas fa-plus-circle"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">إجمالي الإيداعات</span>
                            <span class="info-box-number">{{ number_format($cashRegister->total_deposits, 2) }} {{ $cashRegister->currency }}</span>
                        </div>
                    </div>

                    <div class="info-box bg-danger">
                        <span class="info-box-icon"><i class="fas fa-minus-circle"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">إجمالي السحوبات</span>
                            <span class="info-box-number">{{ number_format($cashRegister->total_withdrawals, 2) }} {{ $cashRegister->currency }}</span>
                        </div>
                    </div>

                    <div class="info-box bg-warning">
                        <span class="info-box-icon"><i class="fas fa-exchange-alt"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">إجمالي التحويلات الصادرة</span>
                            <span class="info-box-number">{{ number_format($cashRegister->total_outgoing_transfers, 2) }} {{ $cashRegister->currency }}</span>
                        </div>
                    </div>

                    <div class="info-box bg-info">
                        <span class="info-box-icon"><i class="fas fa-exchange-alt"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">إجمالي التحويلات الواردة</span>
                            <span class="info-box-number">{{ number_format($cashRegister->total_incoming_transfers, 2) }} {{ $cashRegister->currency }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">آخر المعاملات</h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-transactions.create-deposit', $cashRegister->id) }}" class="btn btn-success btn-sm">
                            <i class="fas fa-plus-circle"></i> إيداع
                        </a>
                        <a href="{{ route('cash-transactions.create-withdrawal', $cashRegister->id) }}" class="btn btn-danger btn-sm">
                            <i class="fas fa-minus-circle"></i> سحب
                        </a>
                        <a href="{{ route('cash-transactions.create-transfer', $cashRegister->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-exchange-alt"></i> تحويل
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>التاريخ</th>
                                    <th>النوع</th>
                                    <th>المبلغ</th>
                                    <th>الخزينة المرتبطة</th>
                                    <th>المستخدم</th>
                                    <th>الملاحظات</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($cashRegister->transactions as $index => $transaction)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                        <td>
                                            @if($transaction->type == 'deposit')
                                                <span class="badge badge-success">{{ $transaction->type_name }}</span>
                                            @elseif($transaction->type == 'withdrawal')
                                                <span class="badge badge-danger">{{ $transaction->type_name }}</span>
                                            @elseif($transaction->type == 'transfer')
                                                <span class="badge badge-primary">{{ $transaction->type_name }}</span>
                                            @endif
                                        </td>
                                        <td>{{ number_format($transaction->amount, 2) }} {{ $cashRegister->currency }}</td>
                                        <td>
                                            @if($transaction->type == 'transfer')
                                                {{ $transaction->relatedCashRegister ? $transaction->relatedCashRegister->name : 'غير محدد' }}
                                            @else
                                                -
                                            @endif
                                        </td>
                                        <td>{{ $transaction->user ? $transaction->user->name : 'غير محدد' }}</td>
                                        <td>{{ $transaction->notes ?? '-' }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('cash-transactions.show', $transaction->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($transaction->created_at->diffInDays(now()) <= 1)
                                                    <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteTransactionModal{{ $transaction->id }}" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                @endif
                                            </div>

                                            <!-- Modal Delete Transaction -->
                                            <div class="modal fade" id="deleteTransactionModal{{ $transaction->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteTransactionModalLabel" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteTransactionModalLabel">تأكيد حذف المعاملة</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف هذه المعاملة؟ سيتم استرجاع التغييرات في الرصيد.
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('cash-transactions.destroy', $transaction->id) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد معاملات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        <a href="{{ route('cash-transactions.index') }}?cash_register_id={{ $cashRegister->id }}" class="btn btn-default">
                            <i class="fas fa-list"></i> عرض كل المعاملات
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection