@extends('layouts.app')

@section('title', 'إدارة الخزائن')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قائمة الخزائن</h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-registers.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة خزينة جديدة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>الكود</th>
                                    <th>الفرع</th>
                                    <th>المسؤول</th>
                                    <th>الرصيد الحالي</th>
                                    <th>الحالة</th>
                                    <th>الخزينة الرئيسية</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($cashRegisters as $index => $cashRegister)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $cashRegister->name }}</td>
                                        <td>{{ $cashRegister->code }}</td>
                                        <td>{{ $cashRegister->branch ? $cashRegister->branch->name : 'غير محدد' }}</td>
                                        <td>{{ $cashRegister->responsibleUser ? $cashRegister->responsibleUser->name : 'غير محدد' }}</td>
                                        <td>{{ number_format($cashRegister->current_balance, 2) }} {{ $cashRegister->currency }}</td>
                                        <td>
                                            @if($cashRegister->is_active)
                                                <span class="badge badge-success">نشط</span>
                                            @else
                                                <span class="badge badge-danger">غير نشط</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($cashRegister->is_main)
                                                <span class="badge badge-primary">الخزينة الرئيسية</span>
                                            @else
                                                <span class="badge badge-secondary">خزينة فرعية</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('cash-registers.show', $cashRegister->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('cash-registers.edit', $cashRegister->id) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="{{ route('cash-transactions.create-deposit', $cashRegister->id) }}" class="btn btn-success btn-sm" title="إيداع">
                                                    <i class="fas fa-plus-circle"></i>
                                                </a>
                                                <a href="{{ route('cash-transactions.create-withdrawal', $cashRegister->id) }}" class="btn btn-danger btn-sm" title="سحب">
                                                    <i class="fas fa-minus-circle"></i>
                                                </a>
                                                <a href="{{ route('cash-transactions.create-transfer', $cashRegister->id) }}" class="btn btn-primary btn-sm" title="تحويل">
                                                    <i class="fas fa-exchange-alt"></i>
                                                </a>
                                                <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal{{ $cashRegister->id }}" title="حذف">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>

                                            <!-- Modal Delete -->
                                            <div class="modal fade" id="deleteModal{{ $cashRegister->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف الخزينة <strong>{{ $cashRegister->name }}</strong>؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('cash-registers.destroy', $cashRegister->id) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد خزائن</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $cashRegisters->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection