@extends('layouts.modern')

@section('title', $branch->name)

@section('header', $branch->name)

@section('content')
<!-- Floating Action Button -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 5">
    <div class="dropdown dropup">
        <button class="btn btn-primary btn-lg rounded-circle shadow dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-gear"></i>
        </button>
        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton">
            <li>
                <a class="dropdown-item" href="{{ route('branches.edit', $branch->id) }}">
                    <i class="bi bi-pencil"></i> تعديل الفرع
                </a>
            </li>
            <li>
                <a class="dropdown-item" href="{{ route('branches.create') }}">
                    <i class="bi bi-plus-circle"></i> إضافة فرع جديد
                </a>
            </li>
            @if(!$branch->is_main_branch)
            <li>
                <form action="{{ route('branches.destroy', $branch->id) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="dropdown-item text-danger" onclick="return confirm('هل أنت متأكد من رغبتك في حذف هذا الفرع؟')">
                        <i class="bi bi-trash"></i> حذف الفرع
                    </button>
                </form>
            </li>
            @endif
        </ul>
    </div>
</div>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">معلومات الفرع</h6>
                <div>
                    <a href="{{ route('branches.edit', $branch->id) }}" class="btn btn-primary btn-sm">
                        <i class="bi bi-pencil"></i> تعديل
                    </a>
                    <a href="{{ route('branches.index') }}" class="btn btn-secondary btn-sm">
                        <i class="bi bi-arrow-right"></i> العودة للقائمة
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="text-center mb-4">
                    <div class="bg-light p-3 mb-3 rounded">
                        <i class="bi bi-building text-primary" style="font-size: 3rem;"></i>
                    </div>
                    <h5>{{ $branch->name }}</h5>
                    @if($branch->name_en)
                    <p class="text-muted">{{ $branch->name_en }}</p>
                    @endif
                    <p class="text-muted">
                        @if($branch->is_main_branch)
                            <span class="badge bg-info">الفرع الرئيسي</span>
                        @endif
                        @if($branch->is_active)
                            <span class="badge bg-success">نشط</span>
                        @else
                            <span class="badge bg-danger">غير نشط</span>
                        @endif
                        @if($branch->code)
                            <span class="badge bg-secondary">{{ $branch->code }}</span>
                        @endif
                    </p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">معلومات الاتصال</h6>
                    <p class="mb-1"><i class="bi bi-envelope me-2"></i> {{ $branch->email ?: 'غير متوفر' }}</p>
                    <p class="mb-1"><i class="bi bi-telephone me-2"></i> {{ $branch->phone ?: 'غير متوفر' }}</p>
                    @if($branch->mobile)
                    <p class="mb-1"><i class="bi bi-phone me-2"></i> {{ $branch->mobile }}</p>
                    @endif
                    <p class="mb-1"><i class="bi bi-person me-2"></i> المدير: {{ $branch->manager_name ?: 'غير معين' }}</p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">العنوان</h6>
                    <p class="mb-1">
                        {{ $branch->address ?: 'غير متوفر' }}<br>
                        @if($branch->address_en)
                        <small class="text-muted">{{ $branch->address_en }}</small><br>
                        @endif
                        @if($branch->city || $branch->state || $branch->postal_code)
                            {{ $branch->city }}{{ $branch->city && $branch->state ? '، ' : '' }}{{ $branch->state }} {{ $branch->postal_code }}<br>
                        @endif
                        {{ $branch->country ?: '' }}
                    </p>
                    @if($branch->location_lat && $branch->location_lng)
                    <p class="mb-1">
                        <small>
                            <i class="bi bi-geo-alt me-1"></i> 
                            الإحداثيات: {{ $branch->location_lat }}, {{ $branch->location_lng }}
                        </small>
                    </p>
                    @endif
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">الشركة</h6>
                    <p class="mb-1"><strong>الشركة:</strong> <a href="{{ route('companies.show', $branch->company_id) }}">{{ $branch->company->name }}</a></p>
                </div>
                
                @if($branch->notes)
                <div class="mb-3">
                    <h6 class="font-weight-bold">ملاحظات</h6>
                    <p class="mb-1">{{ $branch->notes }}</p>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-md-8 mb-4">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">إحصائيات الفرع</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4 mb-4">
                        <div class="card border-left-primary shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            المستخدمين</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['users_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-people fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card border-left-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            العملاء</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['customers_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-person-badge fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card border-left-info shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            المصاعد</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['elevators_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-arrow-up-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            عقود الصيانة</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['contracts_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-file-earmark-text fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            الفواتير</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['invoices_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-receipt fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="d-flex justify-content-between flex-wrap">
                            <a href="{{ route('users.index', ['branch_id' => $branch->id]) }}" class="btn btn-primary mb-2">
                                <i class="bi bi-people"></i> إدارة المستخدمين
                            </a>
                            <a href="{{ route('customers.index', ['branch_id' => $branch->id]) }}" class="btn btn-success mb-2">
                                <i class="bi bi-person-badge"></i> إدارة العملاء
                            </a>
                            <a href="{{ route('elevators.index', ['branch_id' => $branch->id]) }}" class="btn btn-info mb-2">
                                <i class="bi bi-arrow-up-square"></i> إدارة المصاعد
                            </a>
                            <a href="{{ route('maintenance-contracts.index', ['branch_id' => $branch->id]) }}" class="btn btn-warning mb-2">
                                <i class="bi bi-file-earmark-text"></i> عقود الصيانة
                            </a>
                            <a href="{{ route('invoices.index', ['branch_id' => $branch->id]) }}" class="btn btn-danger mb-2">
                                <i class="bi bi-receipt"></i> الفواتير
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection