@extends('layouts.modern')

@section('title', 'الفروع')

@section('header', 'إدارة الفروع')

@section('content')
<!-- Floating Action Button -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 5">
    <a href="{{ route('branches.create') }}" class="btn btn-primary btn-lg rounded-circle shadow">
        <i class="bi bi-plus-lg"></i>
    </a>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary">جميع الفروع</h6>
        <a href="{{ route('branches.create') }}" class="btn btn-primary btn-sm">
            <i class="bi bi-plus-circle"></i> إضافة فرع جديد
        </a>
    </div>
    <div class="card-body">
        @if($branches->count() > 0)
        <div class="table-responsive">
            <table class="table table-bordered" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>اسم الفرع</th>
                        <th>الرمز</th>
                        <th>المدير</th>
                        <th>رقم الهاتف</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($branches as $branch)
                    <tr>
                        <td>
                            {{ $branch->name }}
                            @if($branch->is_main_branch)
                                <span class="badge bg-info">رئيسي</span>
                            @endif
                        </td>
                        <td>{{ $branch->code }}</td>
                        <td>{{ $branch->manager_name }}</td>
                        <td>{{ $branch->phone }}</td>
                        <td>
                            @if($branch->is_active)
                                <span class="badge bg-success">نشط</span>
                            @else
                                <span class="badge bg-danger">غير نشط</span>
                            @endif
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('branches.show', $branch->id) }}" class="btn btn-info btn-sm" title="عرض التفاصيل">
                                    <i class="bi bi-eye"></i> عرض
                                </a>
                                <a href="{{ route('branches.edit', $branch->id) }}" class="btn btn-primary btn-sm" title="تعديل الفرع">
                                    <i class="bi bi-pencil"></i> تعديل
                                </a>
                                @if(!$branch->is_main_branch)
                                <form action="{{ route('branches.destroy', $branch->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" title="حذف الفرع" onclick="return confirm('هل أنت متأكد من رغبتك في حذف هذا الفرع؟')">
                                        <i class="bi bi-trash"></i> حذف
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-center mt-4">
            {{ $branches->links() }}
        </div>
        @else
        <div class="text-center py-4">
            <h4>لا توجد فروع</h4>
            <p>لا يوجد أي فروع مسجلة للشركة حتى الآن.</p>
            <a href="{{ route('branches.create') }}" class="btn btn-primary mt-3">
                <i class="bi bi-plus-circle"></i> إضافة فرع جديد
            </a>
        </div>
        @endif
    </div>
</div>
@endsection