@extends('layouts.modern')

@section('title', 'تعديل الفرع')

@section('header', 'تعديل الفرع: ' . $branch->name)

@section('content')
<!-- Floating Save Button -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 5">
    <button type="button" class="btn btn-success btn-lg rounded-circle shadow" onclick="document.getElementById('branch-form').submit()">
        <i class="bi bi-check-lg"></i>
    </button>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary">بيانات الفرع</h6>
        <div>
            <a href="{{ route('branches.show', $branch->id) }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-right"></i> العودة للتفاصيل
            </a>
        </div>
    </div>
    <div class="card-body">
        <form action="{{ route('branches.update', $branch->id) }}" method="POST" id="branch-form">
            @csrf
            @method('PUT')
            
            @if(isset($companies))
            <div class="row mb-3">
                <div class="col-md-12">
                    <div class="mb-3">
                        <label for="company_id" class="form-label">الشركة <span class="text-danger">*</span></label>
                        <select class="form-select @error('company_id') is-invalid @enderror" id="company_id" name="company_id" required>
                            <option value="">اختر الشركة</option>
                            @foreach($companies as $company)
                                <option value="{{ $company->id }}" {{ old('company_id', $branch->company_id) == $company->id ? 'selected' : '' }}>{{ $company->name }}</option>
                            @endforeach
                        </select>
                        @error('company_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            @endif
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name" class="form-label">اسم الفرع <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $branch->name) }}" required placeholder="أدخل اسم الفرع بالعربية">
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name_en" class="form-label">اسم الفرع بالإنجليزية</label>
                        <input type="text" class="form-control @error('name_en') is-invalid @enderror" id="name_en" name="name_en" value="{{ old('name_en', $branch->name_en) }}" placeholder="Enter branch name in English">
                        @error('name_en')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="code" class="form-label">رمز الفرع <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" name="code" value="{{ old('code', $branch->code) }}" required placeholder="مثال: MAIN-01">
                        @error('code')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="manager_name" class="form-label">اسم المدير</label>
                        <input type="text" class="form-control @error('manager_name') is-invalid @enderror" id="manager_name" name="manager_name" value="{{ old('manager_name', $branch->manager_name) }}" placeholder="أدخل اسم مدير الفرع">
                        @error('manager_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="email" class="form-label">البريد الإلكتروني</label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $branch->email) }}" placeholder="example@company.com">
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="phone" class="form-label">رقم الهاتف</label>
                        <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone', $branch->phone) }}" placeholder="05xxxxxxxx">
                        @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="mobile" class="form-label">رقم الجوال</label>
                        <input type="text" class="form-control @error('mobile') is-invalid @enderror" id="mobile" name="mobile" value="{{ old('mobile', $branch->mobile) }}" placeholder="05xxxxxxxx">
                        @error('mobile')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="address" class="form-label">العنوان</label>
                        <input type="text" class="form-control @error('address') is-invalid @enderror" id="address" name="address" value="{{ old('address', $branch->address) }}" placeholder="أدخل عنوان الفرع بالعربية">
                        @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="address_en" class="form-label">العنوان بالإنجليزية</label>
                        <input type="text" class="form-control @error('address_en') is-invalid @enderror" id="address_en" name="address_en" value="{{ old('address_en', $branch->address_en) }}" placeholder="Enter branch address in English">
                        @error('address_en')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="city" class="form-label">المدينة</label>
                        <input type="text" class="form-control @error('city') is-invalid @enderror" id="city" name="city" value="{{ old('city', $branch->city) }}" placeholder="الرياض">
                        @error('city')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="state" class="form-label">المنطقة</label>
                        <input type="text" class="form-control @error('state') is-invalid @enderror" id="state" name="state" value="{{ old('state', $branch->state) }}" placeholder="منطقة الرياض">
                        @error('state')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="country" class="form-label">الدولة</label>
                        <input type="text" class="form-control @error('country') is-invalid @enderror" id="country" name="country" value="{{ old('country', $branch->country) ?: 'المملكة العربية السعودية' }}">
                        @error('country')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="postal_code" class="form-label">الرمز البريدي</label>
                        <input type="text" class="form-control @error('postal_code') is-invalid @enderror" id="postal_code" name="postal_code" value="{{ old('postal_code', $branch->postal_code) }}" placeholder="12345">
                        @error('postal_code')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="location_lat" class="form-label">خط العرض (Latitude)</label>
                        <input type="text" class="form-control @error('location_lat') is-invalid @enderror" id="location_lat" name="location_lat" value="{{ old('location_lat', $branch->location_lat) }}" placeholder="24.7136">
                        @error('location_lat')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="location_lng" class="form-label">خط الطول (Longitude)</label>
                        <input type="text" class="form-control @error('location_lng') is-invalid @enderror" id="location_lng" name="location_lng" value="{{ old('location_lng', $branch->location_lng) }}" placeholder="46.6753">
                        @error('location_lng')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-12">
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $branch->notes) }}</textarea>
                        @error('notes')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="mb-3 mt-2">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_main_branch" name="is_main_branch" value="1" {{ old('is_main_branch', $branch->is_main_branch) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_main_branch">
                                تعيين كفرع رئيسي
                            </label>
                            <small class="form-text text-muted d-block">إذا تم تحديد هذا الخيار، سيتم تعيين هذا الفرع كفرع رئيسي للشركة.</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3 mt-2">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $branch->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                نشط
                            </label>
                            <small class="form-text text-muted d-block">إذا لم يتم تحديد هذا الخيار، سيتم تعيين هذا الفرع كغير نشط.</small>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="d-flex justify-content-between">
                <a href="{{ route('branches.show', $branch->id) }}" class="btn btn-secondary">إلغاء</a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> حفظ التغييرات
                </button>
            </div>
        </form>
    </div>
</div>
@endsection