@extends('layouts.modern')

@section('title', 'إضافة فرع جديد')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">إضافة فرع جديد</h5>
                </div>
                <div class="card-body">
                    <form id="create-branch-form" action="{{ route('branches.store') }}" method="POST">
                        @csrf
                        
                        @if(isset($companies))
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <label for="company_id" class="form-label">الشركة <span class="text-danger">*</span></label>
                                <select class="form-select @error('company_id') is-invalid @enderror" id="company_id" name="company_id" required>
                                    <option value="">اختر الشركة</option>
                                    @foreach($companies as $company)
                                        <option value="{{ $company->id }}" {{ old('company_id') == $company->id ? 'selected' : '' }}>{{ $company->name }}</option>
                                    @endforeach
                                </select>
                                @error('company_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        @else
                        <input type="hidden" name="company_id" value="{{ $company->id }}">
                        @endif
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="name" class="form-label">اسم الفرع <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required placeholder="أدخل اسم الفرع بالعربية">
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="name_en" class="form-label">اسم الفرع بالإنجليزية</label>
                                <input type="text" class="form-control @error('name_en') is-invalid @enderror" id="name_en" name="name_en" value="{{ old('name_en') }}" placeholder="Enter branch name in English">
                                @error('name_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="code" class="form-label">رمز الفرع</label>
                                <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" name="code" value="{{ old('code') }}" placeholder="مثال: MAIN-01">
                                @error('code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="manager_name" class="form-label">اسم المدير</label>
                                <input type="text" class="form-control @error('manager_name') is-invalid @enderror" id="manager_name" name="manager_name" value="{{ old('manager_name') }}" placeholder="أدخل اسم مدير الفرع">
                                @error('manager_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label for="email" class="form-label">البريد الإلكتروني</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email') }}" placeholder="example@company.com">
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label for="phone" class="form-label">رقم الهاتف</label>
                                <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone') }}" placeholder="05xxxxxxxx">
                                @error('phone')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label for="mobile" class="form-label">رقم الجوال</label>
                                <input type="text" class="form-control @error('mobile') is-invalid @enderror" id="mobile" name="mobile" value="{{ old('mobile') }}" placeholder="05xxxxxxxx">
                                @error('mobile')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="address" class="form-label">العنوان</label>
                                <input type="text" class="form-control @error('address') is-invalid @enderror" id="address" name="address" value="{{ old('address') }}" placeholder="أدخل عنوان الفرع بالعربية">
                                @error('address')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="address_en" class="form-label">العنوان بالإنجليزية</label>
                                <input type="text" class="form-control @error('address_en') is-invalid @enderror" id="address_en" name="address_en" value="{{ old('address_en') }}" placeholder="Enter branch address in English">
                                @error('address_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-3">
                                <label for="city" class="form-label">المدينة</label>
                                <input type="text" class="form-control @error('city') is-invalid @enderror" id="city" name="city" value="{{ old('city') }}" placeholder="الرياض">
                                @error('city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-3">
                                <label for="state" class="form-label">المنطقة</label>
                                <input type="text" class="form-control @error('state') is-invalid @enderror" id="state" name="state" value="{{ old('state') }}" placeholder="منطقة الرياض">
                                @error('state')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-3">
                                <label for="country" class="form-label">الدولة</label>
                                <input type="text" class="form-control @error('country') is-invalid @enderror" id="country" name="country" value="{{ old('country', 'المملكة العربية السعودية') }}">
                                @error('country')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-3">
                                <label for="postal_code" class="form-label">الرمز البريدي</label>
                                <input type="text" class="form-control @error('postal_code') is-invalid @enderror" id="postal_code" name="postal_code" value="{{ old('postal_code') }}" placeholder="12345">
                                @error('postal_code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="location_lat" class="form-label">خط العرض (Latitude)</label>
                                <input type="text" class="form-control @error('location_lat') is-invalid @enderror" id="location_lat" name="location_lat" value="{{ old('location_lat') }}" placeholder="24.7136">
                                @error('location_lat')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="location_lng" class="form-label">خط الطول (Longitude)</label>
                                <input type="text" class="form-control @error('location_lng') is-invalid @enderror" id="location_lng" name="location_lng" value="{{ old('location_lng') }}" placeholder="46.6753">
                                @error('location_lng')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <label for="notes" class="form-label">ملاحظات</label>
                                <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                                @error('notes')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-check mt-2">
                                    <input class="form-check-input" type="checkbox" id="is_main_branch" name="is_main_branch" value="1" {{ old('is_main_branch') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_main_branch">
                                        تعيين كفرع رئيسي
                                    </label>
                                    <small class="form-text text-muted d-block">إذا تم تحديد هذا الخيار، سيتم تعيين هذا الفرع كفرع رئيسي للشركة.</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-4">
                            <div class="col-md-12 d-flex justify-content-between">
                                <a href="{{ route('branches.index') }}" class="btn btn-outline-secondary" id="cancel-button">
                                    <i class="bi bi-x-circle"></i> إلغاء
                                </a>
                                <button type="submit" class="btn btn-primary" id="submit-button">
                                    <i class="bi bi-plus-circle"></i> إضافة الفرع
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- زر عائم للحفظ -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 1050">
    <button type="button" class="btn btn-success btn-lg rounded-circle shadow" id="floating-save-button">
        <i class="bi bi-check-lg"></i>
    </button>
</div>
@endsection

@section('styles')
<style>
    /* تحسين مظهر الأزرار */
    .btn {
        cursor: pointer !important;
        pointer-events: auto !important;
        opacity: 1 !important;
        transition: all 0.3s ease;
    }
    
    .btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }
    
    /* تنسيق الزر العائم */
    #floating-save-button {
        width: 60px;
        height: 60px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3) !important;
    }
    
    /* تحسين مظهر النموذج */
    .form-control:focus, .form-select:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 0.25rem rgba(78, 115, 223, 0.25);
    }
    
    .card {
        border: none;
        border-radius: 0.5rem;
        overflow: hidden;
    }
    
    .card-header {
        border-bottom: none;
        padding: 1rem 1.5rem;
    }
    
    .form-label {
        font-weight: 600;
    }
    
    .text-danger {
        font-weight: bold;
    }
</style>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تعريف العناصر
        const form = document.getElementById('create-branch-form');
        const submitButton = document.getElementById('submit-button');
        const cancelButton = document.getElementById('cancel-button');
        const floatingSaveButton = document.getElementById('floating-save-button');
        
        // التأكد من وجود العناصر قبل إضافة مستمعي الأحداث
        if (form) {
            console.log('تم العثور على النموذج');
            
            // إضافة مستمع حدث للنموذج
            form.addEventListener('submit', function(e) {
                console.log('تم تقديم النموذج');
                // السماح بالسلوك الافتراضي للنموذج
            });
        } else {
            console.error('لم يتم العثور على النموذج!');
        }
        
        // إضافة مستمع حدث لزر الإضافة
        if (submitButton) {
            console.log('تم العثور على زر الإضافة');
            
            submitButton.addEventListener('click', function(e) {
                e.preventDefault();
                console.log('تم النقر على زر الإضافة');
                
                if (form) {
                    // التحقق من صحة النموذج
                    if (form.checkValidity()) {
                        console.log('النموذج صالح، جاري الإرسال...');
                        form.submit();
                    } else {
                        console.log('النموذج غير صالح، يرجى التحقق من الحقول المطلوبة');
                        // تشغيل التحقق من صحة النموذج لإظهار رسائل الخطأ
                        form.reportValidity();
                    }
                }
            });
        } else {
            console.error('لم يتم العثور على زر الإضافة!');
        }
        
        // إضافة مستمع حدث لزر الإلغاء
        if (cancelButton) {
            console.log('تم العثور على زر الإلغاء');
            
            cancelButton.addEventListener('click', function(e) {
                e.preventDefault();
                console.log('تم النقر على زر الإلغاء');
                window.location.href = "{{ route('branches.index') }}";
            });
        } else {
            console.error('لم يتم العثور على زر الإلغاء!');
        }
        
        // إضافة مستمع حدث للزر العائم
        if (floatingSaveButton) {
            console.log('تم العثور على الزر العائم');
            
            floatingSaveButton.addEventListener('click', function(e) {
                e.preventDefault();
                console.log('تم النقر على الزر العائم');
                
                if (form) {
                    // التحقق من صحة النموذج
                    if (form.checkValidity()) {
                        console.log('النموذج صالح، جاري الإرسال...');
                        form.submit();
                    } else {
                        console.log('النموذج غير صالح، يرجى التحقق من الحقول المطلوبة');
                        // تشغيل التحقق من صحة النموذج لإظهار رسائل الخطأ
                        form.reportValidity();
                    }
                }
            });
        } else {
            console.error('لم يتم العثور على الزر العائم!');
        }
        
        // إضافة تأثيرات بصرية للأزرار
        const allButtons = document.querySelectorAll('.btn');
        allButtons.forEach(function(btn) {
            btn.addEventListener('mousedown', function() {
                this.style.transform = 'scale(0.95)';
            });
            
            btn.addEventListener('mouseup', function() {
                this.style.transform = 'scale(1)';
            });
            
            btn.addEventListener('mouseleave', function() {
                this.style.transform = 'scale(1)';
            });
        });
        
        // التأكد من أن جميع الحقول المطلوبة تعمل بشكل صحيح
        const requiredInputs = document.querySelectorAll('input[required], select[required]');
        requiredInputs.forEach(function(input) {
            input.addEventListener('invalid', function() {
                console.log('حقل غير صالح: ' + this.name);
            });
        });
        
        // طباعة رسالة للتأكد من تحميل السكريبت
        console.log('تم تحميل سكريبت إنشاء الفرع بنجاح');
    });
</script>
@endsection