@extends('layouts.app')

@section('title')
    @if($transaction->type == 'deposit')
        إيصال إيداع بنكي #{{ $transaction->reference_number }}
    @elseif($transaction->type == 'withdrawal')
        إيصال سحب بنكي #{{ $transaction->reference_number }}
    @elseif($transaction->type == 'transfer_in')
        إيصال تحويل وارد #{{ $transaction->reference_number }}
    @elseif($transaction->type == 'transfer_out')
        إيصال تحويل صادر #{{ $transaction->reference_number }}
    @endif
@endsection

@section('styles')
<style>
    /* تنسيقات عامة للإيصال */
    .receipt-container {
        background-color: #fff;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(0, 0, 0, 0.05);
        overflow: hidden;
    }
    
    .receipt-header {
        text-align: center;
        padding: 20px;
        border-bottom: 2px dashed #e0e0e0;
        position: relative;
    }
    
    .receipt-logo {
        max-width: 120px;
        margin-bottom: 15px;
    }
    
    .receipt-title {
        font-size: 24px;
        font-weight: bold;
        margin-bottom: 5px;
    }
    
    .receipt-subtitle {
        color: #6c757d;
        font-size: 16px;
    }
    
    .receipt-number {
        font-size: 18px;
        color: #495057;
        margin-top: 10px;
    }
    
    .receipt-date {
        font-size: 14px;
        color: #6c757d;
    }
    
    .transaction-amount {
        text-align: center;
        padding: 20px;
        background-color: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }
    
    .amount-value {
        font-size: 32px;
        font-weight: bold;
    }
    
    .amount-deposit {
        color: #28a745;
    }
    
    .amount-withdrawal {
        color: #dc3545;
    }
    
    .amount-transfer-in {
        color: #17a2b8;
    }
    
    .amount-transfer-out {
        color: #fd7e14;
    }
    
    .amount-currency {
        font-size: 16px;
        color: #6c757d;
        margin-right: 5px;
    }
    
    .info-section {
        padding: 20px;
        border-bottom: 1px solid #e9ecef;
    }
    
    .info-title {
        font-size: 18px;
        font-weight: bold;
        margin-bottom: 15px;
        color: #495057;
        padding-bottom: 10px;
        border-bottom: 1px solid #e9ecef;
    }
    
    .info-row {
        display: flex;
        margin-bottom: 12px;
    }
    
    .info-label {
        width: 40%;
        font-weight: bold;
        color: #6c757d;
    }
    
    .info-value {
        width: 60%;
        color: #212529;
    }
    
    .badge-transaction {
        font-size: 14px;
        padding: 8px 15px;
        border-radius: 20px;
    }
    
    .attachment-section {
        padding: 20px;
        text-align: center;
        border-bottom: 1px solid #e9ecef;
    }
    
    .attachment-preview {
        max-width: 100%;
        max-height: 300px;
        border-radius: 5px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        margin: 15px 0;
    }
    
    .receipt-footer {
        text-align: center;
        padding: 20px;
        border-top: 2px dashed #e0e0e0;
        color: #6c757d;
    }
    
    .action-buttons {
        display: flex;
        justify-content: center;
        gap: 10px;
        padding: 20px;
    }
    
    .btn-receipt {
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: bold;
        transition: all 0.3s;
    }
    
    .btn-receipt:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    
    .watermark {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%) rotate(-45deg);
        font-size: 100px;
        opacity: 0.03;
        color: #000;
        pointer-events: none;
        z-index: 1;
        white-space: nowrap;
    }
    
    /* تنسيقات خاصة بالطباعة */
    @media print {
        body {
            background-color: white !important;
        }
        
        .no-print {
            display: none !important;
        }
        
        .container-fluid {
            width: 100% !important;
            padding: 0 !important;
            margin: 0 !important;
        }
        
        .receipt-container {
            box-shadow: none !important;
            margin: 0 !important;
            width: 100% !important;
        }
        
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        
        .receipt-footer {
            position: fixed;
            bottom: 0;
            width: 100%;
        }
        
        .watermark {
            opacity: 0.05;
        }
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center no-print">
                    <h3 class="mb-0">
                        @if($transaction->type == 'deposit')
                            <i class="fas fa-money-bill-wave text-success ml-2"></i> إيصال إيداع بنكي
                        @elseif($transaction->type == 'withdrawal')
                            <i class="fas fa-money-bill-wave text-danger ml-2"></i> إيصال سحب بنكي
                        @elseif($transaction->type == 'transfer_in')
                            <i class="fas fa-exchange-alt text-info ml-2"></i> إيصال تحويل وارد
                        @elseif($transaction->type == 'transfer_out')
                            <i class="fas fa-exchange-alt text-warning ml-2"></i> إيصال تحويل صادر
                        @endif
                    </h3>
                    <div>
                        <button onclick="window.print()" class="btn btn-primary">
                            <i class="fas fa-print ml-2"></i> طباعة الإيصال
                        </button>
                        <a href="{{ route('bank-transactions.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right ml-2"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body p-0">
                    @if(session('success'))
                        <div class="alert alert-success m-3 no-print">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="receipt-container">
                        <!-- رأس الإيصال -->
                        <div class="receipt-header">
                            <div class="watermark">
                                @if($transaction->type == 'deposit')
                                    إيداع بنكي
                                @elseif($transaction->type == 'withdrawal')
                                    سحب بنكي
                                @elseif($transaction->type == 'transfer_in')
                                    تحويل وارد
                                @elseif($transaction->type == 'transfer_out')
                                    تحويل صادر
                                @endif
                            </div>
                            
                            <img src="{{ asset('img/logo.png') }}" alt="شعار الشركة" class="receipt-logo">
                            
                            <div class="receipt-title">
                                @if($transaction->type == 'deposit')
                                    إيصال إيداع بنكي
                                @elseif($transaction->type == 'withdrawal')
                                    إيصال سحب بنكي
                                @elseif($transaction->type == 'transfer_in')
                                    إيصال تحويل وارد
                                @elseif($transaction->type == 'transfer_out')
                                    إيصال تحويل صادر
                                @endif
                            </div>
                            
                            <div class="receipt-subtitle">{{ $transaction->bankAccount->bank->name }} - {{ $transaction->bankAccount->account_name }}</div>
                            
                            <div class="receipt-number">رقم المرجع: #{{ $transaction->reference_number }}</div>
                            
                            <div class="receipt-date">
                                <i class="far fa-calendar-alt ml-1"></i>
                                تاريخ المعاملة: {{ $transaction->transaction_date->format('Y-m-d') }}
                            </div>
                        </div>
                        
                        <!-- قسم المبلغ -->
                        <div class="transaction-amount">
                            <div class="mb-2">
                                @if($transaction->type == 'deposit')
                                    <span class="badge badge-success badge-transaction">إيداع</span>
                                @elseif($transaction->type == 'withdrawal')
                                    <span class="badge badge-danger badge-transaction">سحب</span>
                                @elseif($transaction->type == 'transfer_in')
                                    <span class="badge badge-info badge-transaction">تحويل وارد</span>
                                @elseif($transaction->type == 'transfer_out')
                                    <span class="badge badge-warning badge-transaction">تحويل صادر</span>
                                @endif
                            </div>
                            
                            <div class="amount-value 
                                @if($transaction->type == 'deposit') amount-deposit
                                @elseif($transaction->type == 'withdrawal') amount-withdrawal
                                @elseif($transaction->type == 'transfer_in') amount-transfer-in
                                @elseif($transaction->type == 'transfer_out') amount-transfer-out
                                @endif">
                                {{ in_array($transaction->type, ['deposit', 'transfer_in']) ? '+' : '-' }}{{ number_format($transaction->amount, 2) }}
                                <span class="amount-currency">{{ $transaction->bankAccount->currency }}</span>
                            </div>
                        </div>
                        
                        <!-- معلومات المعاملة والحساب -->
                        <div class="row mx-0">
                            <div class="col-md-6 px-0">
                                <div class="info-section">
                                    <h5 class="info-title">
                                        <i class="fas fa-info-circle ml-2"></i>
                                        معلومات المعاملة
                                    </h5>
                                    
                                    <div class="info-row">
                                        <div class="info-label">تاريخ المعاملة</div>
                                        <div class="info-value">{{ $transaction->transaction_date->format('Y-m-d') }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">وقت الإنشاء</div>
                                        <div class="info-value">{{ $transaction->created_at->format('H:i:s') }}</div>
                                    </div>
                                    
                                    @if($transaction->exchange_rate && $transaction->exchange_rate != 1)
                                    <div class="info-row">
                                        <div class="info-label">سعر الصرف</div>
                                        <div class="info-value">{{ $transaction->exchange_rate }}</div>
                                    </div>
                                    @endif
                                    
                                    @if($transaction->transfer_fees > 0)
                                    <div class="info-row">
                                        <div class="info-label">رسوم التحويل</div>
                                        <div class="info-value">{{ number_format($transaction->transfer_fees, 2) }} {{ $transaction->bankAccount->currency }}</div>
                                    </div>
                                    @endif
                                    
                                    <div class="info-row">
                                        <div class="info-label">الوصف</div>
                                        <div class="info-value">{{ $transaction->description ?: 'لا يوجد وصف' }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">بواسطة</div>
                                        <div class="info-value">{{ $transaction->user->name ?? 'غير محدد' }}</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6 px-0">
                                <div class="info-section">
                                    <h5 class="info-title">
                                        <i class="fas fa-university ml-2"></i>
                                        معلومات الحساب البنكي
                                    </h5>
                                    
                                    <div class="info-row">
                                        <div class="info-label">البنك</div>
                                        <div class="info-value">{{ $transaction->bankAccount->bank->name }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">رقم الحساب</div>
                                        <div class="info-value">{{ $transaction->bankAccount->account_number }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">اسم الحساب</div>
                                        <div class="info-value">{{ $transaction->bankAccount->account_name }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">نوع الحساب</div>
                                        <div class="info-value">
                                            @if($transaction->bankAccount->account_type == 'current')
                                                حساب جاري
                                            @elseif($transaction->bankAccount->account_type == 'savings')
                                                حساب توفير
                                            @else
                                                {{ $transaction->bankAccount->account_type }}
                                            @endif
                                        </div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">العملة</div>
                                        <div class="info-value">{{ $transaction->bankAccount->currency }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- معلومات التحويل إذا كانت معاملة تحويل -->
                        @if(in_array($transaction->type, ['transfer_in', 'transfer_out']) && $relatedTransaction)
                        <div class="info-section">
                            <h5 class="info-title">
                                <i class="fas fa-exchange-alt ml-2"></i>
                                معلومات التحويل
                            </h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-row">
                                        <div class="info-label">طريقة التحويل</div>
                                        <div class="info-value">
                                            @if($transaction->transfer_method == 'online')
                                                <i class="fas fa-globe ml-1"></i> تحويل إلكتروني
                                            @elseif($transaction->transfer_method == 'wire')
                                                <i class="fas fa-university ml-1"></i> تحويل بنكي
                                            @elseif($transaction->transfer_method == 'cheque')
                                                <i class="fas fa-money-check ml-1"></i> شيك
                                            @elseif($transaction->transfer_method == 'internal')
                                                <i class="fas fa-sync ml-1"></i> تحويل داخلي
                                            @else
                                                {{ $transaction->transfer_method }}
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="info-row">
                                        <div class="info-label">{{ $transaction->type == 'transfer_out' ? 'الحساب المستلم' : 'الحساب المرسل' }}</div>
                                        <div class="info-value">
                                            {{ $relatedTransaction->bankAccount->bank->name }} - 
                                            {{ $relatedTransaction->bankAccount->account_number }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            @if($transaction->type == 'transfer_out' && $relatedTransaction->amount != $transaction->amount)
                            <div class="info-row">
                                <div class="info-label">المبلغ المستلم</div>
                                <div class="info-value">{{ number_format($relatedTransaction->amount, 2) }} {{ $relatedTransaction->bankAccount->currency }}</div>
                            </div>
                            @endif
                        </div>
                        @endif
                        
                        <!-- معلومات القيد المحاسبي -->
                        @if($transaction->journal_entry_id)
                        <div class="info-section">
                            <h5 class="info-title">
                                <i class="fas fa-file-invoice ml-2"></i>
                                القيد المحاسبي
                            </h5>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="info-row">
                                        <div class="info-label">رقم القيد</div>
                                        <div class="info-value">{{ $transaction->journalEntry->reference_number }}</div>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="info-row">
                                        <div class="info-label">تاريخ القيد</div>
                                        <div class="info-value">{{ $transaction->journalEntry->entry_date->format('Y-m-d') }}</div>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="info-row">
                                        <div class="info-label">المبلغ</div>
                                        <div class="info-value">{{ number_format($transaction->journalEntry->total_amount, 2) }}</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="text-center mt-3 no-print">
                                <a href="{{ route('journal-entries.show', $transaction->journal_entry_id) }}" class="btn btn-outline-primary btn-sm">
                                    <i class="fas fa-eye ml-1"></i> عرض القيد المحاسبي
                                </a>
                            </div>
                        </div>
                        @endif
                        
                        <!-- المرفقات -->
                        @if($transaction->attachment)
                        <div class="attachment-section">
                            <h5 class="info-title">
                                <i class="fas fa-paperclip ml-2"></i>
                                المرفقات
                            </h5>
                            
                            @php
                                $extension = pathinfo($transaction->attachment, PATHINFO_EXTENSION);
                                $isImage = in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif']);
                            @endphp
                            
                            @if($isImage)
                                <img src="{{ asset('storage/' . $transaction->attachment) }}" class="attachment-preview">
                            @else
                                <div class="my-3">
                                    <i class="fas fa-file-{{ strtolower($extension) == 'pdf' ? 'pdf' : 'alt' }} fa-3x mb-2"></i>
                                    <p>{{ strtoupper($extension) }} ملف</p>
                                </div>
                            @endif
                            
                            <div class="no-print">
                                <a href="{{ asset('storage/' . $transaction->attachment) }}" class="btn btn-info btn-sm" target="_blank">
                                    <i class="fas fa-download ml-1"></i> تحميل المرفق
                                </a>
                            </div>
                        </div>
                        @endif
                        
                        <!-- أزرار الإجراءات -->
                        <div class="action-buttons no-print">
                            @can('delete_bank_transactions')
                            <form action="{{ route('bank-transactions.destroy', $transaction) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه المعاملة؟ سيتم أيضًا حذف القيد المحاسبي المرتبط بها.');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-receipt">
                                    <i class="fas fa-trash ml-1"></i> حذف المعاملة
                                </button>
                            </form>
                            @endcan
                            
                            <a href="{{ route('bank-accounts.show', $transaction->bankAccount) }}" class="btn btn-primary btn-receipt">
                                <i class="fas fa-eye ml-1"></i> عرض الحساب
                            </a>
                            
                            <a href="{{ route('bank-accounts.statement', $transaction->bankAccount) }}" class="btn btn-info btn-receipt">
                                <i class="fas fa-file-alt ml-1"></i> كشف الحساب
                            </a>
                            
                            <button onclick="window.print()" class="btn btn-dark btn-receipt">
                                <i class="fas fa-print ml-1"></i> طباعة الإيصال
                            </button>
                        </div>
                        
                        <!-- تذييل الإيصال -->
                        <div class="receipt-footer">
                            <p>تم إنشاء هذا الإيصال بواسطة نظام إدارة المصاعد</p>
                            <p>{{ now()->format('Y-m-d H:i:s') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection