@extends('layouts.app')

@section('title', 'المعاملات البنكية')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">قائمة المعاملات البنكية</h3>
                    <div>
                        @can('create_bank_transactions')
                        <div class="btn-group" role="group">
                            <a href="{{ route('bank-transactions.create-deposit') }}" class="btn btn-success">
                                <i class="fas fa-arrow-down"></i> إيداع جديد
                            </a>
                            <a href="{{ route('bank-transactions.create-withdrawal') }}" class="btn btn-danger">
                                <i class="fas fa-arrow-up"></i> سحب جديد
                            </a>
                            <a href="{{ route('bank-transactions.create-transfer') }}" class="btn btn-primary">
                                <i class="fas fa-exchange-alt"></i> تحويل جديد
                            </a>
                        </div>
                        @endcan
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('bank-transactions.index') }}" method="GET" class="form-inline">
                                <div class="form-group mx-2">
                                    <label for="from_date" class="mx-2">من تاريخ:</label>
                                    <input type="date" id="from_date" name="from_date" class="form-control" value="{{ request('from_date') }}">
                                </div>
                                <div class="form-group mx-2">
                                    <label for="to_date" class="mx-2">إلى تاريخ:</label>
                                    <input type="date" id="to_date" name="to_date" class="form-control" value="{{ request('to_date') }}">
                                </div>
                                <div class="form-group mx-2">
                                    <label for="type" class="mx-2">نوع المعاملة:</label>
                                    <select id="type" name="type" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="deposit" {{ request('type') == 'deposit' ? 'selected' : '' }}>إيداع</option>
                                        <option value="withdrawal" {{ request('type') == 'withdrawal' ? 'selected' : '' }}>سحب</option>
                                        <option value="transfer_in" {{ request('type') == 'transfer_in' ? 'selected' : '' }}>تحويل وارد</option>
                                        <option value="transfer_out" {{ request('type') == 'transfer_out' ? 'selected' : '' }}>تحويل صادر</option>
                                    </select>
                                </div>
                                <div class="form-group mx-2">
                                    <label for="bank_account_id" class="mx-2">الحساب البنكي:</label>
                                    <select id="bank_account_id" name="bank_account_id" class="form-control">
                                        <option value="">كل الحسابات</option>
                                        @foreach($bankAccounts as $account)
                                            <option value="{{ $account->id }}" {{ request('bank_account_id') == $account->id ? 'selected' : '' }}>
                                                {{ $account->bank->name }} - {{ $account->account_number }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary mx-2">
                                    <i class="fas fa-filter"></i> تصفية
                                </button>
                                <a href="{{ route('bank-transactions.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-sync"></i> إعادة تعيين
                                </a>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>التاريخ</th>
                                    <th>رقم المرجع</th>
                                    <th>النوع</th>
                                    <th>الحساب البنكي</th>
                                    <th>المبلغ</th>
                                    <th>الوصف</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transactions as $transaction)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                        <td>{{ $transaction->reference_number }}</td>
                                        <td>
                                            @if($transaction->type == 'deposit')
                                                <span class="badge badge-success">إيداع</span>
                                            @elseif($transaction->type == 'withdrawal')
                                                <span class="badge badge-danger">سحب</span>
                                            @elseif($transaction->type == 'transfer_in')
                                                <span class="badge badge-primary">تحويل وارد</span>
                                            @elseif($transaction->type == 'transfer_out')
                                                <span class="badge badge-warning">تحويل صادر</span>
                                            @endif
                                        </td>
                                        <td>
                                            {{ $transaction->bankAccount->bank->name }} - 
                                            {{ $transaction->bankAccount->account_number }}
                                        </td>
                                        <td>
                                            @if(in_array($transaction->type, ['deposit', 'transfer_in']))
                                                <span class="text-success">+{{ number_format($transaction->amount, 2) }}</span>
                                            @else
                                                <span class="text-danger">-{{ number_format($transaction->amount, 2) }}</span>
                                            @endif
                                            {{ $transaction->bankAccount->currency }}
                                        </td>
                                        <td>{{ Str::limit($transaction->description, 30) }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                @can('view_bank_transactions')
                                                <a href="{{ route('bank-transactions.show', $transaction) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('delete_bank_transactions')
                                                <form action="{{ route('bank-transactions.destroy', $transaction) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه المعاملة؟');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد معاملات بنكية مسجلة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-center mt-4">
                        {{ $transactions->appends(request()->except('page'))->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection