@extends('layouts.app')

@section('title', 'تعديل سحب بنكي')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">تعديل سحب بنكي</h3>
                    <a href="{{ route('bank-transactions.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('bank-transactions.update-withdrawal', $transaction->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bank_account_id">الحساب البنكي <span class="text-danger">*</span></label>
                                    <select class="form-control @error('bank_account_id') is-invalid @enderror" id="bank_account_id" name="bank_account_id" required>
                                        <option value="">-- اختر الحساب البنكي --</option>
                                        @foreach($bankAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('bank_account_id', $transaction->bank_account_id) == $account->id ? 'selected' : '' }}
                                                data-currency="{{ $account->currency }}" data-balance="{{ $account->current_balance + ($transaction->bank_account_id == $account->id ? $transaction->amount : 0) }}">
                                                {{ $account->bank->name }} - {{ $account->account_number }} ({{ $account->currency }}) - الرصيد: {{ number_format($account->current_balance + ($transaction->bank_account_id == $account->id ? $transaction->amount : 0), 2) }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('bank_account_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="transaction_date">تاريخ المعاملة <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('transaction_date') is-invalid @enderror" id="transaction_date" name="transaction_date" value="{{ old('transaction_date', $transaction->transaction_date->format('Y-m-d')) }}" required>
                                    @error('transaction_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">المبلغ <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" step="0.01" min="0.01" class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount" value="{{ old('amount', $transaction->amount) }}" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text" id="currency-addon">العملة</span>
                                        </div>
                                    </div>
                                    <small class="form-text text-muted" id="balance-info"></small>
                                    @error('amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="reference_number">رقم المرجع</label>
                                    <input type="text" class="form-control @error('reference_number') is-invalid @enderror" id="reference_number" name="reference_number" value="{{ old('reference_number', $transaction->reference_number) }}">
                                    @error('reference_number')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="withdrawal_method">طريقة السحب <span class="text-danger">*</span></label>
                                    <select class="form-control @error('withdrawal_method') is-invalid @enderror" id="withdrawal_method" name="withdrawal_method" required>
                                        <option value="">-- اختر طريقة السحب --</option>
                                        <option value="cash" {{ old('withdrawal_method', $transaction->withdrawal_method) == 'cash' ? 'selected' : '' }}>نقدي</option>
                                        <option value="cheque" {{ old('withdrawal_method', $transaction->withdrawal_method) == 'cheque' ? 'selected' : '' }}>شيك</option>
                                        <option value="transfer" {{ old('withdrawal_method', $transaction->withdrawal_method) == 'transfer' ? 'selected' : '' }}>تحويل بنكي</option>
                                        <option value="other" {{ old('withdrawal_method', $transaction->withdrawal_method) == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('withdrawal_method')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="destination">وجهة السحب <span class="text-danger">*</span></label>
                                    <select class="form-control @error('destination') is-invalid @enderror" id="destination" name="destination" required>
                                        <option value="">-- اختر وجهة السحب --</option>
                                        <option value="supplier" {{ old('destination', $transaction->destination) == 'supplier' ? 'selected' : '' }}>مورد</option>
                                        <option value="cash_register" {{ old('destination', $transaction->destination) == 'cash_register' ? 'selected' : '' }}>خزينة</option>
                                        <option value="expense" {{ old('destination', $transaction->destination) == 'expense' ? 'selected' : '' }}>مصروفات</option>
                                        <option value="owner" {{ old('destination', $transaction->destination) == 'owner' ? 'selected' : '' }}>مالك الشركة</option>
                                        <option value="other" {{ old('destination', $transaction->destination) == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('destination')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row destination-details" id="supplier-details" style="display: none;">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="supplier_id">المورد</label>
                                    <select class="form-control @error('supplier_id') is-invalid @enderror" id="supplier_id" name="supplier_id">
                                        <option value="">-- اختر المورد --</option>
                                        @foreach($suppliers as $supplier)
                                            <option value="{{ $supplier->id }}" {{ old('supplier_id', $transaction->supplier_id) == $supplier->id ? 'selected' : '' }}>
                                                {{ $supplier->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('supplier_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bill_id">الفاتورة</label>
                                    <select class="form-control @error('bill_id') is-invalid @enderror" id="bill_id" name="bill_id">
                                        <option value="">-- اختر الفاتورة --</option>
                                    </select>
                                    @error('bill_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row destination-details" id="cash-register-details" style="display: none;">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="cash_register_id">الخزينة</label>
                                    <select class="form-control @error('cash_register_id') is-invalid @enderror" id="cash_register_id" name="cash_register_id">
                                        <option value="">-- اختر الخزينة --</option>
                                        @foreach($cashRegisters as $register)
                                            <option value="{{ $register->id }}" {{ old('cash_register_id', $transaction->cash_register_id) == $register->id ? 'selected' : '' }}>
                                                {{ $register->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('cash_register_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row destination-details" id="expense-details" style="display: none;">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="expense_category_id">فئة المصروفات</label>
                                    <select class="form-control @error('expense_category_id') is-invalid @enderror" id="expense_category_id" name="expense_category_id">
                                        <option value="">-- اختر فئة المصروفات --</option>
                                        @foreach($expenseCategories as $category)
                                            <option value="{{ $category->id }}" {{ old('expense_category_id', $transaction->expense_category_id) == $category->id ? 'selected' : '' }}>
                                                {{ $category->name }} ({{ $category->account_code }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('expense_category_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="debit_account_id">الحساب المدين <span class="text-danger">*</span></label>
                                    <select class="form-control select2 @error('debit_account_id') is-invalid @enderror" id="debit_account_id" name="debit_account_id" required>
                                        <option value="">-- اختر الحساب المدين --</option>
                                        @foreach($chartAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('debit_account_id', $debitAccountId) == $account->id ? 'selected' : '' }}>
                                                {{ $account->account_code }} - {{ $account->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('debit_account_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">الوصف <span class="text-danger">*</span></label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" required>{{ old('description', $transaction->description) }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="attachment">المرفقات</label>
                                    <input type="file" class="form-control-file @error('attachment') is-invalid @enderror" id="attachment" name="attachment">
                                    <small class="form-text text-muted">يمكنك إرفاق صورة أو مستند للسحب (PDF, JPG, PNG)</small>
                                    @if($transaction->attachment)
                                        <div class="mt-2">
                                            <a href="{{ asset('storage/' . $transaction->attachment) }}" target="_blank" class="btn btn-sm btn-info">
                                                <i class="fas fa-file"></i> عرض المرفق الحالي
                                            </a>
                                        </div>
                                    @endif
                                    @error('attachment')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group text-center mt-4">
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-save"></i> تحديث السحب
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تفعيل Select2 للحساب المدين
        $('.select2').select2({
            placeholder: "اختر الحساب المدين",
            allowClear: true,
            width: '100%',
            dir: 'rtl'
        });
        
        // تحديث عملة المبلغ ومعلومات الرصيد عند اختيار الحساب البنكي
        $('#bank_account_id').change(function() {
            var selected = $(this).find(':selected');
            var currency = selected.data('currency');
            var balance = selected.data('balance');
            
            $('#currency-addon').text(currency || 'العملة');
            
            if (balance !== undefined) {
                $('#balance-info').text('الرصيد المتاح: ' + balance.toFixed(2) + ' ' + currency);
            } else {
                $('#balance-info').text('');
            }
        }).trigger('change');

        // إظهار/إخفاء تفاصيل الوجهة بناءً على اختيار الوجهة
        $('#destination').change(function() {
            $('.destination-details').hide();
            var destination = $(this).val();
            
            if (destination === 'supplier') {
                $('#supplier-details').show();
            } else if (destination === 'cash_register') {
                $('#cash-register-details').show();
            } else if (destination === 'expense') {
                $('#expense-details').show();
            }
        }).trigger('change');

        // تحميل الفواتير عند اختيار المورد
        $('#supplier_id').change(function() {
            var supplierId = $(this).val();
            if (supplierId) {
                $.ajax({
                    url: '/api/suppliers/' + supplierId + '/bills',
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        var options = '<option value="">-- اختر الفاتورة --</option>';
                        $.each(data, function(key, bill) {
                            options += '<option value="' + bill.id + '">' + bill.bill_number + ' - ' + bill.total + '</option>';
                        });
                        $('#bill_id').html(options);
                        
                        // تحديد الفاتورة المحددة مسبقًا إذا وجدت
                        @if(old('bill_id', $transaction->bill_id))
                            $('#bill_id').val('{{ old('bill_id', $transaction->bill_id) }}');
                        @endif
                    }
                });
            } else {
                $('#bill_id').html('<option value="">-- اختر الفاتورة --</option>');
            }
        });
        
        // تشغيل تحميل الفواتير عند تحميل الصفحة إذا كان هناك مورد محدد
        if ($('#supplier_id').val()) {
            $('#supplier_id').trigger('change');
        }

        // التحقق من المبلغ المتاح قبل الإرسال
        $('form').submit(function(e) {
            var amount = parseFloat($('#amount').val());
            var balance = parseFloat($('#bank_account_id').find(':selected').data('balance'));
            var originalAmount = {{ $transaction->amount }};
            var originalBankId = {{ $transaction->bank_account_id }};
            var selectedBankId = $('#bank_account_id').val();
            
            // إذا كان نفس الحساب البنكي، نضيف المبلغ الأصلي إلى الرصيد للمقارنة
            if (selectedBankId == originalBankId) {
                if (amount > balance) {
                    e.preventDefault();
                    alert('المبلغ المطلوب سحبه أكبر من الرصيد المتاح في الحساب!');
                    return false;
                }
            } else {
                // إذا تم تغيير الحساب البنكي، نتحقق من الرصيد المتاح في الحساب الجديد
                if (amount > balance) {
                    e.preventDefault();
                    alert('المبلغ المطلوب سحبه أكبر من الرصيد المتاح في الحساب!');
                    return false;
                }
            }
            
            // التحقق من اختيار الحساب المدين
            if (!$('#debit_account_id').val()) {
                e.preventDefault();
                alert('يرجى اختيار الحساب المدين');
                return false;
            }
        });
    });
</script>
@endsection