@extends('layouts.app')

@section('title', 'تعديل إيداع بنكي')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">تعديل إيداع بنكي</h3>
                    <a href="{{ route('bank-transactions.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('bank-transactions.update-deposit', $transaction->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bank_account_id">الحساب البنكي <span class="text-danger">*</span></label>
                                    <select class="form-control @error('bank_account_id') is-invalid @enderror" id="bank_account_id" name="bank_account_id" required>
                                        <option value="">-- اختر الحساب البنكي --</option>
                                        @foreach($bankAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('bank_account_id', $transaction->bank_account_id) == $account->id ? 'selected' : '' }}
                                                data-currency="{{ $account->currency }}">
                                                {{ $account->bank->name }} - {{ $account->account_number }} ({{ $account->currency }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('bank_account_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="transaction_date">تاريخ المعاملة <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('transaction_date') is-invalid @enderror" id="transaction_date" name="transaction_date" value="{{ old('transaction_date', $transaction->transaction_date->format('Y-m-d')) }}" required>
                                    @error('transaction_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">المبلغ <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" step="0.01" min="0.01" class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount" value="{{ old('amount', $transaction->amount) }}" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text" id="currency-addon">العملة</span>
                                        </div>
                                    </div>
                                    @error('amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="reference_number">رقم المرجع</label>
                                    <input type="text" class="form-control @error('reference_number') is-invalid @enderror" id="reference_number" name="reference_number" value="{{ old('reference_number', $transaction->reference_number) }}">
                                    @error('reference_number')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="deposit_method">طريقة الإيداع <span class="text-danger">*</span></label>
                                    <select class="form-control @error('deposit_method') is-invalid @enderror" id="deposit_method" name="deposit_method" required>
                                        <option value="">-- اختر طريقة الإيداع --</option>
                                        <option value="cash" {{ old('deposit_method', $transaction->deposit_method) == 'cash' ? 'selected' : '' }}>نقدي</option>
                                        <option value="cheque" {{ old('deposit_method', $transaction->deposit_method) == 'cheque' ? 'selected' : '' }}>شيك</option>
                                        <option value="transfer" {{ old('deposit_method', $transaction->deposit_method) == 'transfer' ? 'selected' : '' }}>تحويل بنكي</option>
                                        <option value="other" {{ old('deposit_method', $transaction->deposit_method) == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('deposit_method')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="chart_of_account_id">الحساب (الطرف الدائن) <span class="text-danger">*</span></label>
                                    <select class="form-control @error('chart_of_account_id') is-invalid @enderror" id="chart_of_account_id" name="chart_of_account_id" required>
                                        <option value="">-- اختر الحساب --</option>
                                        @foreach($chartAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('chart_of_account_id', $sourceType == 'chart_of_account' ? $sourceId : '') == $account->id ? 'selected' : '' }}>
                                                {{ $account->account_code }} - {{ $account->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('chart_of_account_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <!-- إضافة حقل مخفي للطرف الدائن -->
                        <input type="hidden" name="source" id="source" value="chart_account">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">رقم المصعد (اختياري)</label>
                                    <select class="form-control @error('elevator_id') is-invalid @enderror" id="elevator_id" name="elevator_id">
                                        <option value="">-- اختر المصعد --</option>
                                        @foreach($elevators as $elevator)
                                            @php
                                                $elevatorId = null;
                                                if ($transaction->additional_data) {
                                                    $additionalData = json_decode($transaction->additional_data, true);
                                                    $elevatorId = $additionalData['elevator_id'] ?? null;
                                                }
                                            @endphp
                                            <option value="{{ $elevator->id }}" {{ old('elevator_id', $elevatorId) == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->serial_number }} - {{ $elevator->model }} ({{ optional($elevator->customer)->name ?? 'غير محدد' }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('elevator_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description">الوصف <span class="text-danger">*</span></label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" required>{{ old('description', $transaction->description) }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="attachment">المرفقات</label>
                                    <input type="file" class="form-control-file @error('attachment') is-invalid @enderror" id="attachment" name="attachment">
                                    <small class="form-text text-muted">يمكنك إرفاق صورة أو مستند للإيداع (PDF, JPG, PNG)</small>
                                    @if($transaction->attachment)
                                        <div class="mt-2">
                                            <a href="{{ asset('storage/' . $transaction->attachment) }}" target="_blank" class="btn btn-sm btn-info">
                                                <i class="fas fa-file"></i> عرض المرفق الحالي
                                            </a>
                                        </div>
                                    @endif
                                    @error('attachment')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group text-center mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> تحديث الإيداع
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // التحقق من تحميل jQuery
    console.log('jQuery loaded:', typeof jQuery !== 'undefined');
    console.log('$ loaded:', typeof $ !== 'undefined');
    
    // استخدام window.jQuery للتأكد من الوصول إلى jQuery
    (function($) {
        'use strict';
        
        $(document).ready(function() {
            console.log('Document ready - jQuery is working!');
            
            // تحديث عملة المبلغ عند اختيار الحساب البنكي
            $('#bank_account_id').change(function() {
                var currency = $(this).find(':selected').data('currency');
                $('#currency-addon').text(currency || 'العملة');
            }).trigger('change');
            
            // تحسين تجربة المستخدم بإضافة تلميحات للحقول
            $('#chart_of_account_id').attr('title', 'اختر الحساب المرتبط بالإيداع');
        });
    })(window.jQuery || jQuery);
</script>
@endpush