@extends('layouts.app')

@section('title', 'سحب بنكي جديد')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">سحب بنكي جديد</h3>
                    <a href="{{ route('bank-transactions.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="alert alert-info">
                        <h5><i class="fas fa-info-circle"></i> معلومات عن القيد المحاسبي للسحب البنكي</h5>
                        <p>عند إجراء سحب بنكي، يتم إنشاء قيد محاسبي كالتالي:</p>
                        <ul>
                            <li><strong>الطرف الدائن:</strong> حساب البنك (يتم خصم المبلغ من رصيد البنك)</li>
                            <li><strong>الطرف المدين:</strong> الحساب الذي تختاره (يتم إضافة المبلغ إلى هذا الحساب)</li>
                        </ul>
                    </div>

                    <form action="{{ route('bank-transactions.store-withdrawal') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bank_account_id">الحساب البنكي <span class="text-danger">*</span></label>
                                    <select class="form-control @error('bank_account_id') is-invalid @enderror" id="bank_account_id" name="bank_account_id" required>
                                        <option value="">-- اختر الحساب البنكي --</option>
                                        @foreach($bankAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('bank_account_id', request('bank_account_id')) == $account->id ? 'selected' : '' }}
                                                data-currency="{{ $account->currency }}" data-balance="{{ $account->current_balance }}">
                                                {{ $account->bank->name }} - {{ $account->account_number }} ({{ $account->currency }}) - الرصيد: {{ number_format($account->current_balance, 2) }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('bank_account_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="transaction_date">تاريخ المعاملة <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('transaction_date') is-invalid @enderror" id="transaction_date" name="transaction_date" value="{{ old('transaction_date', date('Y-m-d')) }}" required>
                                    @error('transaction_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">المبلغ <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" step="0.01" min="0.01" class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount" value="{{ old('amount') }}" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text" id="currency-addon">العملة</span>
                                        </div>
                                    </div>
                                    <small class="form-text text-muted" id="balance-info"></small>
                                    @error('amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="reference_number">رقم المرجع</label>
                                    <input type="text" class="form-control @error('reference_number') is-invalid @enderror" id="reference_number" name="reference_number" value="{{ old('reference_number') }}">
                                    @error('reference_number')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Eliminamos los campos innecesarios -->
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="debit_account_id">الطرف المدين <span class="text-danger">*</span></label>
                                    <select class="form-control select2 @error('debit_account_id') is-invalid @enderror" id="debit_account_id" name="debit_account_id" required>
                                        <option value="">-- اختر الحساب المدين --</option>
                                        @foreach($chartAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('debit_account_id') == $account->id ? 'selected' : '' }}>
                                                {{ $account->account_code }} - {{ $account->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="form-text text-muted">الحساب الذي سيتم إضافة المبلغ إليه</small>
                                    @error('debit_account_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">الوصف <span class="text-danger">*</span></label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" required>{{ old('description') }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="attachment">المرفقات</label>
                                    <input type="file" class="form-control-file @error('attachment') is-invalid @enderror" id="attachment" name="attachment">
                                    <small class="form-text text-muted">يمكنك إرفاق صورة أو مستند للسحب (PDF, JPG, PNG)</small>
                                    @error('attachment')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group text-center mt-4">
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-save"></i> حفظ السحب
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تفعيل Select2 للحساب المدين
        $('.select2').select2({
            placeholder: "اختر الحساب المدين",
            allowClear: true,
            width: '100%',
            dir: 'rtl'
        });
        
        // تحديث عملة المبلغ ومعلومات الرصيد عند اختيار الحساب البنكي
        $('#bank_account_id').change(function() {
            var selected = $(this).find(':selected');
            var currency = selected.data('currency');
            var balance = selected.data('balance');
            
            $('#currency-addon').text(currency || 'العملة');
            
            if (balance !== undefined) {
                $('#balance-info').text('الرصيد المتاح: ' + balance.toFixed(2) + ' ' + currency);
            } else {
                $('#balance-info').text('');
            }
        }).trigger('change');

        // Ya no necesitamos este código porque eliminamos los campos relacionados



        // التحقق من المبلغ المتاح قبل الإرسال
        $('form').submit(function(e) {
            var amount = parseFloat($('#amount').val());
            var balance = parseFloat($('#bank_account_id').find(':selected').data('balance'));
            
            if (amount > balance) {
                e.preventDefault();
                alert('المبلغ المطلوب سحبه أكبر من الرصيد المتاح في الحساب!');
                return false;
            }
            
            // التحقق من اختيار الطرف المدين
            if (!$('#debit_account_id').val()) {
                e.preventDefault();
                alert('يرجى اختيار الطرف المدين');
                return false;
            }
        });
    });
</script>
@endsection