@extends('layouts.app')

@section('title', __('banking.reconciliation_details'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('banking.reconciliation_details') }} #{{ $reconciliation->id }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('bank-reconciliations.index') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-arrow-left mr-1"></i> {{ __('common.back') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 mb-4">
                            <div class="d-flex justify-content-between">
                                <h4>
                                    <span class="badge badge-{{ $reconciliation->status_color }}">
                                        {{ __('banking.' . $reconciliation->status) }}
                                    </span>
                                </h4>
                                <div>
                                    @if($reconciliation->status == 'in_progress')
                                        <a href="{{ route('bank-reconciliations.edit', $reconciliation->id) }}" class="btn btn-info">
                                            <i class="fas fa-edit mr-1"></i> {{ __('common.edit') }}
                                        </a>
                                        <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal">
                                            <i class="fas fa-trash mr-1"></i> {{ __('common.delete') }}
                                        </button>
                                    @endif
                                    
                                    <a href="#" class="btn btn-secondary" onclick="window.print()">
                                        <i class="fas fa-print mr-1"></i> {{ __('common.print') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">{{ __('banking.reconciliation_information') }}</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">{{ __('banking.account') }}</th>
                                            <td>
                                                <a href="{{ route('bank-accounts.show', $reconciliation->account->id) }}">
                                                    {{ $reconciliation->account->account_number }} - {{ $reconciliation->account->bank->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.statement_date') }}</th>
                                            <td>{{ $reconciliation->statement_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.statement_balance') }}</th>
                                            <td>{{ number_format($reconciliation->statement_balance, 2) }} {{ config('app.currency_symbol') }}</td>
                                        </tr>
                                        @if($reconciliation->statement_closing_date)
                                        <tr>
                                            <th>{{ __('banking.statement_closing_date') }}</th>
                                            <td>{{ $reconciliation->statement_closing_date->format('Y-m-d') }}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th>{{ __('banking.reconciled_balance') }}</th>
                                            <td>{{ number_format($reconciliation->reconciled_balance, 2) }} {{ config('app.currency_symbol') }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.difference') }}</th>
                                            <td>
                                                @php
                                                    $difference = $reconciliation->statement_balance - $reconciliation->reconciled_balance;
                                                @endphp
                                                <span class="{{ $difference == 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($difference, 2) }} {{ config('app.currency_symbol') }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('common.status') }}</th>
                                            <td>
                                                <span class="badge badge-{{ $reconciliation->status_color }}">
                                                    {{ __('banking.' . $reconciliation->status) }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('common.created_at') }}</th>
                                            <td>{{ $reconciliation->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        @if($reconciliation->completed_at)
                                        <tr>
                                            <th>{{ __('banking.completed_at') }}</th>
                                            <td>{{ $reconciliation->completed_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th>{{ __('common.notes') }}</th>
                                            <td>{{ $reconciliation->notes ?: __('common.not_provided') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">{{ __('banking.account_information') }}</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">{{ __('banking.bank') }}</th>
                                            <td>
                                                <a href="{{ route('banks.show', $reconciliation->account->bank->id) }}">
                                                    {{ $reconciliation->account->bank->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.account_number') }}</th>
                                            <td>{{ $reconciliation->account->account_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.account_name') }}</th>
                                            <td>{{ $reconciliation->account->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.account_type') }}</th>
                                            <td>{{ __('banking.' . $reconciliation->account->type) }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.current_balance') }}</th>
                                            <td>{{ number_format($reconciliation->account->current_balance, 2) }} {{ config('app.currency_symbol') }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.last_reconciliation') }}</th>
                                            <td>
                                                @if($lastReconciliation && $lastReconciliation->id != $reconciliation->id)
                                                    <a href="{{ route('bank-reconciliations.show', $lastReconciliation->id) }}">
                                                        {{ $lastReconciliation->statement_date->format('Y-m-d') }} 
                                                        ({{ number_format($lastReconciliation->reconciled_balance, 2) }} {{ config('app.currency_symbol') }})
                                                    </a>
                                                @else
                                                    {{ __('banking.no_previous_reconciliation') }}
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">{{ __('banking.reconciled_transactions') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>{{ __('common.date') }}</th>
                                                    <th>{{ __('banking.transaction_number') }}</th>
                                                    <th>{{ __('banking.type') }}</th>
                                                    <th>{{ __('banking.description') }}</th>
                                                    <th>{{ __('banking.debit') }}</th>
                                                    <th>{{ __('banking.credit') }}</th>
                                                    <th>{{ __('common.actions') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($reconciliation->transactions as $transaction)
                                                <tr>
                                                    <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                                    <td>{{ $transaction->transaction_number }}</td>
                                                    <td>
                                                        <span class="badge badge-{{ $transaction->type_color }}">
                                                            {{ __('banking.' . $transaction->type) }}
                                                        </span>
                                                    </td>
                                                    <td>{{ Str::limit($transaction->description, 50) }}</td>
                                                    <td>
                                                        @if(in_array($transaction->type, ['withdrawal', 'transfer_out']))
                                                            {{ number_format($transaction->amount, 2) }} {{ config('app.currency_symbol') }}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(in_array($transaction->type, ['deposit', 'transfer_in']))
                                                            {{ number_format($transaction->amount, 2) }} {{ config('app.currency_symbol') }}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <a href="{{ route('bank-transactions.show', $transaction->id) }}" class="btn btn-sm btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="7" class="text-center">{{ __('common.no_records_found') }}</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                            <tfoot>
                                                <tr class="bg-light">
                                                    <th colspan="4" class="text-right">{{ __('common.total') }}:</th>
                                                    <th>
                                                        {{ number_format($reconciliation->transactions->whereIn('type', ['withdrawal', 'transfer_out'])->sum('amount'), 2) }} {{ config('app.currency_symbol') }}
                                                    </th>
                                                    <th>
                                                        {{ number_format($reconciliation->transactions->whereIn('type', ['deposit', 'transfer_in'])->sum('amount'), 2) }} {{ config('app.currency_symbol') }}
                                                    </th>
                                                    <th></th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">{{ __('common.confirm_delete') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{ __('banking.confirm_delete_reconciliation') }}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('common.cancel') }}</button>
                <form action="{{ route('bank-reconciliations.destroy', $reconciliation->id) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">{{ __('common.delete') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection