@extends('layouts.app')

@section('title', __('banking.bank_reconciliations'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('banking.bank_reconciliations') }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('bank-reconciliations.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus-circle mr-1"></i> {{ __('banking.new_reconciliation') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('bank-reconciliations.index') }}" method="GET" class="form-inline">
                                <div class="form-group mr-2">
                                    <label for="account_id" class="mr-2">{{ __('banking.account') }}:</label>
                                    <select name="account_id" id="account_id" class="form-control select2">
                                        <option value="">{{ __('common.all') }}</option>
                                        @foreach($accounts as $account)
                                            <option value="{{ $account->id }}" {{ request('account_id') == $account->id ? 'selected' : '' }}>
                                                {{ $account->account_number }} - {{ $account->bank->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mr-2">
                                    <label for="status" class="mr-2">{{ __('common.status') }}:</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">{{ __('common.all') }}</option>
                                        <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>{{ __('banking.in_progress') }}</option>
                                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>{{ __('banking.completed') }}</option>
                                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>{{ __('banking.cancelled') }}</option>
                                    </select>
                                </div>
                                <div class="form-group mr-2">
                                    <label for="date_from" class="mr-2">{{ __('common.date_from') }}:</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                </div>
                                <div class="form-group mr-2">
                                    <label for="date_to" class="mr-2">{{ __('common.date_to') }}:</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                </div>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search mr-1"></i> {{ __('common.filter') }}
                                </button>
                                <a href="{{ route('bank-reconciliations.index') }}" class="btn btn-secondary ml-2">
                                    <i class="fas fa-undo mr-1"></i> {{ __('common.reset') }}
                                </a>
                            </form>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>{{ __('common.id') }}</th>
                                    <th>{{ __('banking.account') }}</th>
                                    <th>{{ __('banking.statement_date') }}</th>
                                    <th>{{ __('banking.statement_balance') }}</th>
                                    <th>{{ __('banking.reconciled_balance') }}</th>
                                    <th>{{ __('banking.difference') }}</th>
                                    <th>{{ __('common.status') }}</th>
                                    <th>{{ __('common.created_at') }}</th>
                                    <th>{{ __('common.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($reconciliations as $reconciliation)
                                <tr>
                                    <td>{{ $reconciliation->id }}</td>
                                    <td>
                                        <a href="{{ route('bank-accounts.show', $reconciliation->bankAccount->id) }}">
                                            {{ $reconciliation->bankAccount->account_number }} - {{ $reconciliation->bankAccount->bank->name }}
                                        </a>
                                    </td>
                                    <td>{{ $reconciliation->statement_date->format('Y-m-d') }}</td>
                                    <td>{{ number_format($reconciliation->statement_balance, 2) }} {{ config('app.currency_symbol') }}</td>
                                    <td>{{ number_format($reconciliation->reconciled_balance, 2) }} {{ config('app.currency_symbol') }}</td>
                                    <td>
                                        @php
                                            $difference = $reconciliation->statement_balance - $reconciliation->reconciled_balance;
                                        @endphp
                                        <span class="{{ $difference == 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($difference, 2) }} {{ config('app.currency_symbol') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $reconciliation->status_color }}">
                                            {{ __('banking.' . $reconciliation->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $reconciliation->created_at->format('Y-m-d') }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('bank-reconciliations.show', $reconciliation->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @if($reconciliation->status == 'in_progress')
                                            <a href="{{ route('bank-reconciliations.edit', $reconciliation->id) }}" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $reconciliation->id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                            @endif
                                        </div>
                                        
                                        <!-- Delete Modal -->
                                        <div class="modal fade" id="deleteModal{{ $reconciliation->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $reconciliation->id }}" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="deleteModalLabel{{ $reconciliation->id }}">{{ __('common.confirm_delete') }}</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        {{ __('banking.confirm_delete_reconciliation') }}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('common.cancel') }}</button>
                                                        <form action="{{ route('bank-reconciliations.destroy', $reconciliation->id) }}" method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger">{{ __('common.delete') }}</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">{{ __('common.no_records_found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        {{ $reconciliations->appends(request()->except('page'))->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap4',
            width: '100%'
        });
    });
</script>
@endpush