@extends('layouts.app')

@section('title', __('banking.edit_reconciliation'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('banking.edit_reconciliation') }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('bank-reconciliations.index') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-arrow-left mr-1"></i> {{ __('common.back') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('bank-reconciliations.update', $reconciliation->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_id">{{ __('banking.account') }}</label>
                                    <input type="text" class="form-control" value="{{ $reconciliation->account->account_number }} - {{ $reconciliation->account->bank->name }}" readonly>
                                    <input type="hidden" name="account_id" value="{{ $reconciliation->account_id }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="statement_date">{{ __('banking.statement_date') }} <span class="text-danger">*</span></label>
                                    <input type="date" name="statement_date" id="statement_date" class="form-control @error('statement_date') is-invalid @enderror" value="{{ old('statement_date', $reconciliation->statement_date->format('Y-m-d')) }}" required>
                                    @error('statement_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="statement_balance">{{ __('banking.statement_balance') }} <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ config('app.currency_symbol') }}</span>
                                        </div>
                                        <input type="number" step="0.01" name="statement_balance" id="statement_balance" class="form-control @error('statement_balance') is-invalid @enderror" value="{{ old('statement_balance', $reconciliation->statement_balance) }}" required>
                                        @error('statement_balance')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="statement_closing_date">{{ __('banking.statement_closing_date') }}</label>
                                    <input type="date" name="statement_closing_date" id="statement_closing_date" class="form-control @error('statement_closing_date') is-invalid @enderror" value="{{ old('statement_closing_date', $reconciliation->statement_closing_date ? $reconciliation->statement_closing_date->format('Y-m-d') : '') }}">
                                    @error('statement_closing_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="system_balance">{{ __('banking.system_balance') }}</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ config('app.currency_symbol') }}</span>
                                        </div>
                                        <input type="number" step="0.01" id="system_balance" class="form-control" value="{{ $reconciliation->account->current_balance }}" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="reconciled_balance">{{ __('banking.reconciled_balance') }}</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ config('app.currency_symbol') }}</span>
                                        </div>
                                        <input type="number" step="0.01" id="reconciled_balance" class="form-control" value="{{ $reconciliation->reconciled_balance }}" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="difference">{{ __('banking.difference') }}</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ config('app.currency_symbol') }}</span>
                                        </div>
                                        <input type="number" step="0.01" id="difference" class="form-control {{ $reconciliation->statement_balance - $reconciliation->reconciled_balance == 0 ? 'bg-success text-white' : 'bg-danger text-white' }}" value="{{ $reconciliation->statement_balance - $reconciliation->reconciled_balance }}" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">{{ __('common.status') }}</label>
                                    <input type="text" class="form-control" value="{{ __('banking.' . $reconciliation->status) }}" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">{{ __('common.notes') }}</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes', $reconciliation->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save mr-1"></i> {{ __('common.save') }}
                                </button>
                                <a href="{{ route('bank-reconciliations.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times-circle mr-1"></i> {{ __('common.cancel') }}
                                </a>
                                
                                @if($reconciliation->status == 'in_progress')
                                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#completeModal">
                                    <i class="fas fa-check-circle mr-1"></i> {{ __('banking.complete_reconciliation') }}
                                </button>
                                <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#cancelModal">
                                    <i class="fas fa-ban mr-1"></i> {{ __('banking.cancel_reconciliation') }}
                                </button>
                                @endif
                                
                                <button type="button" class="btn btn-danger float-right" data-toggle="modal" data-target="#deleteModal">
                                    <i class="fas fa-trash mr-1"></i> {{ __('common.delete') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Transactions Section -->
            <div class="card mt-4">
                <div class="card-header">
                    <h3 class="card-title">{{ __('banking.transactions') }}</h3>
                </div>
                <div class="card-body">
                    <ul class="nav nav-tabs" id="transactionTabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="unreconciled-tab" data-toggle="tab" href="#unreconciled" role="tab" aria-controls="unreconciled" aria-selected="true">
                                {{ __('banking.unreconciled_transactions') }}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="reconciled-tab" data-toggle="tab" href="#reconciled" role="tab" aria-controls="reconciled" aria-selected="false">
                                {{ __('banking.reconciled_transactions') }}
                            </a>
                        </li>
                    </ul>
                    
                    <div class="tab-content mt-3" id="transactionTabsContent">
                        <!-- Unreconciled Transactions -->
                        <div class="tab-pane fade show active" id="unreconciled" role="tabpanel" aria-labelledby="unreconciled-tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th width="5%">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" id="checkAllUnreconciled">
                                                </div>
                                            </th>
                                            <th>{{ __('common.date') }}</th>
                                            <th>{{ __('banking.transaction_number') }}</th>
                                            <th>{{ __('banking.type') }}</th>
                                            <th>{{ __('banking.description') }}</th>
                                            <th>{{ __('banking.debit') }}</th>
                                            <th>{{ __('banking.credit') }}</th>
                                            <th>{{ __('common.actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($unreconciledTransactions as $transaction)
                                        <tr>
                                            <td>
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input unreconciled-transaction" data-id="{{ $transaction->id }}" data-amount="{{ $transaction->type == 'deposit' ? $transaction->amount : -$transaction->amount }}">
                                                </div>
                                            </td>
                                            <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                            <td>{{ $transaction->transaction_number }}</td>
                                            <td>
                                                <span class="badge badge-{{ $transaction->type_color }}">
                                                    {{ __('banking.' . $transaction->type) }}
                                                </span>
                                            </td>
                                            <td>{{ Str::limit($transaction->description, 50) }}</td>
                                            <td>
                                                @if(in_array($transaction->type, ['withdrawal', 'transfer_out']))
                                                    {{ number_format($transaction->amount, 2) }} {{ config('app.currency_symbol') }}
                                                @endif
                                            </td>
                                            <td>
                                                @if(in_array($transaction->type, ['deposit', 'transfer_in']))
                                                    {{ number_format($transaction->amount, 2) }} {{ config('app.currency_symbol') }}
                                                @endif
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-primary add-transaction" data-id="{{ $transaction->id }}" data-amount="{{ $transaction->type == 'deposit' ? $transaction->amount : -$transaction->amount }}">
                                                    <i class="fas fa-plus"></i> {{ __('banking.add') }}
                                                </button>
                                                <a href="{{ route('bank-transactions.show', $transaction->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="8" class="text-center">{{ __('common.no_records_found') }}</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                            
                            @if(count($unreconciledTransactions) > 0)
                            <div class="mt-3">
                                <button type="button" class="btn btn-primary" id="addSelectedTransactions">
                                    <i class="fas fa-plus-circle mr-1"></i> {{ __('banking.add_selected_transactions') }}
                                </button>
                            </div>
                            @endif
                        </div>
                        
                        <!-- Reconciled Transactions -->
                        <div class="tab-pane fade" id="reconciled" role="tabpanel" aria-labelledby="reconciled-tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>{{ __('common.date') }}</th>
                                            <th>{{ __('banking.transaction_number') }}</th>
                                            <th>{{ __('banking.type') }}</th>
                                            <th>{{ __('banking.description') }}</th>
                                            <th>{{ __('banking.debit') }}</th>
                                            <th>{{ __('banking.credit') }}</th>
                                            <th>{{ __('common.actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($reconciledTransactions as $transaction)
                                        <tr>
                                            <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                            <td>{{ $transaction->transaction_number }}</td>
                                            <td>
                                                <span class="badge badge-{{ $transaction->type_color }}">
                                                    {{ __('banking.' . $transaction->type) }}
                                                </span>
                                            </td>
                                            <td>{{ Str::limit($transaction->description, 50) }}</td>
                                            <td>
                                                @if(in_array($transaction->type, ['withdrawal', 'transfer_out']))
                                                    {{ number_format($transaction->amount, 2) }} {{ config('app.currency_symbol') }}
                                                @endif
                                            </td>
                                            <td>
                                                @if(in_array($transaction->type, ['deposit', 'transfer_in']))
                                                    {{ number_format($transaction->amount, 2) }} {{ config('app.currency_symbol') }}
                                                @endif
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-warning remove-transaction" data-id="{{ $transaction->id }}" data-amount="{{ $transaction->type == 'deposit' ? $transaction->amount : -$transaction->amount }}">
                                                    <i class="fas fa-minus"></i> {{ __('banking.remove') }}
                                                </button>
                                                <a href="{{ route('bank-transactions.show', $transaction->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="7" class="text-center">{{ __('common.no_records_found') }}</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Complete Modal -->
<div class="modal fade" id="completeModal" tabindex="-1" role="dialog" aria-labelledby="completeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="completeModalLabel">{{ __('banking.complete_reconciliation') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>{{ __('banking.confirm_complete_reconciliation') }}</p>
                
                <div class="alert alert-warning" id="differenceWarning" style="{{ $reconciliation->statement_balance - $reconciliation->reconciled_balance == 0 ? 'display:none' : '' }}">
                    <i class="fas fa-exclamation-triangle mr-1"></i>
                    {{ __('banking.reconciliation_difference_warning') }}
                    <strong id="differenceAmount">{{ number_format($reconciliation->statement_balance - $reconciliation->reconciled_balance, 2) }} {{ config('app.currency_symbol') }}</strong>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('common.cancel') }}</button>
                <form action="{{ route('bank-reconciliations.complete', $reconciliation->id) }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-success">{{ __('banking.complete') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Cancel Modal -->
<div class="modal fade" id="cancelModal" tabindex="-1" role="dialog" aria-labelledby="cancelModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cancelModalLabel">{{ __('banking.cancel_reconciliation') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{ __('banking.confirm_cancel_reconciliation') }}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('common.cancel') }}</button>
                <form action="{{ route('bank-reconciliations.cancel', $reconciliation->id) }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-warning">{{ __('banking.cancel_reconciliation') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">{{ __('common.confirm_delete') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{ __('banking.confirm_delete_reconciliation') }}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('common.cancel') }}</button>
                <form action="{{ route('bank-reconciliations.destroy', $reconciliation->id) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">{{ __('common.delete') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // Update reconciled balance and difference
        function updateBalances() {
            const statementBalance = parseFloat($('#statement_balance').val()) || 0;
            const reconciledBalance = parseFloat($('#reconciled_balance').val()) || 0;
            const difference = statementBalance - reconciledBalance;
            
            $('#difference').val(difference.toFixed(2));
            
            if (difference === 0) {
                $('#difference').removeClass('bg-danger').addClass('bg-success');
                $('#differenceWarning').hide();
            } else {
                $('#difference').removeClass('bg-success').addClass('bg-danger');
                $('#differenceWarning').show();
                $('#differenceAmount').text(difference.toFixed(2) + ' {{ config('app.currency_symbol') }}');
            }
        }
        
        // Update when statement balance changes
        $('#statement_balance').change(updateBalances);
        
        // Check all unreconciled transactions
        $('#checkAllUnreconciled').change(function() {
            $('.unreconciled-transaction').prop('checked', $(this).prop('checked'));
        });
        
        // Add a single transaction
        $('.add-transaction').click(function() {
            const transactionId = $(this).data('id');
            const amount = $(this).data('amount');
            
            $.ajax({
                url: "{{ route('bank-reconciliations.add-transaction', $reconciliation->id) }}",
                type: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    transaction_id: transactionId
                },
                success: function(response) {
                    if (response.success) {
                        // Update reconciled balance
                        const currentBalance = parseFloat($('#reconciled_balance').val()) || 0;
                        const newBalance = currentBalance + amount;
                        $('#reconciled_balance').val(newBalance.toFixed(2));
                        
                        // Update difference
                        updateBalances();
                        
                        // Refresh the page to update transaction lists
                        location.reload();
                    } else {
                        alert(response.message || "{{ __('common.error_occurred') }}");
                    }
                },
                error: function() {
                    alert("{{ __('common.error_occurred') }}");
                }
            });
        });
        
        // Remove a transaction
        $('.remove-transaction').click(function() {
            const transactionId = $(this).data('id');
            const amount = $(this).data('amount');
            
            $.ajax({
                url: "{{ route('bank-reconciliations.remove-transaction', $reconciliation->id) }}",
                type: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    transaction_id: transactionId
                },
                success: function(response) {
                    if (response.success) {
                        // Update reconciled balance
                        const currentBalance = parseFloat($('#reconciled_balance').val()) || 0;
                        const newBalance = currentBalance - amount;
                        $('#reconciled_balance').val(newBalance.toFixed(2));
                        
                        // Update difference
                        updateBalances();
                        
                        // Refresh the page to update transaction lists
                        location.reload();
                    } else {
                        alert(response.message || "{{ __('common.error_occurred') }}");
                    }
                },
                error: function() {
                    alert("{{ __('common.error_occurred') }}");
                }
            });
        });
        
        // Add selected transactions
        $('#addSelectedTransactions').click(function() {
            const selectedTransactions = [];
            let totalAmount = 0;
            
            $('.unreconciled-transaction:checked').each(function() {
                selectedTransactions.push($(this).data('id'));
                totalAmount += $(this).data('amount');
            });
            
            if (selectedTransactions.length === 0) {
                alert("{{ __('banking.no_transactions_selected') }}");
                return;
            }
            
            $.ajax({
                url: "{{ route('bank-reconciliations.add-transaction', $reconciliation->id) }}",
                type: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    transaction_ids: selectedTransactions
                },
                success: function(response) {
                    if (response.success) {
                        // Update reconciled balance
                        const currentBalance = parseFloat($('#reconciled_balance').val()) || 0;
                        const newBalance = currentBalance + totalAmount;
                        $('#reconciled_balance').val(newBalance.toFixed(2));
                        
                        // Update difference
                        updateBalances();
                        
                        // Refresh the page to update transaction lists
                        location.reload();
                    } else {
                        alert(response.message || "{{ __('common.error_occurred') }}");
                    }
                },
                error: function() {
                    alert("{{ __('common.error_occurred') }}");
                }
            });
        });
    });
</script>
@endpush