@extends('layouts.app')

@section('title', __('banking.create_reconciliation'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('banking.create_reconciliation') }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('bank-reconciliations.index') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-arrow-left mr-1"></i> {{ __('common.back') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('bank-reconciliations.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_id">{{ __('banking.account') }} <span class="text-danger">*</span></label>
                                    <select name="account_id" id="account_id" class="form-control select2 @error('account_id') is-invalid @enderror" required>
                                        <option value="">{{ __('common.select') }}</option>
                                        @foreach($bankAccounts as $account)
                                            <option value="{{ $account->id }}" {{ old('account_id') == $account->id ? 'selected' : '' }}>
                                                {{ $account->account_number }} - {{ $account->bank->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('account_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="statement_date">{{ __('banking.statement_date') }} <span class="text-danger">*</span></label>
                                    <input type="date" name="statement_date" id="statement_date" class="form-control @error('statement_date') is-invalid @enderror" value="{{ old('statement_date', date('Y-m-d')) }}" required>
                                    @error('statement_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="statement_balance">{{ __('banking.statement_balance') }} <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ config('app.currency_symbol') }}</span>
                                        </div>
                                        <input type="number" step="0.01" name="statement_balance" id="statement_balance" class="form-control @error('statement_balance') is-invalid @enderror" value="{{ old('statement_balance') }}" required>
                                        @error('statement_balance')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="statement_closing_date">{{ __('banking.statement_closing_date') }}</label>
                                    <input type="date" name="statement_closing_date" id="statement_closing_date" class="form-control @error('statement_closing_date') is-invalid @enderror" value="{{ old('statement_closing_date') }}">
                                    @error('statement_closing_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">{{ __('common.notes') }}</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save mr-1"></i> {{ __('common.save') }}
                                </button>
                                <a href="{{ route('bank-reconciliations.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times-circle mr-1"></i> {{ __('common.cancel') }}
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap4',
            width: '100%'
        });
        
        // Get account balance when account is selected
        $('#account_id').change(function() {
            const accountId = $(this).val();
            if (accountId) {
                $.ajax({
                    url: `/api/bank-accounts/${accountId}/balance`,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#system_balance').val(data.balance);
                    }
                });
            } else {
                $('#system_balance').val('');
            }
        });
    });
</script>
@endpush