@extends('layouts.app')

@section('title', __('banking.cheque_details'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('banking.cheque_details') }} #{{ $cheque->cheque_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('cheques.index') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-arrow-left mr-1"></i> {{ __('common.back') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 mb-4">
                            <div class="d-flex justify-content-between">
                                <h4>
                                    <span class="badge badge-{{ $cheque->status_color }}">
                                        {{ __('banking.' . $cheque->status) }}
                                    </span>
                                    <span class="badge badge-{{ $cheque->type == 'incoming' ? 'success' : 'warning' }}">
                                        {{ __('banking.' . $cheque->type) }}
                                    </span>
                                </h4>
                                <div>
                                    @if(!in_array($cheque->status, ['cleared', 'bounced', 'cancelled']))
                                        <a href="{{ route('cheques.edit', $cheque->id) }}" class="btn btn-info">
                                            <i class="fas fa-edit mr-1"></i> {{ __('common.edit') }}
                                        </a>
                                        <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal">
                                            <i class="fas fa-trash mr-1"></i> {{ __('common.delete') }}
                                        </button>
                                    @endif
                                    
                                    @if($cheque->type == 'incoming' && $cheque->status == 'pending')
                                        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#depositModal">
                                            <i class="fas fa-money-check-alt mr-1"></i> {{ __('banking.deposit_cheque') }}
                                        </button>
                                    @endif
                                    
                                    @if($cheque->type == 'incoming' && $cheque->status == 'deposited')
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                {{ __('banking.process_cheque') }}
                                            </button>
                                            <div class="dropdown-menu">
                                                <form action="{{ route('cheques.process', $cheque->id) }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="action" value="clear">
                                                    <button type="submit" class="dropdown-item">
                                                        <i class="fas fa-check-circle text-success mr-1"></i> {{ __('banking.mark_as_cleared') }}
                                                    </button>
                                                </form>
                                                <form action="{{ route('cheques.process', $cheque->id) }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="action" value="bounce">
                                                    <button type="submit" class="dropdown-item">
                                                        <i class="fas fa-times-circle text-danger mr-1"></i> {{ __('banking.mark_as_bounced') }}
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    @endif
                                    
                                    @if($cheque->type == 'outgoing' && $cheque->status == 'pending')
                                        <form action="{{ route('cheques.process', $cheque->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <input type="hidden" name="action" value="issue">
                                            <button type="submit" class="btn btn-success">
                                                <i class="fas fa-paper-plane mr-1"></i> {{ __('banking.mark_as_issued') }}
                                            </button>
                                        </form>
                                    @endif
                                    
                                    @if($cheque->type == 'outgoing' && $cheque->status == 'issued')
                                        <form action="{{ route('cheques.process', $cheque->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <input type="hidden" name="action" value="clear">
                                            <button type="submit" class="btn btn-success">
                                                <i class="fas fa-check-circle mr-1"></i> {{ __('banking.mark_as_cleared') }}
                                            </button>
                                        </form>
                                    @endif
                                    
                                    @if(!in_array($cheque->status, ['cleared', 'bounced', 'cancelled']))
                                        <form action="{{ route('cheques.process', $cheque->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <input type="hidden" name="action" value="cancel">
                                            <button type="submit" class="btn btn-warning">
                                                <i class="fas fa-ban mr-1"></i> {{ __('banking.cancel_cheque') }}
                                            </button>
                                        </form>
                                    @endif
                                    
                                    <a href="#" class="btn btn-secondary" onclick="window.print()">
                                        <i class="fas fa-print mr-1"></i> {{ __('common.print') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">{{ __('banking.cheque_information') }}</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">{{ __('banking.cheque_number') }}</th>
                                            <td>{{ $cheque->cheque_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.amount') }}</th>
                                            <td>{{ number_format($cheque->amount, 2) }} {{ config('app.currency_symbol') }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.issue_date') }}</th>
                                            <td>{{ $cheque->issue_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.due_date') }}</th>
                                            <td>{{ $cheque->due_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.status') }}</th>
                                            <td>
                                                <span class="badge badge-{{ $cheque->status_color }}">
                                                    {{ __('banking.' . $cheque->status) }}
                                                </span>
                                            </td>
                                        </tr>
                                        @if($cheque->status_date)
                                        <tr>
                                            <th>{{ __('banking.status_date') }}</th>
                                            <td>{{ $cheque->status_date->format('Y-m-d') }}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th>{{ __('common.description') }}</th>
                                            <td>{{ $cheque->description ?: __('common.not_provided') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            @if($cheque->type == 'incoming')
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">{{ __('banking.payer_information') }}</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">{{ __('banking.payer_name') }}</th>
                                            <td>{{ $cheque->payer_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.payer_bank') }}</th>
                                            <td>{{ $cheque->payer_bank }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.deposit_account') }}</th>
                                            <td>
                                                @if($cheque->account)
                                                    <a href="{{ route('bank-accounts.show', $cheque->account->id) }}">
                                                        {{ $cheque->account->account_number }} - {{ $cheque->account->bank->name }}
                                                    </a>
                                                @else
                                                    {{ __('common.not_assigned') }}
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            @else
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">{{ __('banking.payee_information') }}</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">{{ __('banking.source_account') }}</th>
                                            <td>
                                                @if($cheque->account)
                                                    <a href="{{ route('bank-accounts.show', $cheque->account->id) }}">
                                                        {{ $cheque->account->account_number }} - {{ $cheque->account->bank->name }}
                                                    </a>
                                                @else
                                                    {{ __('common.not_assigned') }}
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.payee_name') }}</th>
                                            <td>{{ $cheque->payee_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.payee_bank') }}</th>
                                            <td>{{ $cheque->payee_bank ?: __('common.not_provided') }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('banking.payee_account') }}</th>
                                            <td>{{ $cheque->payee_account ?: __('common.not_provided') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                    
                    @if($cheque->transactions->count() > 0)
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">{{ __('banking.related_transactions') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>{{ __('common.date') }}</th>
                                                    <th>{{ __('banking.transaction_number') }}</th>
                                                    <th>{{ __('banking.type') }}</th>
                                                    <th>{{ __('banking.amount') }}</th>
                                                    <th>{{ __('common.description') }}</th>
                                                    <th>{{ __('common.actions') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($cheque->transactions as $transaction)
                                                <tr>
                                                    <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                                    <td>{{ $transaction->transaction_number }}</td>
                                                    <td>
                                                        <span class="badge badge-{{ $transaction->type_color }}">
                                                            {{ __('banking.' . $transaction->type) }}
                                                        </span>
                                                    </td>
                                                    <td>{{ number_format($transaction->amount, 2) }} {{ config('app.currency_symbol') }}</td>
                                                    <td>{{ Str::limit($transaction->description, 50) }}</td>
                                                    <td>
                                                        <a href="{{ route('bank-transactions.show', $transaction->id) }}" class="btn btn-sm btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">{{ __('common.confirm_delete') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{ __('banking.confirm_delete_cheque') }}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('common.cancel') }}</button>
                <form action="{{ route('cheques.destroy', $cheque->id) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">{{ __('common.delete') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Deposit Modal -->
@if($cheque->type == 'incoming' && $cheque->status == 'pending')
<div class="modal fade" id="depositModal" tabindex="-1" role="dialog" aria-labelledby="depositModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="depositModalLabel">{{ __('banking.deposit_cheque') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('cheques.process', $cheque->id) }}" method="POST">
                @csrf
                <input type="hidden" name="action" value="deposit">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="deposit_date">{{ __('banking.deposit_date') }}</label>
                        <input type="date" name="deposit_date" id="deposit_date" class="form-control" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="form-group">
                        <label for="deposit_account_id">{{ __('banking.deposit_account') }}</label>
                        <select name="deposit_account_id" id="deposit_account_id" class="form-control" required>
                            <option value="">{{ __('common.select') }}</option>
                            @foreach($accounts as $account)
                                <option value="{{ $account->id }}" {{ $cheque->account_id == $account->id ? 'selected' : '' }}>
                                    {{ $account->account_number }} - {{ $account->bank->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="deposit_notes">{{ __('banking.notes') }}</label>
                        <textarea name="deposit_notes" id="deposit_notes" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('common.cancel') }}</button>
                    <button type="submit" class="btn btn-success">{{ __('banking.deposit') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // Initialize select2
        $('.select2').select2({
            theme: 'bootstrap4',
            width: '100%'
        });
    });
</script>
@endpush