@extends('layouts.app')

@section('title', 'الشيكات')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">قائمة الشيكات</h3>
                    <div>
                        @can('create_cheques')
                        <div class="btn-group" role="group">
                            <a href="{{ route('cheques.create-incoming') }}" class="btn btn-success">
                                <i class="fas fa-plus"></i> شيك وارد جديد
                            </a>
                            <a href="{{ route('cheques.create-outgoing') }}" class="btn btn-danger">
                                <i class="fas fa-plus"></i> شيك صادر جديد
                            </a>
                        </div>
                        @endcan
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('cheques.index') }}" method="GET" class="form-inline">
                                <div class="form-group mx-2">
                                    <label for="from_date" class="mx-2">من تاريخ:</label>
                                    <input type="date" id="from_date" name="from_date" class="form-control" value="{{ request('from_date') }}">
                                </div>
                                <div class="form-group mx-2">
                                    <label for="to_date" class="mx-2">إلى تاريخ:</label>
                                    <input type="date" id="to_date" name="to_date" class="form-control" value="{{ request('to_date') }}">
                                </div>
                                <div class="form-group mx-2">
                                    <label for="type" class="mx-2">نوع الشيك:</label>
                                    <select id="type" name="type" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="incoming" {{ request('type') == 'incoming' ? 'selected' : '' }}>وارد</option>
                                        <option value="outgoing" {{ request('type') == 'outgoing' ? 'selected' : '' }}>صادر</option>
                                    </select>
                                </div>
                                <div class="form-group mx-2">
                                    <label for="status" class="mx-2">الحالة:</label>
                                    <select id="status" name="status" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>معلق</option>
                                        <option value="deposited" {{ request('status') == 'deposited' ? 'selected' : '' }}>مودع</option>
                                        <option value="cleared" {{ request('status') == 'cleared' ? 'selected' : '' }}>محصل</option>
                                        <option value="returned" {{ request('status') == 'returned' ? 'selected' : '' }}>مرتجع</option>
                                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary mx-2">
                                    <i class="fas fa-filter"></i> تصفية
                                </button>
                                <a href="{{ route('cheques.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-sync"></i> إعادة تعيين
                                </a>
                            </form>
                        </div>
                    </div>

                    <ul class="nav nav-tabs mb-3" id="chequesTabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="all-tab" data-toggle="tab" href="#all" role="tab" aria-controls="all" aria-selected="true">
                                جميع الشيكات <span class="badge badge-secondary">{{ $cheques->count() }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="incoming-tab" data-toggle="tab" href="#incoming" role="tab" aria-controls="incoming" aria-selected="false">
                                الشيكات الواردة <span class="badge badge-success">{{ $cheques->where('type', 'incoming')->count() }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="outgoing-tab" data-toggle="tab" href="#outgoing" role="tab" aria-controls="outgoing" aria-selected="false">
                                الشيكات الصادرة <span class="badge badge-danger">{{ $cheques->where('type', 'outgoing')->count() }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="pending-tab" data-toggle="tab" href="#pending" role="tab" aria-controls="pending" aria-selected="false">
                                الشيكات المعلقة <span class="badge badge-warning">{{ $cheques->where('status', 'pending')->count() }}</span>
                            </a>
                        </li>
                    </ul>

                    <div class="tab-content" id="chequesTabsContent">
                        <div class="tab-pane fade show active" id="all" role="tabpanel" aria-labelledby="all-tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>رقم الشيك</th>
                                            <th>النوع</th>
                                            <th>البنك</th>
                                            <th>تاريخ الإصدار</th>
                                            <th>تاريخ الاستحقاق</th>
                                            <th>المبلغ</th>
                                            <th>المستفيد/المصدر</th>
                                            <th>الحالة</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($cheques as $cheque)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $cheque->cheque_number }}</td>
                                                <td>
                                                    @if($cheque->type == 'incoming')
                                                        <span class="badge badge-success">وارد</span>
                                                    @else
                                                        <span class="badge badge-danger">صادر</span>
                                                    @endif
                                                </td>
                                                <td>{{ $cheque->bank_name }}</td>
                                                <td>{{ $cheque->issue_date->format('Y-m-d') }}</td>
                                                <td>{{ $cheque->due_date->format('Y-m-d') }}</td>
                                                <td>{{ number_format($cheque->amount, 2) }} {{ $cheque->currency }}</td>
                                                <td>
                                                    @if($cheque->type == 'incoming')
                                                        {{ $cheque->drawer_name }}
                                                    @else
                                                        {{ $cheque->payee_name }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($cheque->status == 'pending')
                                                        <span class="badge badge-warning">معلق</span>
                                                    @elseif($cheque->status == 'deposited')
                                                        <span class="badge badge-info">مودع</span>
                                                    @elseif($cheque->status == 'cleared')
                                                        <span class="badge badge-success">محصل</span>
                                                    @elseif($cheque->status == 'returned')
                                                        <span class="badge badge-danger">مرتجع</span>
                                                    @elseif($cheque->status == 'cancelled')
                                                        <span class="badge badge-secondary">ملغي</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="btn-group" role="group">
                                                        @can('view_cheques')
                                                        <a href="{{ route('cheques.show', $cheque) }}" class="btn btn-info btn-sm" title="عرض">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                        @endcan
                                                        
                                                        @can('edit_cheques')
                                                        <a href="{{ route('cheques.edit', $cheque) }}" class="btn btn-primary btn-sm" title="تعديل">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        @endcan
                                                        
                                                        @can('process_cheques')
                                                        <div class="btn-group" role="group">
                                                            <button type="button" class="btn btn-secondary btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                <i class="fas fa-cog"></i>
                                                            </button>
                                                            <div class="dropdown-menu">
                                                                @if($cheque->status == 'pending')
                                                                    <form action="{{ route('cheques.process', $cheque) }}" method="POST">
                                                                        @csrf
                                                                        <input type="hidden" name="action" value="deposit">
                                                                        <button type="submit" class="dropdown-item">
                                                                            <i class="fas fa-money-check"></i> إيداع الشيك
                                                                        </button>
                                                                    </form>
                                                                @endif
                                                                
                                                                @if($cheque->status == 'deposited')
                                                                    <form action="{{ route('cheques.process', $cheque) }}" method="POST">
                                                                        @csrf
                                                                        <input type="hidden" name="action" value="clear">
                                                                        <button type="submit" class="dropdown-item">
                                                                            <i class="fas fa-check-circle"></i> تحصيل الشيك
                                                                        </button>
                                                                    </form>
                                                                    
                                                                    <form action="{{ route('cheques.process', $cheque) }}" method="POST">
                                                                        @csrf
                                                                        <input type="hidden" name="action" value="return">
                                                                        <button type="submit" class="dropdown-item">
                                                                            <i class="fas fa-undo"></i> إرجاع الشيك
                                                                        </button>
                                                                    </form>
                                                                @endif
                                                                
                                                                @if(in_array($cheque->status, ['pending', 'deposited']))
                                                                    <form action="{{ route('cheques.process', $cheque) }}" method="POST">
                                                                        @csrf
                                                                        <input type="hidden" name="action" value="cancel">
                                                                        <button type="submit" class="dropdown-item">
                                                                            <i class="fas fa-ban"></i> إلغاء الشيك
                                                                        </button>
                                                                    </form>
                                                                @endif
                                                            </div>
                                                        </div>
                                                        @endcan
                                                        
                                                        @can('delete_cheques')
                                                        <form action="{{ route('cheques.destroy', $cheque) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا الشيك؟');">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger btn-sm" title="حذف">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                        @endcan
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="10" class="text-center">لا توجد شيكات مسجلة</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="incoming" role="tabpanel" aria-labelledby="incoming-tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>رقم الشيك</th>
                                            <th>البنك</th>
                                            <th>تاريخ الإصدار</th>
                                            <th>تاريخ الاستحقاق</th>
                                            <th>المبلغ</th>
                                            <th>المصدر</th>
                                            <th>الحالة</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($cheques->where('type', 'incoming') as $cheque)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $cheque->cheque_number }}</td>
                                                <td>{{ $cheque->bank_name }}</td>
                                                <td>{{ $cheque->issue_date->format('Y-m-d') }}</td>
                                                <td>{{ $cheque->due_date->format('Y-m-d') }}</td>
                                                <td>{{ number_format($cheque->amount, 2) }} {{ $cheque->currency }}</td>
                                                <td>{{ $cheque->drawer_name }}</td>
                                                <td>
                                                    @if($cheque->status == 'pending')
                                                        <span class="badge badge-warning">معلق</span>
                                                    @elseif($cheque->status == 'deposited')
                                                        <span class="badge badge-info">مودع</span>
                                                    @elseif($cheque->status == 'cleared')
                                                        <span class="badge badge-success">محصل</span>
                                                    @elseif($cheque->status == 'returned')
                                                        <span class="badge badge-danger">مرتجع</span>
                                                    @elseif($cheque->status == 'cancelled')
                                                        <span class="badge badge-secondary">ملغي</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="btn-group" role="group">
                                                        <a href="{{ route('cheques.show', $cheque) }}" class="btn btn-info btn-sm" title="عرض">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="9" class="text-center">لا توجد شيكات واردة مسجلة</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="outgoing" role="tabpanel" aria-labelledby="outgoing-tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>رقم الشيك</th>
                                            <th>البنك</th>
                                            <th>تاريخ الإصدار</th>
                                            <th>تاريخ الاستحقاق</th>
                                            <th>المبلغ</th>
                                            <th>المستفيد</th>
                                            <th>الحالة</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($cheques->where('type', 'outgoing') as $cheque)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $cheque->cheque_number }}</td>
                                                <td>{{ $cheque->bank_name }}</td>
                                                <td>{{ $cheque->issue_date->format('Y-m-d') }}</td>
                                                <td>{{ $cheque->due_date->format('Y-m-d') }}</td>
                                                <td>{{ number_format($cheque->amount, 2) }} {{ $cheque->currency }}</td>
                                                <td>{{ $cheque->payee_name }}</td>
                                                <td>
                                                    @if($cheque->status == 'pending')
                                                        <span class="badge badge-warning">معلق</span>
                                                    @elseif($cheque->status == 'deposited')
                                                        <span class="badge badge-info">مودع</span>
                                                    @elseif($cheque->status == 'cleared')
                                                        <span class="badge badge-success">محصل</span>
                                                    @elseif($cheque->status == 'returned')
                                                        <span class="badge badge-danger">مرتجع</span>
                                                    @elseif($cheque->status == 'cancelled')
                                                        <span class="badge badge-secondary">ملغي</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="btn-group" role="group">
                                                        <a href="{{ route('cheques.show', $cheque) }}" class="btn btn-info btn-sm" title="عرض">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="9" class="text-center">لا توجد شيكات صادرة مسجلة</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="pending" role="tabpanel" aria-labelledby="pending-tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>رقم الشيك</th>
                                            <th>النوع</th>
                                            <th>البنك</th>
                                            <th>تاريخ الاستحقاق</th>
                                            <th>المبلغ</th>
                                            <th>المستفيد/المصدر</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($cheques->where('status', 'pending') as $cheque)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $cheque->cheque_number }}</td>
                                                <td>
                                                    @if($cheque->type == 'incoming')
                                                        <span class="badge badge-success">وارد</span>
                                                    @else
                                                        <span class="badge badge-danger">صادر</span>
                                                    @endif
                                                </td>
                                                <td>{{ $cheque->bank_name }}</td>
                                                <td>{{ $cheque->due_date->format('Y-m-d') }}</td>
                                                <td>{{ number_format($cheque->amount, 2) }} {{ $cheque->currency }}</td>
                                                <td>
                                                    @if($cheque->type == 'incoming')
                                                        {{ $cheque->drawer_name }}
                                                    @else
                                                        {{ $cheque->payee_name }}
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="btn-group" role="group">
                                                        <a href="{{ route('cheques.show', $cheque) }}" class="btn btn-info btn-sm" title="عرض">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                        
                                                        @can('process_cheques')
                                                        <form action="{{ route('cheques.process', $cheque) }}" method="POST" class="d-inline">
                                                            @csrf
                                                            <input type="hidden" name="action" value="deposit">
                                                            <button type="submit" class="btn btn-success btn-sm" title="إيداع">
                                                                <i class="fas fa-money-check"></i>
                                                            </button>
                                                        </form>
                                                        @endcan
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="8" class="text-center">لا توجد شيكات معلقة</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-center mt-4">
                        {{ $cheques->appends(request()->except('page'))->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection