@extends('layouts.app')

@section('title', __('banking.edit_cheque'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('banking.edit_cheque') }} #{{ $cheque->cheque_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('cheques.index') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-arrow-left mr-1"></i> {{ __('common.back') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('cheques.update', $cheque->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="cheque_number">{{ __('banking.cheque_number') }} <span class="text-danger">*</span></label>
                                    <input type="text" name="cheque_number" id="cheque_number" class="form-control @error('cheque_number') is-invalid @enderror" value="{{ old('cheque_number', $cheque->cheque_number) }}" required>
                                    @error('cheque_number')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">{{ __('banking.amount') }} <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ config('app.currency_symbol') }}</span>
                                        </div>
                                        <input type="number" step="0.01" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror" value="{{ old('amount', $cheque->amount) }}" required {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'readonly' : '' }}>
                                        @error('amount')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="issue_date">{{ __('banking.issue_date') }} <span class="text-danger">*</span></label>
                                    <input type="date" name="issue_date" id="issue_date" class="form-control @error('issue_date') is-invalid @enderror" value="{{ old('issue_date', $cheque->issue_date->format('Y-m-d')) }}" required {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'readonly' : '' }}>
                                    @error('issue_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="due_date">{{ __('banking.due_date') }} <span class="text-danger">*</span></label>
                                    <input type="date" name="due_date" id="due_date" class="form-control @error('due_date') is-invalid @enderror" value="{{ old('due_date', $cheque->due_date->format('Y-m-d')) }}" required {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'readonly' : '' }}>
                                    @error('due_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        @if($cheque->type == 'incoming')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bank_id">{{ __('banking.bank') }} <span class="text-danger">*</span></label>
                                    <select name="bank_id" id="bank_id" class="form-control select2 @error('bank_id') is-invalid @enderror" required {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'disabled' : '' }}>
                                        <option value="">{{ __('common.select') }}</option>
                                        @foreach($banks as $bank)
                                            <option value="{{ $bank->id }}" {{ old('bank_id', $cheque->bank_id) == $bank->id ? 'selected' : '' }}>
                                                {{ $bank->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('bank_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_id">{{ __('banking.deposit_account') }} <span class="text-danger">*</span></label>
                                    <select name="account_id" id="account_id" class="form-control select2 @error('account_id') is-invalid @enderror" required {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'disabled' : '' }}>
                                        <option value="">{{ __('common.select') }}</option>
                                        @foreach($accounts as $account)
                                            <option value="{{ $account->id }}" {{ old('account_id', $cheque->account_id) == $account->id ? 'selected' : '' }}>
                                                {{ $account->account_number }} - {{ $account->bank->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('account_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payer_name">{{ __('banking.payer_name') }} <span class="text-danger">*</span></label>
                                    <input type="text" name="payer_name" id="payer_name" class="form-control @error('payer_name') is-invalid @enderror" value="{{ old('payer_name', $cheque->payer_name) }}" required {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'readonly' : '' }}>
                                    @error('payer_name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payer_bank">{{ __('banking.payer_bank') }} <span class="text-danger">*</span></label>
                                    <input type="text" name="payer_bank" id="payer_bank" class="form-control @error('payer_bank') is-invalid @enderror" value="{{ old('payer_bank', $cheque->payer_bank) }}" required {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'readonly' : '' }}>
                                    @error('payer_bank')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        @else
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_id">{{ __('banking.source_account') }} <span class="text-danger">*</span></label>
                                    <select name="account_id" id="account_id" class="form-control select2 @error('account_id') is-invalid @enderror" required {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'disabled' : '' }}>
                                        <option value="">{{ __('common.select') }}</option>
                                        @foreach($accounts as $account)
                                            <option value="{{ $account->id }}" {{ old('account_id', $cheque->account_id) == $account->id ? 'selected' : '' }}>
                                                {{ $account->account_number }} - {{ $account->bank->name }} ({{ number_format($account->current_balance, 2) }} {{ config('app.currency_symbol') }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('account_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payee_name">{{ __('banking.payee_name') }} <span class="text-danger">*</span></label>
                                    <input type="text" name="payee_name" id="payee_name" class="form-control @error('payee_name') is-invalid @enderror" value="{{ old('payee_name', $cheque->payee_name) }}" required {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'readonly' : '' }}>
                                    @error('payee_name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payee_bank">{{ __('banking.payee_bank') }}</label>
                                    <input type="text" name="payee_bank" id="payee_bank" class="form-control @error('payee_bank') is-invalid @enderror" value="{{ old('payee_bank', $cheque->payee_bank) }}" {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'readonly' : '' }}>
                                    @error('payee_bank')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payee_account">{{ __('banking.payee_account') }}</label>
                                    <input type="text" name="payee_account" id="payee_account" class="form-control @error('payee_account') is-invalid @enderror" value="{{ old('payee_account', $cheque->payee_account) }}" {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'readonly' : '' }}>
                                    @error('payee_account')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        @endif
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">{{ __('common.description') }}</label>
                                    <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror" rows="3" {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'readonly' : '' }}>{{ old('description', $cheque->description) }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">{{ __('banking.status') }} <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        @if($cheque->type == 'incoming')
                                            <option value="pending" {{ old('status', $cheque->status) == 'pending' ? 'selected' : '' }}>{{ __('banking.pending') }}</option>
                                            <option value="deposited" {{ old('status', $cheque->status) == 'deposited' ? 'selected' : '' }}>{{ __('banking.deposited') }}</option>
                                            <option value="cleared" {{ old('status', $cheque->status) == 'cleared' ? 'selected' : '' }}>{{ __('banking.cleared') }}</option>
                                            <option value="bounced" {{ old('status', $cheque->status) == 'bounced' ? 'selected' : '' }}>{{ __('banking.bounced') }}</option>
                                            <option value="cancelled" {{ old('status', $cheque->status) == 'cancelled' ? 'selected' : '' }}>{{ __('banking.cancelled') }}</option>
                                        @else
                                            <option value="pending" {{ old('status', $cheque->status) == 'pending' ? 'selected' : '' }}>{{ __('banking.pending') }}</option>
                                            <option value="issued" {{ old('status', $cheque->status) == 'issued' ? 'selected' : '' }}>{{ __('banking.issued') }}</option>
                                            <option value="cleared" {{ old('status', $cheque->status) == 'cleared' ? 'selected' : '' }}>{{ __('banking.cleared') }}</option>
                                            <option value="cancelled" {{ old('status', $cheque->status) == 'cancelled' ? 'selected' : '' }}>{{ __('banking.cancelled') }}</option>
                                        @endif
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status_date">{{ __('banking.status_date') }}</label>
                                    <input type="date" name="status_date" id="status_date" class="form-control @error('status_date') is-invalid @enderror" value="{{ old('status_date', $cheque->status_date ? $cheque->status_date->format('Y-m-d') : date('Y-m-d')) }}">
                                    @error('status_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary" {{ in_array($cheque->status, ['cleared', 'bounced', 'cancelled']) ? 'disabled' : '' }}>
                                    <i class="fas fa-save mr-1"></i> {{ __('common.save') }}
                                </button>
                                <a href="{{ route('cheques.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times-circle mr-1"></i> {{ __('common.cancel') }}
                                </a>
                                
                                @if(!in_array($cheque->status, ['cleared', 'bounced', 'cancelled']))
                                <button type="button" class="btn btn-danger float-right" data-toggle="modal" data-target="#deleteModal">
                                    <i class="fas fa-trash mr-1"></i> {{ __('common.delete') }}
                                </button>
                                @endif
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">{{ __('common.confirm_delete') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{ __('banking.confirm_delete_cheque') }}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('common.cancel') }}</button>
                <form action="{{ route('cheques.destroy', $cheque->id) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">{{ __('common.delete') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap4',
            width: '100%'
        });
        
        // Update deposit account options based on selected bank (for incoming cheques)
        $('#bank_id').change(function() {
            const bankId = $(this).val();
            if (bankId) {
                $.ajax({
                    url: `/api/banks/${bankId}/accounts`,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        let options = '<option value="">{{ __("common.select") }}</option>';
                        data.forEach(function(account) {
                            options += `<option value="${account.id}">${account.account_number} - ${account.name}</option>`;
                        });
                        $('#account_id').html(options);
                    }
                });
            } else {
                $('#account_id').html('<option value="">{{ __("common.select") }}</option>');
            }
        });
        
        // Show/hide status date based on status
        $('#status').change(function() {
            const status = $(this).val();
            if (status === 'pending') {
                $('#status_date').val('').closest('.form-group').parent().hide();
            } else {
                $('#status_date').closest('.form-group').parent().show();
            }
        });
        
        // Initialize status date visibility
        if ($('#status').val() === 'pending') {
            $('#status_date').closest('.form-group').parent().hide();
        }
    });
</script>
@endpush