@extends('layouts.app')

@section('title', __('banking.create_outgoing_cheque'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('banking.create_outgoing_cheque') }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('cheques.index') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-arrow-left mr-1"></i> {{ __('common.back') }}
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('cheques.store-outgoing') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="cheque_number">{{ __('banking.cheque_number') }} <span class="text-danger">*</span></label>
                                    <input type="text" name="cheque_number" id="cheque_number" class="form-control @error('cheque_number') is-invalid @enderror" value="{{ old('cheque_number') }}" required>
                                    @error('cheque_number')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">{{ __('banking.amount') }} <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ config('app.currency_symbol') }}</span>
                                        </div>
                                        <input type="number" step="0.01" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror" value="{{ old('amount') }}" required>
                                        @error('amount')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="issue_date">{{ __('banking.issue_date') }} <span class="text-danger">*</span></label>
                                    <input type="date" name="issue_date" id="issue_date" class="form-control @error('issue_date') is-invalid @enderror" value="{{ old('issue_date', date('Y-m-d')) }}" required>
                                    @error('issue_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="due_date">{{ __('banking.due_date') }} <span class="text-danger">*</span></label>
                                    <input type="date" name="due_date" id="due_date" class="form-control @error('due_date') is-invalid @enderror" value="{{ old('due_date') }}" required>
                                    @error('due_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_id">{{ __('banking.source_account') }} <span class="text-danger">*</span></label>
                                    <select name="account_id" id="account_id" class="form-control select2 @error('account_id') is-invalid @enderror" required>
                                        <option value="">{{ __('common.select') }}</option>
                                        @foreach($accounts as $account)
                                            <option value="{{ $account->id }}" {{ old('account_id') == $account->id ? 'selected' : '' }}>
                                                {{ $account->account_number }} - {{ $account->bank->name }} ({{ number_format($account->current_balance, 2) }} {{ config('app.currency_symbol') }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('account_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payee_name">{{ __('banking.payee_name') }} <span class="text-danger">*</span></label>
                                    <input type="text" name="payee_name" id="payee_name" class="form-control @error('payee_name') is-invalid @enderror" value="{{ old('payee_name') }}" required>
                                    @error('payee_name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payee_bank">{{ __('banking.payee_bank') }}</label>
                                    <input type="text" name="payee_bank" id="payee_bank" class="form-control @error('payee_bank') is-invalid @enderror" value="{{ old('payee_bank') }}">
                                    @error('payee_bank')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payee_account">{{ __('banking.payee_account') }}</label>
                                    <input type="text" name="payee_account" id="payee_account" class="form-control @error('payee_account') is-invalid @enderror" value="{{ old('payee_account') }}">
                                    @error('payee_account')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">{{ __('common.description') }}</label>
                                    <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror" rows="3">{{ old('description') }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="status">{{ __('banking.status') }} <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>{{ __('banking.pending') }}</option>
                                        <option value="issued" {{ old('status') == 'issued' ? 'selected' : '' }}>{{ __('banking.issued') }}</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save mr-1"></i> {{ __('common.save') }}
                                </button>
                                <a href="{{ route('cheques.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times-circle mr-1"></i> {{ __('common.cancel') }}
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap4',
            width: '100%'
        });
        
        // Set minimum due date to today
        const today = new Date().toISOString().split('T')[0];
        $('#due_date').attr('min', today);
        
        // Validate sufficient balance
        $('form').submit(function(e) {
            const accountSelect = $('#account_id option:selected');
            if (accountSelect.val()) {
                const balanceText = accountSelect.text().match(/\(([\d,.]+)/);
                if (balanceText && balanceText[1]) {
                    const balance = parseFloat(balanceText[1].replace(/,/g, ''));
                    const amount = parseFloat($('#amount').val());
                    
                    if (amount > balance) {
                        e.preventDefault();
                        alert("{{ __('banking.insufficient_balance') }}");
                        return false;
                    }
                }
            }
            return true;
        });
    });
</script>
@endpush