@extends('layouts.app')

@section('title', 'تفاصيل البنك')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">تفاصيل البنك: {{ $bank->name }}</h3>
                    <div>
                        @can('edit_banks')
                        <a href="{{ route('banks.edit', $bank) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan
                        <a href="{{ route('banks.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 30%">اسم البنك</th>
                                    <td>{{ $bank->name }}</td>
                                </tr>
                                <tr>
                                    <th>الفرع</th>
                                    <td>{{ $bank->code ?? 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>العنوان</th>
                                    <td>{{ $bank->address ?? 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>جهة الاتصال</th>
                                    <td>{{ $bank->contact_person ?? 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>الهاتف</th>
                                    <td>{{ $bank->contact_phone ?? 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>البريد الإلكتروني</th>
                                    <td>{{ $bank->contact_email ?? 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>الحالة</th>
                                    <td>
                                        @if($bank->is_active)
                                            <span class="badge badge-success">نشط</span>
                                        @else
                                            <span class="badge badge-danger">غير نشط</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>ملاحظات</th>
                                    <td>{{ $bank->notes ?? 'لا توجد ملاحظات' }}</td>
                                </tr>
                                <tr>
                                    <th>تاريخ الإنشاء</th>
                                    <td>{{ $bank->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>آخر تحديث</th>
                                    <td>{{ $bank->updated_at->format('Y-m-d H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4>الحسابات البنكية</h4>
                                </div>
                                <div class="card-body">
                                    @if($bank->bankAccounts->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>رقم الحساب</th>
                                                        <th>نوع الحساب</th>
                                                        <th>العملة</th>
                                                        <th>الرصيد</th>
                                                        <th>الإجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($bank->bankAccounts as $account)
                                                        <tr>
                                                            <td>{{ $loop->iteration }}</td>
                                                            <td>{{ $account->account_number }}</td>
                                                            <td>{{ $account->account_type }}</td>
                                                            <td>{{ $account->currency }}</td>
                                                            <td>{{ number_format($account->current_balance, 2) }}</td>
                                                            <td>
                                                                <a href="{{ route('bank-accounts.show', $account) }}" class="btn btn-info btn-sm">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد حسابات بنكية مسجلة لهذا البنك
                                        </div>
                                    @endif
                                    
                                    @can('create_bank_accounts')
                                    <div class="text-center mt-3">
                                        <a href="{{ route('bank-accounts.create') }}?bank_id={{ $bank->id }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> إضافة حساب بنكي جديد
                                        </a>
                                    </div>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection