@extends('layouts.app')

@section('title', 'البنوك')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">قائمة البنوك</h3>
                    @can('create_banks')
                    <a href="{{ route('banks.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> إضافة بنك جديد
                    </a>
                    @endcan
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>اسم البنك</th>
                                    <th>الفرع</th>
                                    <th>العنوان</th>
                                    <th>جهة الاتصال</th>
                                    <th>الهاتف</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($banks as $bank)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $bank->name }}</td>
                                        <td>{{ $bank->code ?? 'غير محدد' }}</td>
                                        <td>{{ Str::limit($bank->address, 30) ?? 'غير محدد' }}</td>
                                        <td>{{ $bank->contact_person ?? 'غير محدد' }}</td>
                                        <td>{{ $bank->contact_phone ?? 'غير محدد' }}</td>
                                        <td>
                                            @if($bank->is_active)
                                                <span class="badge badge-success">نشط</span>
                                            @else
                                                <span class="badge badge-danger">غير نشط</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                @can('view_banks')
                                                <a href="{{ route('banks.show', $bank) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('edit_banks')
                                                <a href="{{ route('banks.edit', $bank) }}" class="btn btn-primary btn-sm" title="تعديل">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('delete_banks')
                                                <form action="{{ route('banks.destroy', $bank) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا البنك؟');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد بنوك مسجلة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection