@extends('layouts.app')

@section('title', 'كشف حساب بنكي')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">كشف حساب: {{ $bankAccount->account_name }}</h3>
                    <div>
                        <button onclick="window.print()" class="btn btn-dark">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                        <a href="{{ route('bank-accounts.show', $bankAccount) }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للحساب
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title">معلومات الحساب</h5>
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 40%">البنك</th>
                                            <td>{{ $bankAccount->bank->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم الحساب</th>
                                            <td>{{ $bankAccount->account_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>نوع الحساب</th>
                                            <td>{{ $bankAccount->account_type }}</td>
                                        </tr>
                                        <tr>
                                            <th>العملة</th>
                                            <td>{{ $bankAccount->currency }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title">ملخص الحساب</h5>
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 40%">الرصيد الافتتاحي</th>
                                            <td>{{ number_format($bankAccount->opening_balance, 2) }} {{ $bankAccount->currency }}</td>
                                        </tr>
                                        <tr>
                                            <th>إجمالي الإيداعات</th>
                                            <td class="text-success">{{ number_format($totalDeposits, 2) }} {{ $bankAccount->currency }}</td>
                                        </tr>
                                        <tr>
                                            <th>إجمالي السحوبات</th>
                                            <td class="text-danger">{{ number_format($totalWithdrawals, 2) }} {{ $bankAccount->currency }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرصيد الحالي</th>
                                            <td class="font-weight-bold {{ $bankAccount->current_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                                {{ number_format($bankAccount->current_balance, 2) }} {{ $bankAccount->currency }}
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('bank-accounts.statement', $bankAccount) }}" method="GET" class="form-inline">
                                <div class="form-group mx-2">
                                    <label for="from_date" class="mx-2">من تاريخ:</label>
                                    <input type="date" id="from_date" name="from_date" class="form-control" value="{{ request('from_date') }}">
                                </div>
                                <div class="form-group mx-2">
                                    <label for="to_date" class="mx-2">إلى تاريخ:</label>
                                    <input type="date" id="to_date" name="to_date" class="form-control" value="{{ request('to_date') }}">
                                </div>
                                <div class="form-group mx-2">
                                    <label for="type" class="mx-2">نوع المعاملة:</label>
                                    <select id="type" name="type" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="deposit" {{ request('type') == 'deposit' ? 'selected' : '' }}>إيداع</option>
                                        <option value="withdrawal" {{ request('type') == 'withdrawal' ? 'selected' : '' }}>سحب</option>
                                        <option value="transfer_in" {{ request('type') == 'transfer_in' ? 'selected' : '' }}>تحويل وارد</option>
                                        <option value="transfer_out" {{ request('type') == 'transfer_out' ? 'selected' : '' }}>تحويل صادر</option>
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary mx-2">
                                    <i class="fas fa-filter"></i> تصفية
                                </button>
                                <a href="{{ route('bank-accounts.statement', $bankAccount) }}" class="btn btn-secondary">
                                    <i class="fas fa-sync"></i> إعادة تعيين
                                </a>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>التاريخ</th>
                                    <th>المرجع</th>
                                    <th>النوع</th>
                                    <th>الوصف</th>
                                    <th>مدين (للبنك)</th>
                                    <th>دائن (للبنك)</th>
                                    <th>الرصيد</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="table-secondary">
                                    <td colspan="7" class="text-right font-weight-bold">الرصيد الافتتاحي</td>
                                    <td class="font-weight-bold">{{ number_format($openingBalance, 2) }}</td>
                                </tr>
                                
                                @php $balance = $openingBalance; @endphp
                                
                                @forelse($transactions as $transaction)
                                    @php
                                        if(in_array($transaction->transaction_type, ['deposit', 'transfer_in'])) {
                                            $balance -= $transaction->amount;
                                        } else {
                                            $balance += $transaction->amount;
                                        }
                                    @endphp
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                        <td>
                                            <a href="{{ route('bank-transactions.show', $transaction) }}">
                                                {{ $transaction->reference_number }}
                                            </a>
                                        </td>
                                        <td>
                                            @if($transaction->transaction_type == 'deposit')
                                                <span class="badge badge-success">إيداع</span>
                                            @elseif($transaction->transaction_type == 'withdrawal')
                                                <span class="badge badge-danger">سحب</span>
                                            @elseif($transaction->transaction_type == 'transfer_in')
                                                <span class="badge badge-primary">تحويل وارد</span>
                                            @elseif($transaction->transaction_type == 'transfer_out')
                                                <span class="badge badge-warning">تحويل صادر</span>
                                            @endif
                                        </td>
                                        <td>{{ $transaction->description }}</td>
                                        <td class="text-danger">
                                            @if(in_array($transaction->transaction_type, ['withdrawal', 'transfer_out']))
                                                {{ number_format($transaction->amount, 2) }}
                                            @endif
                                        </td>
                                        <td class="text-success">
                                            @if(in_array($transaction->transaction_type, ['deposit', 'transfer_in']))
                                                {{ number_format($transaction->amount, 2) }}
                                            @endif
                                        </td>
                                        <td class="{{ $balance >= 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($balance, 2) }}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد معاملات في الفترة المحددة</td>
                                    </tr>
                                @endforelse
                                
                                <tr class="table-secondary">
                                    <td colspan="7" class="text-right font-weight-bold">الرصيد الختامي</td>
                                    <td class="font-weight-bold {{ $balance >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($balance, 2) }}
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-center mt-4">
                        {{ $transactions->appends(request()->except('page'))->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    @media print {
        .btn, .navbar, .sidebar, .footer, form {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        .card-header {
            background-color: white !important;
            border-bottom: 1px solid #ddd !important;
        }
        body {
            padding: 0 !important;
            margin: 0 !important;
        }
        .container-fluid {
            padding: 0 !important;
            margin: 0 !important;
            width: 100% !important;
        }
    }
</style>
@endsection