@extends('layouts.app')

@section('title', 'تفاصيل الحساب البنكي')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">تفاصيل الحساب البنكي: {{ $bankAccount->account_name }}</h3>
                    <div>
                        @can('edit_bank_accounts')
                        <a href="{{ route('bank-accounts.edit', $bankAccount) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan
                        <a href="{{ route('bank-accounts.statement', $bankAccount) }}" class="btn btn-info">
                            <i class="fas fa-file-alt"></i> كشف حساب
                        </a>
                        <a href="{{ route('bank-accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h4>معلومات الحساب</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">البنك</th>
                                            <td>{{ $bankAccount->bank->name }} - {{ $bankAccount->bank->branch ?? 'الفرع الرئيسي' }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم الحساب</th>
                                            <td>{{ $bankAccount->account_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>اسم الحساب</th>
                                            <td>{{ $bankAccount->account_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>نوع الحساب</th>
                                            <td>{{ $bankAccount->account_type }}</td>
                                        </tr>
                                        <tr>
                                            <th>العملة</th>
                                            <td>{{ $bankAccount->currency }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرصيد الافتتاحي</th>
                                            <td>{{ number_format($bankAccount->opening_balance, 2) }} {{ $bankAccount->currency }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرصيد الحالي</th>
                                            <td>
                                                <span class="font-weight-bold {{ $bankAccount->current_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ number_format($bankAccount->current_balance, 2) }} {{ $bankAccount->currency }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الحساب المحاسبي</th>
                                            <td>{{ $bankAccount->chartOfAccount->code ?? '' }} - {{ $bankAccount->chartOfAccount->name ?? 'غير مرتبط' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($bankAccount->status)
                                                    <span class="badge badge-success">نشط</span>
                                                @else
                                                    <span class="badge badge-danger">غير نشط</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الوصف</th>
                                            <td>{{ $bankAccount->description ?? 'لا يوجد وصف' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $bankAccount->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h4>العمليات المتاحة</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            @can('create_bank_transactions')
                                            <a href="{{ route('bank-transactions.create-deposit') }}?bank_account_id={{ $bankAccount->id }}" class="btn btn-success btn-block">
                                                <i class="fas fa-arrow-down"></i> إيداع
                                            </a>
                                            @endcan
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            @can('create_bank_transactions')
                                            <a href="{{ route('bank-transactions.create-withdrawal') }}?bank_account_id={{ $bankAccount->id }}" class="btn btn-danger btn-block">
                                                <i class="fas fa-arrow-up"></i> سحب
                                            </a>
                                            @endcan
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            @can('create_bank_transactions')
                                            <a href="{{ route('bank-transactions.create-transfer') }}?from_account_id={{ $bankAccount->id }}" class="btn btn-primary btn-block">
                                                <i class="fas fa-exchange-alt"></i> تحويل
                                            </a>
                                            @endcan
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            @can('create_bank_reconciliations')
                                            <a href="{{ route('bank-reconciliations.create') }}?bank_account_id={{ $bankAccount->id }}" class="btn btn-info btn-block">
                                                <i class="fas fa-check-double"></i> تسوية بنكية
                                            </a>
                                            @endcan
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            @can('create_cheques')
                                            <a href="{{ route('cheques.create-incoming') }}?bank_account_id={{ $bankAccount->id }}" class="btn btn-secondary btn-block">
                                                <i class="fas fa-money-check"></i> شيك وارد
                                            </a>
                                            @endcan
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            @can('create_cheques')
                                            <a href="{{ route('cheques.create-outgoing') }}?bank_account_id={{ $bankAccount->id }}" class="btn btn-warning btn-block">
                                                <i class="fas fa-money-check-alt"></i> شيك صادر
                                            </a>
                                            @endcan
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header">
                                    <h4>آخر المعاملات</h4>
                                </div>
                                <div class="card-body">
                                    @if($transactions->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>التاريخ</th>
                                                        <th>النوع</th>
                                                        <th>المبلغ</th>
                                                        <th>الوصف</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($transactions as $transaction)
                                                        <tr>
                                                            <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                                            <td>
                                                                @if($transaction->type == 'deposit')
                                                                    <span class="badge badge-success">إيداع</span>
                                                                @elseif($transaction->type == 'withdrawal')
                                                                    <span class="badge badge-danger">سحب</span>
                                                                @elseif($transaction->type == 'transfer_in')
                                                                    <span class="badge badge-primary">تحويل وارد</span>
                                                                @elseif($transaction->type == 'transfer_out')
                                                                    <span class="badge badge-warning">تحويل صادر</span>
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if(in_array($transaction->type, ['deposit', 'transfer_in']))
                                                                    <span class="text-success">+{{ number_format($transaction->amount, 2) }}</span>
                                                                @else
                                                                    <span class="text-danger">-{{ number_format($transaction->amount, 2) }}</span>
                                                                @endif
                                                            </td>
                                                            <td>{{ Str::limit($transaction->description, 30) }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="text-center mt-3">
                                            <a href="{{ route('bank-accounts.statement', $bankAccount) }}" class="btn btn-outline-primary">
                                                عرض كل المعاملات
                                            </a>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد معاملات حديثة لهذا الحساب
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection