@extends('layouts.app')

@section('title', 'الحسابات البنكية')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">قائمة الحسابات البنكية</h3>
                    @can('create_bank_accounts')
                    <a href="{{ route('bank-accounts.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> إضافة حساب بنكي جديد
                    </a>
                    @endcan
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>البنك</th>
                                    <th>رقم الحساب</th>
                                    <th>نوع الحساب</th>
                                    <th>العملة</th>
                                    <th>الرصيد الحالي</th>
                                    <th>الحساب المحاسبي</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($bankAccounts as $account)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $account->bank->name }}</td>
                                        <td>{{ $account->account_number }}</td>
                                        <td>{{ $account->account_type }}</td>
                                        <td>{{ $account->currency }}</td>
                                        <td>{{ number_format($account->current_balance, 2) }}</td>
                                        <td>{{ $account->chartOfAccount->name ?? 'غير مرتبط' }}</td>
                                        <td>
                                            @if($account->is_active)
                                                <span class="badge badge-success">نشط</span>
                                            @else
                                                <span class="badge badge-danger">غير نشط</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                @can('view_bank_accounts')
                                                <a href="{{ route('bank-accounts.show', $account) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('view_bank_accounts')
                                                <a href="{{ route('bank-accounts.statement', $account) }}" class="btn btn-secondary btn-sm" title="كشف حساب">
                                                    <i class="fas fa-file-alt"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('edit_bank_accounts')
                                                <a href="{{ route('bank-accounts.edit', $account) }}" class="btn btn-primary btn-sm" title="تعديل">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('delete_bank_accounts')
                                                <form action="{{ route('bank-accounts.destroy', $account) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا الحساب البنكي؟');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد حسابات بنكية مسجلة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-center mt-4">
                        {{ $bankAccounts->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection