@extends('layouts.app')

@section('title', 'إضافة حساب بنكي جديد')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">إضافة حساب بنكي جديد</h3>
                    <a href="{{ route('bank-accounts.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('bank-accounts.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bank_id">البنك <span class="text-danger">*</span></label>
                                    <select class="form-control @error('bank_id') is-invalid @enderror" id="bank_id" name="bank_id" required>
                                        <option value="">-- اختر البنك --</option>
                                        @foreach($banks as $bank)
                                            <option value="{{ $bank->id }}" {{ old('bank_id', request('bank_id')) == $bank->id ? 'selected' : '' }}>
                                                {{ $bank->name }} - {{ $bank->branch ?? 'الفرع الرئيسي' }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('bank_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_number">رقم الحساب <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('account_number') is-invalid @enderror" id="account_number" name="account_number" value="{{ old('account_number') }}" required>
                                    @error('account_number')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_name">اسم الحساب <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('account_name') is-invalid @enderror" id="account_name" name="account_name" value="{{ old('account_name') }}" required>
                                    @error('account_name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_type">نوع الحساب <span class="text-danger">*</span></label>
                                    <select class="form-control @error('account_type') is-invalid @enderror" id="account_type" name="account_type" required>
                                        <option value="">-- اختر نوع الحساب --</option>
                                        <option value="جاري" {{ old('account_type') == 'جاري' ? 'selected' : '' }}>جاري</option>
                                        <option value="توفير" {{ old('account_type') == 'توفير' ? 'selected' : '' }}>توفير</option>
                                        <option value="وديعة" {{ old('account_type') == 'وديعة' ? 'selected' : '' }}>وديعة</option>
                                        <option value="قرض" {{ old('account_type') == 'قرض' ? 'selected' : '' }}>قرض</option>
                                    </select>
                                    @error('account_type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="currency">العملة <span class="text-danger">*</span></label>
                                    <select class="form-control @error('currency') is-invalid @enderror" id="currency" name="currency" required>
                                        <option value="SAR" {{ old('currency') == 'SAR' ? 'selected' : '' }}>ريال سعودي (SAR)</option>
                                        <option value="USD" {{ old('currency') == 'USD' ? 'selected' : '' }}>دولار أمريكي (USD)</option>
                                        <option value="EUR" {{ old('currency') == 'EUR' ? 'selected' : '' }}>يورو (EUR)</option>
                                        <option value="GBP" {{ old('currency') == 'GBP' ? 'selected' : '' }}>جنيه إسترليني (GBP)</option>
                                        <option value="AED" {{ old('currency') == 'AED' ? 'selected' : '' }}>درهم إماراتي (AED)</option>
                                    </select>
                                    @error('currency')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="opening_balance">الرصيد الافتتاحي <span class="text-danger">*</span></label>
                                    <input type="number" step="0.01" class="form-control @error('opening_balance') is-invalid @enderror" id="opening_balance" name="opening_balance" value="{{ old('opening_balance', 0) }}" required>
                                    @error('opening_balance')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="opening_date">تاريخ الافتتاح <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('opening_date') is-invalid @enderror" id="opening_date" name="opening_date" value="{{ old('opening_date', date('Y-m-d')) }}" required>
                                    @error('opening_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="is_active">الحالة</label>
                                    <select class="form-control @error('is_active') is-invalid @enderror" id="is_active" name="is_active">
                                        <option value="1" {{ old('is_active') == '1' ? 'selected' : '' }}>نشط</option>
                                        <option value="0" {{ old('is_active') == '0' ? 'selected' : '' }}>غير نشط</option>
                                    </select>
                                    @error('is_active')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="alert alert-info mt-2">
                                    <i class="fas fa-info-circle"></i> سيتم إنشاء حساب محاسبي تلقائياً في شجرة الحسابات بنفس اسم الحساب البنكي.
                                </div>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">الوصف</label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group text-center mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ الحساب البنكي
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تحديث اسم الحساب تلقائيًا عند اختيار البنك
        $('#bank_id').change(function() {
            var bankName = $('#bank_id option:selected').text();
            if (bankName && bankName !== '-- اختر البنك --') {
                bankName = bankName.split(' - ')[0].trim();
                var accountType = $('#account_type').val();
                if (accountType) {
                    $('#account_name').val(bankName + ' - ' + accountType);
                } else {
                    $('#account_name').val(bankName + ' - حساب');
                }
            }
        });

        $('#account_type').change(function() {
            var bankName = $('#bank_id option:selected').text();
            if (bankName && bankName !== '-- اختر البنك --') {
                bankName = bankName.split(' - ')[0].trim();
                var accountType = $(this).val();
                if (accountType) {
                    $('#account_name').val(bankName + ' - ' + accountType);
                }
            }
        });
    });
</script>
@endsection