@extends('layouts.modern')

@section('title', 'التحقق من المصادقة الثنائية')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">التحقق من المصادقة الثنائية</div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('warning'))
                        <div class="alert alert-warning" role="alert">
                            {{ session('warning') }}
                        </div>
                    @endif

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> يرجى إدخال رمز المصادقة الثنائية للمتابعة.
                    </div>

                    <form method="POST" action="{{ route('two-factor.validate') }}">
                        @csrf

                        <div class="form-group row">
                            <label for="code" class="col-md-4 col-form-label text-md-right">رمز المصادقة</label>

                            <div class="col-md-6">
                                <input id="code" type="text" class="form-control @error('code') is-invalid @enderror" name="code" required autofocus>

                                @error('code')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                            <div class="col-md-8 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-check-circle"></i> تحقق
                                </button>
                            </div>
                        </div>
                    </form>

                    <hr>

                    <div class="mt-3">
                        <h5>لم تتمكن من الوصول إلى تطبيق المصادقة؟</h5>
                        
                        <p>يمكنك استخدام أحد الخيارات التالية:</p>
                        
                        <div class="mb-3">
                            <h6>1. استخدام رمز استرداد</h6>
                            <p>إذا كنت قد حفظت رموز الاسترداد، يمكنك استخدام أحدها للدخول.</p>
                            <form method="POST" action="{{ route('two-factor.validate') }}">
                                @csrf
                                <div class="form-group">
                                    <label for="recovery_code">رمز الاسترداد</label>
                                    <input id="recovery_code" type="text" class="form-control" name="code" placeholder="أدخل رمز الاسترداد">
                                </div>
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="fas fa-key"></i> استخدام رمز الاسترداد
                                </button>
                            </form>
                        </div>
                        
                        <div class="mb-3">
                            <h6>2. إرسال رمز عبر البريد الإلكتروني</h6>
                            <p>يمكننا إرسال رمز مؤقت إلى بريدك الإلكتروني المسجل.</p>
                            <form method="POST" action="{{ route('two-factor.send-email-token') }}">
                                @csrf
                                <button type="submit" class="btn btn-outline-secondary">
                                    <i class="fas fa-envelope"></i> إرسال رمز عبر البريد الإلكتروني
                                </button>
                            </form>
                        </div>
                        
                        <div class="mb-3">
                            <h6>3. الاتصال بالدعم الفني</h6>
                            <p>إذا لم تتمكن من الوصول إلى حسابك، يرجى الاتصال بفريق الدعم الفني.</p>
                            <a href="mailto:support@example.com" class="btn btn-outline-danger">
                                <i class="fas fa-headset"></i> الاتصال بالدعم الفني
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection