@extends('layouts.modern')

@section('title', 'إعداد المصادقة الثنائية')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">إعداد المصادقة الثنائية</div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> اتبع الخطوات التالية لإعداد المصادقة الثنائية لحسابك.
                    </div>

                    <div class="mb-4">
                        <h5>الخطوة 1: تثبيت تطبيق المصادقة</h5>
                        <p>قم بتثبيت تطبيق مصادقة على هاتفك الذكي:</p>
                        <div class="row">
                            <div class="col-md-6">
                                <a href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2" target="_blank" class="btn btn-outline-secondary btn-block mb-2">
                                    <i class="fab fa-google-play"></i> Google Authenticator (Android)
                                </a>
                            </div>
                            <div class="col-md-6">
                                <a href="https://apps.apple.com/us/app/google-authenticator/id388497605" target="_blank" class="btn btn-outline-secondary btn-block mb-2">
                                    <i class="fab fa-app-store-ios"></i> Google Authenticator (iOS)
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <h5>الخطوة 2: مسح رمز QR</h5>
                        <p>افتح تطبيق المصادقة وقم بمسح رمز QR التالي:</p>
                        
                        <div class="text-center my-3">
                            <img src="{{ $qrCodeUrl }}" alt="QR Code" class="img-thumbnail">
                        </div>
                        
                        <div class="alert alert-warning">
                            <strong>أو أدخل المفتاح السري يدوياً:</strong>
                            <div class="input-group mt-2">
                                <input type="text" class="form-control" value="{{ $secretKey }}" readonly>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary copy-btn" type="button" data-clipboard-text="{{ $secretKey }}">
                                        <i class="fas fa-copy"></i> نسخ
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <h5>الخطوة 3: التحقق من الإعداد</h5>
                        <p>أدخل الرمز المؤقت من تطبيق المصادقة للتحقق من الإعداد:</p>
                        
                        <form action="{{ route('two-factor.enable') }}" method="POST">
                            @csrf
                            <div class="form-group">
                                <label for="code">رمز التحقق</label>
                                <input type="text" name="code" id="code" class="form-control @error('code') is-invalid @enderror" required autofocus>
                                @error('code')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-check-circle"></i> تفعيل المصادقة الثنائية
                            </button>
                        </form>
                    </div>

                    <div class="mb-4">
                        <h5>الخطوة 4: احفظ رموز الاسترداد</h5>
                        <p>احفظ رموز الاسترداد التالية في مكان آمن. يمكنك استخدامها للوصول إلى حسابك في حالة فقدان هاتفك.</p>
                        
                        <div class="alert alert-danger">
                            <strong>تحذير:</strong> لن يتم عرض رموز الاسترداد هذه مرة أخرى. قم بنسخها واحفظها في مكان آمن.
                        </div>
                        
                        <div class="recovery-codes">
                            @foreach($recoveryCodes as $code)
                                <div class="recovery-code">{{ $code }}</div>
                            @endforeach
                        </div>
                        
                        <div class="mt-3">
                            <button class="btn btn-outline-secondary copy-all-btn" data-clipboard-text="{{ implode("\n", $recoveryCodes) }}">
                                <i class="fas fa-copy"></i> نسخ جميع الرموز
                            </button>
                            
                            <form action="{{ route('two-factor.regenerate-recovery-codes') }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-outline-warning">
                                    <i class="fas fa-sync"></i> إعادة إنشاء الرموز
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.8/clipboard.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        new ClipboardJS('.copy-btn');
        new ClipboardJS('.copy-all-btn');
        
        // إضافة تنبيه عند النسخ
        document.querySelectorAll('.copy-btn, .copy-all-btn').forEach(function(btn) {
            btn.addEventListener('click', function() {
                const originalText = btn.innerHTML;
                btn.innerHTML = '<i class="fas fa-check"></i> تم النسخ';
                setTimeout(function() {
                    btn.innerHTML = originalText;
                }, 2000);
            });
        });
    });
</script>
@endpush

@push('styles')
<style>
    .recovery-codes {
        background-color: #f8f9fa;
        border: 1px solid #ddd;
        border-radius: 4px;
        padding: 15px;
        margin-bottom: 15px;
    }
    
    .recovery-code {
        font-family: monospace;
        font-size: 16px;
        padding: 5px 0;
        border-bottom: 1px dashed #ddd;
    }
    
    .recovery-code:last-child {
        border-bottom: none;
    }
</style>
@endpush
@endsection