@extends('layouts.modern')

@section('title', 'إعدادات المصادقة الثنائية')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">إعدادات المصادقة الثنائية</div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="mb-4">
                        <h5>حالة المصادقة الثنائية</h5>
                        @if ($enabled)
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle"></i> المصادقة الثنائية مفعلة
                            </div>
                            <p>تم تفعيل المصادقة الثنائية لحسابك. هذا يوفر طبقة إضافية من الأمان لحسابك.</p>
                            
                            <form action="{{ route('two-factor.disable') }}" method="POST" class="mt-3">
                                @csrf
                                <div class="form-group">
                                    <label for="password">كلمة المرور</label>
                                    <input type="password" name="password" id="password" class="form-control @error('password') is-invalid @enderror" required>
                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <button type="submit" class="btn btn-danger mt-2">
                                    <i class="fas fa-times-circle"></i> تعطيل المصادقة الثنائية
                                </button>
                            </form>
                        @else
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle"></i> المصادقة الثنائية غير مفعلة
                            </div>
                            <p>المصادقة الثنائية غير مفعلة لحسابك. نوصي بتفعيلها لزيادة أمان حسابك.</p>
                            
                            <a href="{{ route('two-factor.setup') }}" class="btn btn-primary mt-2">
                                <i class="fas fa-shield-alt"></i> تفعيل المصادقة الثنائية
                            </a>
                        @endif
                    </div>

                    <div class="mt-4">
                        <h5>ما هي المصادقة الثنائية؟</h5>
                        <p>المصادقة الثنائية هي طبقة إضافية من الأمان لحسابك. عند تفعيلها، ستحتاج إلى إدخال رمز من تطبيق المصادقة على هاتفك بالإضافة إلى كلمة المرور عند تسجيل الدخول.</p>
                        
                        <h5 class="mt-3">كيف تعمل؟</h5>
                        <ol>
                            <li>قم بتثبيت تطبيق مصادقة على هاتفك (مثل Google Authenticator أو Authy)</li>
                            <li>قم بمسح رمز QR الذي سنوفره لك</li>
                            <li>أدخل الرمز المؤقت من التطبيق لتأكيد الإعداد</li>
                            <li>في كل مرة تقوم فيها بتسجيل الدخول، ستحتاج إلى إدخال رمز من التطبيق</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection