@extends('layouts.modern')

@section('styles')
<link rel="stylesheet" href="{{ asset('css/auth-pages.css') }}">
@endsection

@section('content')
<div class="register-page">
    <div class="register-card">
        <div class="register-container">
            <div class="register-form">
                <div class="register-header">
                    <h1>{{ __('إنشاء حساب جديد') }}</h1>
                    <p>أدخل بياناتك لإنشاء حساب في نظام إدارة المصاعد</p>
                </div>
                
                <form method="POST" action="{{ route('register') }}">
                    @csrf
                    
                    <div class="form-group">
                        <label for="name">{{ __('الاسم الكامل') }}</label>
                        <div class="input-group">
                            <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus placeholder="أدخل اسمك الكامل">
                            <span class="form-icon"><i class="fas fa-user"></i></span>
                        </div>
                        @error('name')
                            <span class="invalid-feedback d-block" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="email">{{ __('البريد الإلكتروني') }}</label>
                        <div class="input-group">
                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" placeholder="أدخل بريدك الإلكتروني">
                            <span class="form-icon"><i class="fas fa-envelope"></i></span>
                        </div>
                        @error('email')
                            <span class="invalid-feedback d-block" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="password">{{ __('كلمة المرور') }}</label>
                        <div class="input-group">
                            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" placeholder="أدخل كلمة المرور">
                            <span class="password-toggle" onclick="togglePassword('password')">
                                <i class="fas fa-eye"></i>
                            </span>
                            <span class="form-icon"><i class="fas fa-lock"></i></span>
                        </div>
                        @error('password')
                            <span class="invalid-feedback d-block" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="password-confirm">{{ __('تأكيد كلمة المرور') }}</label>
                        <div class="input-group">
                            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password" placeholder="أعد إدخال كلمة المرور">
                            <span class="password-toggle" onclick="togglePassword('password-confirm')">
                                <i class="fas fa-eye"></i>
                            </span>
                            <span class="form-icon"><i class="fas fa-lock"></i></span>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-register">
                        {{ __('إنشاء الحساب') }}
                    </button>
                    
                    <div class="login-link">
                        لديك حساب بالفعل؟ <a href="{{ route('login') }}">تسجيل الدخول</a>
                    </div>
                </form>
            </div>
            
            <div class="register-image">
                <div class="register-image-content">
                    <h2>مرحباً بك في نظام إدارة المصاعد</h2>
                    <p>النظام الأمثل لإدارة شركات المصاعد وخدماتها بكفاءة عالية</p>
                    <img src="{{ asset('images/logo.svg') }}" alt="شعار النظام" style="max-width: 150px; margin-bottom: 20px;">
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    function togglePassword(id) {
        const passwordInput = document.getElementById(id);
        const icon = passwordInput.parentNode.querySelector('.password-toggle i');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    }
</script>
@endsection
