@extends('layouts.modern')

@section('styles')
<style>
    .auth-container {
        max-width: 500px;
        margin: 50px auto;
    }
    
    .auth-card {
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        border: none;
    }
    
    .auth-card .card-header {
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        color: white;
        font-size: 1.5rem;
        font-weight: 600;
        text-align: center;
        padding: 20px;
        border-bottom: none;
    }
    
    .auth-card .card-body {
        padding: 30px;
    }
    
    .auth-form .form-control {
        border-radius: 8px;
        padding: 12px 15px;
        height: auto;
        border: 1px solid #e0e0e0;
        margin-bottom: 5px;
    }
    
    .auth-form .form-control:focus {
        border-color: #3498db;
        box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
    }
    
    .auth-form label {
        font-weight: 600;
        margin-bottom: 8px;
    }
    
    .auth-btn {
        width: 100%;
        padding: 12px;
        font-weight: 600;
        font-size: 1rem;
        border-radius: 8px;
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        border: none;
        transition: all 0.3s ease;
    }
    
    .auth-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(52, 152, 219, 0.4);
    }
    
    .auth-footer {
        text-align: center;
        margin-top: 20px;
    }
    
    .auth-footer a {
        color: #3498db;
        text-decoration: none;
        font-weight: 600;
    }
    
    .auth-footer a:hover {
        text-decoration: underline;
    }
    
    .auth-icon {
        text-align: center;
        margin-bottom: 20px;
    }
    
    .auth-icon i {
        font-size: 3rem;
        color: #3498db;
    }
    
    .password-strength {
        height: 5px;
        margin-top: 5px;
        border-radius: 5px;
        transition: all 0.3s ease;
    }
    
    .password-feedback {
        font-size: 0.8rem;
        margin-top: 5px;
    }
</style>
@endsection

@section('content')
<div class="container auth-container">
    <div class="card auth-card">
        <div class="card-header">
            {{ __('إعادة تعيين كلمة المرور') }}
        </div>

        <div class="card-body">
            <div class="auth-icon">
                <i class="fas fa-lock"></i>
            </div>
            
            <p class="text-center mb-4">أدخل بريدك الإلكتروني وكلمة المرور الجديدة</p>

            <form method="POST" action="{{ route('password.update') }}" class="auth-form">
                @csrf

                <input type="hidden" name="token" value="{{ $token }}">

                <div class="mb-3">
                    <label for="email" class="form-label">{{ __('البريد الإلكتروني') }}</label>
                    <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus placeholder="أدخل بريدك الإلكتروني">

                    @error('email')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">{{ __('كلمة المرور الجديدة') }}</label>
                    <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" placeholder="أدخل كلمة المرور الجديدة">
                    
                    <div class="password-strength bg-light" id="password-strength"></div>
                    <div class="password-feedback text-muted" id="password-feedback"></div>

                    @error('password')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="password-confirm" class="form-label">{{ __('تأكيد كلمة المرور') }}</label>
                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password" placeholder="أعد إدخال كلمة المرور الجديدة">
                </div>

                <div class="mb-3 mt-4">
                    <button type="submit" class="btn btn-primary auth-btn">
                        <i class="fas fa-save me-2"></i>{{ __('إعادة تعيين كلمة المرور') }}
                    </button>
                </div>
            </form>
            
            <div class="auth-footer">
                <a href="{{ route('login') }}"><i class="fas fa-arrow-right me-1"></i> العودة إلى تسجيل الدخول</a>
            </div>
        </div>
    </div>
</div>

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const passwordInput = document.getElementById('password');
        const passwordStrength = document.getElementById('password-strength');
        const passwordFeedback = document.getElementById('password-feedback');
        
        passwordInput.addEventListener('input', function() {
            const password = passwordInput.value;
            let strength = 0;
            let feedback = '';
            
            if (password.length >= 8) {
                strength += 25;
            }
            
            if (password.match(/[A-Z]/)) {
                strength += 25;
            }
            
            if (password.match(/[0-9]/)) {
                strength += 25;
            }
            
            if (password.match(/[^A-Za-z0-9]/)) {
                strength += 25;
            }
            
            // Update strength bar
            passwordStrength.style.width = strength + '%';
            
            // Set color based on strength
            if (strength < 25) {
                passwordStrength.style.backgroundColor = '#e74c3c';
                feedback = 'ضعيفة جدًا';
            } else if (strength < 50) {
                passwordStrength.style.backgroundColor = '#e67e22';
                feedback = 'ضعيفة';
            } else if (strength < 75) {
                passwordStrength.style.backgroundColor = '#f1c40f';
                feedback = 'متوسطة';
            } else {
                passwordStrength.style.backgroundColor = '#2ecc71';
                feedback = 'قوية';
            }
            
            passwordFeedback.textContent = 'قوة كلمة المرور: ' + feedback;
        });
    });
</script>
@endsection
@endsection
