@extends('layouts.modern')

@section('styles')
<style>
    .auth-container {
        max-width: 500px;
        margin: 50px auto;
    }
    
    .auth-card {
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        border: none;
    }
    
    .auth-card .card-header {
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        color: white;
        font-size: 1.5rem;
        font-weight: 600;
        text-align: center;
        padding: 20px;
        border-bottom: none;
    }
    
    .auth-card .card-body {
        padding: 30px;
    }
    
    .auth-form .form-control {
        border-radius: 8px;
        padding: 12px 15px;
        height: auto;
        border: 1px solid #e0e0e0;
        margin-bottom: 5px;
    }
    
    .auth-form .form-control:focus {
        border-color: #3498db;
        box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
    }
    
    .auth-form label {
        font-weight: 600;
        margin-bottom: 8px;
    }
    
    .auth-btn {
        width: 100%;
        padding: 12px;
        font-weight: 600;
        font-size: 1rem;
        border-radius: 8px;
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        border: none;
        transition: all 0.3s ease;
    }
    
    .auth-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(52, 152, 219, 0.4);
    }
    
    .auth-footer {
        text-align: center;
        margin-top: 20px;
    }
    
    .auth-footer a {
        color: #3498db;
        text-decoration: none;
        font-weight: 600;
    }
    
    .auth-footer a:hover {
        text-decoration: underline;
    }
    
    .auth-icon {
        text-align: center;
        margin-bottom: 20px;
    }
    
    .auth-icon i {
        font-size: 3rem;
        color: #3498db;
    }
</style>
@endsection

@section('content')
<div class="container auth-container">
    <div class="card auth-card">
        <div class="card-header">
            {{ __('إعادة تعيين كلمة المرور') }}
        </div>

        <div class="card-body">
            <div class="auth-icon">
                <i class="fas fa-key"></i>
            </div>
            
            @if (session('status'))
                <div class="alert alert-success" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    {{ session('status') }}
                </div>
            @endif

            <p class="text-center mb-4">أدخل عنوان بريدك الإلكتروني وسنرسل لك رابطًا لإعادة تعيين كلمة المرور</p>

            <form method="POST" action="{{ route('password.email') }}" class="auth-form">
                @csrf

                <div class="mb-3">
                    <label for="email" class="form-label">{{ __('البريد الإلكتروني') }}</label>
                    <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="أدخل بريدك الإلكتروني">

                    @error('email')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>

                <div class="mb-3 mt-4">
                    <button type="submit" class="btn btn-primary auth-btn">
                        <i class="fas fa-paper-plane me-2"></i>{{ __('إرسال رابط إعادة التعيين') }}
                    </button>
                </div>
            </form>
            
            <div class="auth-footer">
                <a href="{{ route('login') }}"><i class="fas fa-arrow-right me-1"></i> العودة إلى تسجيل الدخول</a>
            </div>
        </div>
    </div>
</div>
@endsection
