@extends('layouts.modern')

@section('title', 'تسجيل الدخول')

@section('styles')
<link rel="stylesheet" href="{{ asset('css/auth-pages.css') }}">
@endsection

@section('content')
<div class="login-page">
    <div class="login-card">
        <div class="login-container">
            <div class="login-form">
                <div class="login-header">
                    <h1>{{ __('تسجيل الدخول') }}</h1>
                    <p>أدخل بيانات حسابك للوصول إلى نظام إدارة المصاعد</p>
                </div>
                
                <form method="POST" action="{{ route('login') }}">
                    @csrf
                    
                    <div class="form-group">
                        <label for="email">{{ __('البريد الإلكتروني') }}</label>
                        <div class="input-group">
                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="أدخل بريدك الإلكتروني">
                            <span class="form-icon"><i class="fas fa-envelope"></i></span>
                        </div>
                        @error('email')
                            <span class="invalid-feedback d-block" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="password">{{ __('كلمة المرور') }}</label>
                        <div class="input-group">
                            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password" placeholder="أدخل كلمة المرور">
                            <span class="password-toggle" onclick="togglePassword('password')">
                                <i class="fas fa-eye"></i>
                            </span>
                            <span class="form-icon"><i class="fas fa-lock"></i></span>
                        </div>
                        @error('password')
                            <span class="invalid-feedback d-block" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    
                    <div class="remember-me">
                        <label for="remember">
                            <input type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                            {{ __('تذكرني') }}
                        </label>
                        
                        @if (Route::has('password.request'))
                            <div class="forgot-password">
                                <a href="{{ route('password.request') }}">
                                    {{ __('نسيت كلمة المرور؟') }}
                                </a>
                            </div>
                        @endif
                    </div>
                    
                    <button type="submit" class="btn btn-login">
                        {{ __('تسجيل الدخول') }}
                    </button>
                    
                    <div class="register-link">
                        ليس لديك حساب؟ <a href="{{ route('register') }}">إنشاء حساب جديد</a>
                    </div>
                </form>
                
                <!-- بيانات الدخول التجريبية -->
                <div class="demo-credentials mt-4">
                    <h5>
                        <i class="fas fa-info-circle me-2"></i>
                        بيانات الدخول التجريبية
                    </h5>
                    <div class="row mt-2">
                        <div class="col-md-6">
                            <div class="input-group mb-2">
                                <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                <input type="text" class="form-control" value="demo@elevators.com" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="input-group mb-2">
                                <span class="input-group-text"><i class="fas fa-key"></i></span>
                                <input type="text" class="form-control" value="demo123" readonly>
                            </div>
                        </div>
                    </div>
                    <div class="text-center mt-3">
                        <button type="button" class="btn btn-warning" onclick="fillDemoCredentials()">
                            <i class="fas fa-sign-in-alt me-2"></i>
                            استخدام بيانات الدخول التجريبية
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="login-image">
                <div class="login-image-content">
                    <h2>مرحباً بك في نظام إدارة المصاعد</h2>
                    <p>النظام الأمثل لإدارة شركات المصاعد وخدماتها بكفاءة عالية</p>
                    <img src="{{ asset('images/logo.svg') }}" alt="شعار النظام" style="max-width: 150px; margin-bottom: 20px;">
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    function togglePassword(id) {
        const passwordInput = document.getElementById(id);
        const icon = passwordInput.parentNode.querySelector('.password-toggle i');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    }
    
    function fillDemoCredentials() {
        document.getElementById('email').value = 'demo@elevators.com';
        document.getElementById('password').value = 'demo123';
    }
</script>
@endsection
