@extends('layouts.modern')

@section('title', 'تفاصيل الدور: ' . $role->name)

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>تفاصيل الدور: {{ $role->name }}</span>
                    <div>
                        <a href="{{ route('roles.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للقائمة
                        </a>
                        <a href="{{ route('roles.edit', $role) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">معلومات الدور</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">الاسم</th>
                                            <td>
                                                {{ $role->name }}
                                                @if($role->is_system_role)
                                                    <span class="badge badge-info">نظامي</span>
                                                @endif
                                                @if($role->is_default)
                                                    <span class="badge badge-warning">افتراضي</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>المعرف</th>
                                            <td>{{ $role->slug }}</td>
                                        </tr>
                                        <tr>
                                            <th>الوصف</th>
                                            <td>{{ $role->description ?: 'لا يوجد وصف' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الدور الأب</th>
                                            <td>{{ $role->parent ? $role->parent->name : 'لا يوجد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الشركة</th>
                                            <td>{{ $role->company ? $role->company->name : 'جميع الشركات' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الترتيب</th>
                                            <td>{{ $role->order }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($role->is_active)
                                                    <span class="badge badge-success">مفعل</span>
                                                @else
                                                    <span class="badge badge-danger">معطل</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $role->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $role->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            @if($role->children->count() > 0)
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">الأدوار الفرعية</h5>
                                </div>
                                <div class="card-body">
                                    <ul class="list-group">
                                        @foreach($role->children as $child)
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <div>
                                                    <a href="{{ route('roles.show', $child) }}">{{ $child->name }}</a>
                                                    @if($child->is_system_role)
                                                        <span class="badge badge-info">نظامي</span>
                                                    @endif
                                                    @if($child->is_default)
                                                        <span class="badge badge-warning">افتراضي</span>
                                                    @endif
                                                </div>
                                                <div>
                                                    <span class="badge badge-primary badge-pill">{{ $child->users()->count() }} مستخدم</span>
                                                    <span class="badge badge-secondary badge-pill">{{ $child->permissions()->count() }} صلاحية</span>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            @endif
                        </div>

                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">الصلاحيات ({{ $permissions->total() }})</h5>
                                </div>
                                <div class="card-body">
                                    @if($permissions->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>الاسم</th>
                                                        <th>المجموعة</th>
                                                        <th>الوصف</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($permissions as $permission)
                                                        <tr>
                                                            <td>{{ $permission->name }}</td>
                                                            <td>{{ $permission->group }}</td>
                                                            <td>{{ $permission->description }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="mt-3">
                                            {{ $permissions->links() }}
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد صلاحيات مرتبطة بهذا الدور.
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">المستخدمون ({{ $users->total() }})</h5>
                                </div>
                                <div class="card-body">
                                    @if($users->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>الاسم</th>
                                                        <th>البريد الإلكتروني</th>
                                                        <th>الشركة</th>
                                                        <th>الفرع</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($users as $user)
                                                        <tr>
                                                            <td>
                                                                <a href="{{ route('users.show', $user) }}">{{ $user->name }}</a>
                                                            </td>
                                                            <td>{{ $user->email }}</td>
                                                            <td>{{ $user->company ? $user->company->name : 'غير محدد' }}</td>
                                                            <td>{{ $user->branch ? $user->branch->name : 'غير محدد' }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="mt-3">
                                            {{ $users->links() }}
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا يوجد مستخدمون مرتبطون بهذا الدور.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection