@foreach($children as $child)
    <tr>
        <td>
            <div style="padding-right: {{ $level * 20 }}px;">
                <i class="fas fa-level-down-alt fa-rotate-90 mr-2"></i>
                {{ $child->name }}
                @if($child->is_system_role)
                    <span class="badge badge-info">نظامي</span>
                @endif
                @if($child->is_default)
                    <span class="badge badge-warning">افتراضي</span>
                @endif
            </div>
        </td>
        <td>{{ $child->slug }}</td>
        <td>{{ Str::limit($child->description, 50) }}</td>
        <td>{{ $child->users_count ?? $child->users()->count() }}</td>
        <td>{{ $child->permissions_count ?? $child->permissions()->count() }}</td>
        <td>
            @if($child->is_active)
                <span class="badge badge-success">مفعل</span>
            @else
                <span class="badge badge-danger">معطل</span>
            @endif
        </td>
        <td>
            <div class="btn-group btn-group-sm">
                <a href="{{ route('roles.show', $child) }}" class="btn btn-info">
                    <i class="fas fa-eye"></i>
                </a>
                <a href="{{ route('roles.edit', $child) }}" class="btn btn-primary">
                    <i class="fas fa-edit"></i>
                </a>
                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal{{ $child->id }}">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
            
            <!-- Modal -->
            <div class="modal fade" id="deleteModal{{ $child->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $child->id }}" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteModalLabel{{ $child->id }}">تأكيد الحذف</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            هل أنت متأكد من حذف الدور <strong>{{ $child->name }}</strong>؟
                            @if($child->is_system_role)
                                <div class="alert alert-warning mt-2">
                                    <i class="fas fa-exclamation-triangle"></i> هذا دور نظامي ولا يمكن حذفه.
                                </div>
                            @endif
                            @if($child->children()->count() > 0)
                                <div class="alert alert-warning mt-2">
                                    <i class="fas fa-exclamation-triangle"></i> هذا الدور يحتوي على أدوار فرعية ولا يمكن حذفه.
                                </div>
                            @endif
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                            <form action="{{ route('roles.destroy', $child) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger" {{ $child->is_system_role || $child->children()->count() > 0 ? 'disabled' : '' }}>حذف</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </td>
    </tr>
    
    @if($child->children->count() > 0)
        @include('admin.roles.partials.child-roles', ['children' => $child->children, 'level' => $level + 1])
    @endif
@endforeach