@extends('layouts.modern')

@section('title', 'إدارة الأدوار')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>إدارة الأدوار</span>
                    <div>
                        <a href="{{ route('roles.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> إضافة دور جديد
                        </a>
                        <a href="{{ route('roles.manage-users') }}" class="btn btn-sm btn-info">
                            <i class="fas fa-users"></i> إدارة أدوار المستخدمين
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>الاسم</th>
                                    <th>المعرف</th>
                                    <th>الوصف</th>
                                    <th>عدد المستخدمين</th>
                                    <th>عدد الصلاحيات</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($roles as $role)
                                    <tr>
                                        <td>
                                            <strong>{{ $role->name }}</strong>
                                            @if($role->is_system_role)
                                                <span class="badge badge-info">نظامي</span>
                                            @endif
                                            @if($role->is_default)
                                                <span class="badge badge-warning">افتراضي</span>
                                            @endif
                                        </td>
                                        <td>{{ $role->slug }}</td>
                                        <td>{{ Str::limit($role->description, 50) }}</td>
                                        <td>{{ $role->users_count ?? $role->users()->count() }}</td>
                                        <td>{{ $role->permissions_count ?? $role->permissions()->count() }}</td>
                                        <td>
                                            @if($role->is_active)
                                                <span class="badge badge-success">مفعل</span>
                                            @else
                                                <span class="badge badge-danger">معطل</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('roles.show', $role) }}" class="btn btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('roles.edit', $role) }}" class="btn btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal{{ $role->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                            
                                            <!-- Modal -->
                                            <div class="modal fade" id="deleteModal{{ $role->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $role->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $role->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف الدور <strong>{{ $role->name }}</strong>؟
                                                            @if($role->is_system_role)
                                                                <div class="alert alert-warning mt-2">
                                                                    <i class="fas fa-exclamation-triangle"></i> هذا دور نظامي ولا يمكن حذفه.
                                                                </div>
                                                            @endif
                                                            @if($role->children()->count() > 0)
                                                                <div class="alert alert-warning mt-2">
                                                                    <i class="fas fa-exclamation-triangle"></i> هذا الدور يحتوي على أدوار فرعية ولا يمكن حذفه.
                                                                </div>
                                                            @endif
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('roles.destroy', $role) }}" method="POST" class="d-inline">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger" {{ $role->is_system_role || $role->children()->count() > 0 ? 'disabled' : '' }}>حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    
                                    @if($role->children->count() > 0)
                                        @include('admin.roles.partials.child-roles', ['children' => $role->children, 'level' => 1])
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection