@extends('layouts.modern')

@section('title', 'تعديل الدور: ' . $role->name)

@section('content')
<div class="container-fluid px-0">
    <div class="row mx-0">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <span><i class="fas fa-user-shield ml-2"></i> تعديل الدور: {{ $role->name }}</span>
                    <div>
                        <a href="{{ route('roles.index') }}" class="btn btn-sm btn-light">
                            <i class="fas fa-arrow-right ml-1"></i> العودة للقائمة
                        </a>
                        <a href="{{ route('roles.show', $role) }}" class="btn btn-sm btn-info">
                            <i class="fas fa-eye ml-1"></i> عرض التفاصيل
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('roles.update', $role) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row mx-0">
                            <div class="col-md-3">
                                <div class="card mb-4 shadow-sm">
                                    <div class="card-header bg-light">
                                        <h5 class="mb-0"><i class="fas fa-info-circle ml-2"></i> معلومات الدور</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group mb-3">
                                            <label for="name">اسم الدور <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $role->name) }}" required {{ $role->is_system_role ? 'readonly' : '' }}>
                                            @error('name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group mb-3">
                                            <label for="slug">معرف الدور <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('slug') is-invalid @enderror" id="slug" name="slug" value="{{ old('slug', $role->slug) }}" required {{ $role->is_system_role ? 'readonly' : '' }}>
                                            <small class="form-text text-muted">يجب أن يكون المعرف فريداً ويتكون من أحرف إنجليزية صغيرة وأرقام وشرطات سفلية فقط.</small>
                                            @error('slug')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group mb-3">
                                            <label for="description">وصف الدور</label>
                                            <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" {{ $role->is_system_role ? 'readonly' : '' }}>{{ old('description', $role->description) }}</textarea>
                                            @error('description')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group mb-3">
                                            <label for="parent_id">الدور الأب</label>
                                            <select class="form-control @error('parent_id') is-invalid @enderror" id="parent_id" name="parent_id" {{ $role->is_system_role ? 'disabled' : '' }}>
                                                <option value="">بدون دور أب</option>
                                                @foreach($roles as $parentRole)
                                                    <option value="{{ $parentRole->id }}" {{ old('parent_id', $role->parent_id) == $parentRole->id ? 'selected' : '' }}>
                                                        {{ $parentRole->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('parent_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group mb-3">
                                            <label for="order">الترتيب</label>
                                            <input type="number" class="form-control @error('order') is-invalid @enderror" id="order" name="order" value="{{ old('order', $role->order) }}" {{ $role->is_system_role ? 'readonly' : '' }}>
                                            @error('order')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group mb-3">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', $role->is_active) ? 'checked' : '' }} {{ $role->is_system_role ? 'disabled' : '' }}>
                                                <label class="custom-control-label" for="is_active">مفعل</label>
                                            </div>
                                        </div>

                                        <div class="form-group mb-3">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="is_default" name="is_default" value="1" {{ old('is_default', $role->is_default) ? 'checked' : '' }} {{ $role->is_system_role ? 'disabled' : '' }}>
                                                <label class="custom-control-label" for="is_default">افتراضي للمستخدمين الجدد</label>
                                            </div>
                                        </div>

                                        @if($role->is_system_role)
                                            <div class="alert alert-warning mt-3">
                                                <i class="fas fa-exclamation-triangle ml-1"></i> هذا دور نظامي ولا يمكن تعديل معلوماته الأساسية.
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-9">
                                <div class="card shadow-sm">
                                    <div class="card-header bg-light">
                                        <h5 class="mb-0"><i class="fas fa-key ml-2"></i> الصلاحيات</h5>
                                    </div>
                                    <div class="card-body permissions-container" style="max-height: 800px; overflow-y: auto; padding: 0.75rem;">
                                        @if($permissions->count() > 0)
                                            <div class="mb-3">
                                                <div class="input-group mb-3">
                                                    <input type="text" id="permission-search" class="form-control" placeholder="البحث عن صلاحيات...">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text"><i class="fas fa-search"></i></span>
                                                    </div>
                                                </div>
                                                <button type="button" class="btn btn-sm btn-outline-primary" id="select-all">
                                                    <i class="fas fa-check-square ml-1"></i> تحديد الكل
                                                </button>
                                                <button type="button" class="btn btn-sm btn-outline-secondary" id="deselect-all">
                                                    <i class="fas fa-square ml-1"></i> إلغاء تحديد الكل
                                                </button>
                                            </div>
                                            
                                            @foreach($permissions as $group => $groupPermissions)
                                                <div class="card mb-3 shadow-sm">
                                                    <div class="card-header bg-light">
                                                        <div class="custom-control custom-checkbox">
                                                            @php
                                                                $safeGroupId = preg_replace('/[^a-zA-Z0-9]/', '_', $group);
                                                            @endphp
                                                            <input type="checkbox" class="custom-control-input group-checkbox" id="group_{{ $safeGroupId }}" data-group="{{ $group }}">
                                                            <label class="custom-control-label" for="group_{{ $safeGroupId }}">
                                                                @php
                                                                    // مصفوفة الترجمات المباشرة للمجموعات
                                                                    $directGroupTranslations = [
                                                                        'invoices' => 'الفواتير',
                                                                        'invoice_templates' => 'قوالب الفواتير',
                                                                        'invoice_installments' => 'أقساط الفواتير',
                                                                        'tax_reports' => 'تقارير الضرائب',
                                                                        'financial_reports' => 'التقارير المالية',
                                                                        'customer_statements' => 'كشوف حساب العملاء',
                                                                        'auto_purchase' => 'الشراء التلقائي',
                                                                        'inventory' => 'المخزون',
                                                                        'hrm' => 'الموارد البشرية',
                                                                        'installation_projects' => 'المشاريع والتركيبات',
                                                                        'project_inventory' => 'طلبات المخزون للمشاريع',
                                                                        '' => 'عام'
                                                                    ];
                                                                    
                                                                    // أولاً، تحقق من وجود ترجمة مباشرة
                                                                    if (isset($directGroupTranslations[$group])) {
                                                                        $translatedGroup = $directGroupTranslations[$group];
                                                                    } else {
                                                                        // إذا لم توجد ترجمة مباشرة، استخدم ملف الترجمة
                                                                        $groupKey = str_replace('.', '_', $group);
                                                                        $translatedGroup = __('permissions.'.$groupKey);
                                                                        if ($translatedGroup == 'permissions.'.$groupKey) {
                                                                            $translatedGroup = $group ?: 'عام';
                                                                        }
                                                                    }
                                                                @endphp
                                                                <strong>{{ $translatedGroup }}</strong>
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="card-body py-2 px-3">
                                                        <div class="row mx-0">
                                                            @foreach($groupPermissions as $permission)
                                                                <div class="col-md-2">
                                                                    <div class="custom-control custom-checkbox mb-2">
                                                                        <input type="checkbox" class="custom-control-input permission-checkbox" id="permission_{{ $permission->id }}" name="permissions[]" value="{{ $permission->id }}" data-group="{{ $group }}" {{ in_array($permission->id, old('permissions', $rolePermissions)) ? 'checked' : '' }}>
                                                                        <label class="custom-control-label" for="permission_{{ $permission->id }}">
                                                                            @php
                                                                                // مصفوفة الترجمات المباشرة للصلاحيات التي تحتوي على نقطة
                                                                                $directTranslations = [
                                                                                    // الفواتير
                                                                                    'invoices.view' => 'عرض الفواتير',
                                                                                    'invoices.create' => 'إنشاء فواتير',
                                                                                    'invoices.edit' => 'تعديل الفواتير',
                                                                                    'invoices.delete' => 'حذف الفواتير',
                                                                                    'invoices.export' => 'تصدير الفواتير',
                                                                                    'invoices.generate_recurring' => 'إنشاء فواتير متكررة',
                                                                                    'invoices.create_installments' => 'إنشاء أقساط للفواتير',
                                                                                    'invoice_templates.view' => 'عرض قوالب الفواتير',
                                                                                    'invoice_templates.create' => 'إنشاء قوالب الفواتير',
                                                                                    'invoice_templates.edit' => 'تعديل قوالب الفواتير',
                                                                                    'invoice_templates.delete' => 'حذف قوالب الفواتير',
                                                                                    'invoice_installments.view' => 'عرض أقساط الفواتير',
                                                                                    'invoice_installments.create' => 'إنشاء أقساط الفواتير',
                                                                                    'invoice_installments.edit' => 'تعديل أقساط الفواتير',
                                                                                    'invoice_installments.delete' => 'حذف أقساط الفواتير',
                                                                                    'tax_reports.view' => 'عرض تقارير الضرائب',
                                                                                    'tax_reports.create' => 'إنشاء تقارير الضرائب',
                                                                                    'tax_reports.edit' => 'تعديل تقارير الضرائب',
                                                                                    'tax_reports.delete' => 'حذف تقارير الضرائب',
                                                                                    'tax_reports.export' => 'تصدير تقارير الضرائب',
                                                                                    'financial_reports.view' => 'عرض التقارير المالية',
                                                                                    'financial_reports.export' => 'تصدير التقارير المالية',
                                                                                    
                                                                                    // الموارد البشرية
                                                                                    'hrm.view_employees' => 'عرض الموظفين',
                                                                                    'hrm.create_employee' => 'إضافة موظف',
                                                                                    'hrm.edit_employee' => 'تعديل موظف',
                                                                                    'hrm.delete_employee' => 'حذف موظف',
                                                                                    'hrm.manage_employees' => 'إدارة الموظفين',
                                                                                    'hrm.view_departments' => 'عرض الأقسام',
                                                                                    'hrm.create_department' => 'إضافة قسم',
                                                                                    'hrm.edit_department' => 'تعديل قسم',
                                                                                    'hrm.delete_department' => 'حذف قسم',
                                                                                    'hrm.manage_departments' => 'إدارة الأقسام',
                                                                                    'hrm.view_attendance' => 'عرض الحضور',
                                                                                    'hrm.create_attendance' => 'تسجيل حضور',
                                                                                    'hrm.edit_attendance' => 'تعديل حضور',
                                                                                    'hrm.delete_attendance' => 'حذف حضور',
                                                                                    'hrm.manage_attendance' => 'إدارة الحضور',
                                                                                    'hrm.view_leaves' => 'عرض الإجازات',
                                                                                    'hrm.create_leave' => 'إضافة إجازة',
                                                                                    'hrm.edit_leave' => 'تعديل إجازة',
                                                                                    'hrm.delete_leave' => 'حذف إجازة',
                                                                                    'hrm.manage_leaves' => 'إدارة الإجازات',
                                                                                    'hrm.approve_leave' => 'الموافقة على الإجازة',
                                                                                    'hrm.reject_leave' => 'رفض الإجازة',
                                                                                    'hrm.view_leave_types' => 'عرض أنواع الإجازات',
                                                                                    'hrm.create_leave_type' => 'إنشاء نوع إجازة',
                                                                                    'hrm.edit_leave_type' => 'تعديل نوع إجازة',
                                                                                    'hrm.delete_leave_type' => 'حذف نوع إجازة',
                                                                                    'hrm.manage_leave_types' => 'إدارة أنواع الإجازات',
                                                                                    'hrm.view_salaries' => 'عرض الرواتب',
                                                                                    'hrm.create_salary' => 'إضافة راتب',
                                                                                    'hrm.edit_salary' => 'تعديل راتب',
                                                                                    'hrm.delete_salary' => 'حذف راتب',
                                                                                    'hrm.manage_salaries' => 'إدارة الرواتب',
                                                                                    'hrm.view_salary_components' => 'عرض مكونات الراتب',
                                                                                    'hrm.create_salary_component' => 'إنشاء مكون راتب',
                                                                                    'hrm.edit_salary_component' => 'تعديل مكون راتب',
                                                                                    'hrm.delete_salary_component' => 'حذف مكون راتب',
                                                                                    'hrm.manage_salary_components' => 'إدارة مكونات الراتب',
                                                                                    'hrm.view_payrolls' => 'عرض كشوف الرواتب',
                                                                                    'hrm.create_payroll' => 'إنشاء كشف رواتب',
                                                                                    'hrm.edit_payroll' => 'تعديل كشف رواتب',
                                                                                    'hrm.delete_payroll' => 'حذف كشف رواتب',
                                                                                    'hrm.manage_payrolls' => 'إدارة كشوف الرواتب',
                                                                                    'hrm.generate_payroll' => 'إنشاء كشف رواتب',
                                                                                    'hrm.approve_payroll' => 'اعتماد كشف رواتب',
                                                                                    'hrm.manage_hrm' => 'إدارة الموارد البشرية',
                                                                                    'customer_statements.view' => 'عرض كشوف حساب العملاء',
                                                                                    'customer_statements.export' => 'تصدير كشوف حساب العملاء',
                                                                                    // صلاحيات الشراء التلقائي
                                                                                    'view_auto_purchase' => 'عرض الشراء التلقائي',
                                                                                    'create_auto_purchase' => 'إنشاء شراء تلقائي',
                                                                                    'edit_auto_purchase' => 'تعديل الشراء التلقائي',
                                                                                    'delete_auto_purchase' => 'حذف الشراء التلقائي',
                                                                                    'run_auto_purchase_check' => 'تشغيل فحص الشراء التلقائي',
                                                                                    'view_auto_purchase_dashboard' => 'عرض لوحة تحكم الشراء التلقائي',
                                                                                    'view_auto_purchase_history' => 'عرض سجل الشراء التلقائي',
                                                                                    
                                                                                    // ترجمات مباشرة للصلاحيات الفردية
                                                                                    'view_employees' => 'عرض الموظفين',
                                                                                    'create_employee' => 'إضافة موظف',
                                                                                    'edit_employee' => 'تعديل موظف',
                                                                                    'delete_employee' => 'حذف موظف',
                                                                                    'manage_employees' => 'إدارة الموظفين',
                                                                                    'view_departments' => 'عرض الأقسام',
                                                                                    'create_department' => 'إضافة قسم',
                                                                                    'edit_department' => 'تعديل قسم',
                                                                                    'delete_department' => 'حذف قسم',
                                                                                    'manage_departments' => 'إدارة الأقسام',
                                                                                    'view_attendance' => 'عرض الحضور',
                                                                                    'create_attendance' => 'تسجيل حضور',
                                                                                    'edit_attendance' => 'تعديل حضور',
                                                                                    'delete_attendance' => 'حذف حضور',
                                                                                    'manage_attendance' => 'إدارة الحضور',
                                                                                    'view_leaves' => 'عرض الإجازات',
                                                                                    'create_leave' => 'إضافة إجازة',
                                                                                    'edit_leave' => 'تعديل إجازة',
                                                                                    'delete_leave' => 'حذف إجازة',
                                                                                    'manage_leaves' => 'إدارة الإجازات',
                                                                                    'approve_leave' => 'الموافقة على الإجازة',
                                                                                    'reject_leave' => 'رفض الإجازة',
                                                                                    'view_leave_types' => 'عرض أنواع الإجازات',
                                                                                    'create_leave_type' => 'إنشاء نوع إجازة',
                                                                                    'edit_leave_type' => 'تعديل نوع إجازة',
                                                                                    'delete_leave_type' => 'حذف نوع إجازة',
                                                                                    'manage_leave_types' => 'إدارة أنواع الإجازات',
                                                                                    'view_salaries' => 'عرض الرواتب',
                                                                                    'create_salary' => 'إضافة راتب',
                                                                                    'edit_salary' => 'تعديل راتب',
                                                                                    'delete_salary' => 'حذف راتب',
                                                                                    'manage_salaries' => 'إدارة الرواتب',
                                                                                    'view_salary_components' => 'عرض مكونات الراتب',
                                                                                    'create_salary_component' => 'إنشاء مكون راتب',
                                                                                    'edit_salary_component' => 'تعديل مكون راتب',
                                                                                    'delete_salary_component' => 'حذف مكون راتب',
                                                                                    'manage_salary_components' => 'إدارة مكونات الراتب',
                                                                                    'view_payrolls' => 'عرض كشوف الرواتب',
                                                                                    'create_payroll' => 'إنشاء كشف رواتب',
                                                                                    'edit_payroll' => 'تعديل كشف رواتب',
                                                                                    'delete_payroll' => 'حذف كشف رواتب',
                                                                                    'manage_payrolls' => 'إدارة كشوف الرواتب',
                                                                                    'generate_payroll' => 'إنشاء كشف رواتب',
                                                                                    'approve_payroll' => 'اعتماد كشف رواتب',
                                                                                    'manage_hrm' => 'إدارة الموارد البشرية',
                                                                                    
                                                                                    // ترجمات مشاريع التركيب
                                                                                    'add_project_checklist' => 'إضافة قائمة تحقق للمشروع',
                                                                                    'add_project_document' => 'إضافة مستند للمشروع',
                                                                                    'add_project_elevator' => 'إضافة مصعد للمشروع',
                                                                                    'add_project_expense' => 'إضافة مصروف للمشروع',
                                                                                    'add_project_issue' => 'إضافة مشكلة للمشروع',
                                                                                    'add_project_milestone' => 'إضافة معلم للمشروع',
                                                                                    'add_project_payment' => 'إضافة دفعة للمشروع',
                                                                                    'add_project_phase' => 'إضافة مرحلة للمشروع',
                                                                                    'add_project_task' => 'إضافة مهمة للمشروع',
                                                                                    'add_project_team_member' => 'إضافة عضو فريق للمشروع',
                                                                                    'approve_project_expense' => 'الموافقة على مصروف المشروع',
                                                                                    'assign_project_task' => 'تعيين مهمة المشروع',
                                                                                    'complete_project_checklist' => 'إكمال قائمة تحقق المشروع',
                                                                                    'complete_project_milestone' => 'إكمال معلم المشروع',
                                                                                    'create_installation_project' => 'إنشاء مشروع تركيب',
                                                                                    'delete_installation_project' => 'حذف مشروع تركيب',
                                                                                    'delete_project_checklist' => 'حذف قائمة تحقق المشروع',
                                                                                    'delete_project_document' => 'حذف مستند المشروع',
                                                                                    'delete_project_elevator' => 'حذف مصعد المشروع',
                                                                                    'delete_project_expense' => 'حذف مصروف المشروع',
                                                                                    'delete_project_issue' => 'حذف مشكلة المشروع',
                                                                                    'delete_project_milestone' => 'حذف معلم المشروع',
                                                                                    'delete_project_payment' => 'حذف دفعة المشروع',
                                                                                    'delete_project_phase' => 'حذف مرحلة المشروع',
                                                                                    'delete_project_task' => 'حذف مهمة المشروع',
                                                                                    'delete_project_team_member' => 'حذف عضو فريق المشروع',
                                                                                    'edit_installation_project' => 'تعديل مشروع تركيب',
                                                                                    'edit_project_checklist' => 'تعديل قائمة تحقق المشروع',
                                                                                    'edit_project_document' => 'تعديل مستند المشروع',
                                                                                    'edit_project_elevator' => 'تعديل مصعد المشروع',
                                                                                    'edit_project_expense' => 'تعديل مصروف المشروع',
                                                                                    'edit_project_issue' => 'تعديل مشكلة المشروع',
                                                                                    'edit_project_milestone' => 'تعديل معلم المشروع',
                                                                                    'edit_project_payment' => 'تعديل دفعة المشروع',
                                                                                    'edit_project_phase' => 'تعديل مرحلة المشروع',
                                                                                    'edit_project_task' => 'تعديل مهمة المشروع',
                                                                                    'edit_project_team_member' => 'تعديل عضو فريق المشروع',
                                                                                    'manage_installation_projects' => 'إدارة مشاريع التركيب',
                                                                                    'resolve_project_issue' => 'حل مشكلة المشروع',
                                                                                    'view_installation_projects' => 'عرض مشاريع التركيب',
                                                                                    'view_project_checklists' => 'عرض قوائم تحقق المشروع',
                                                                                    'view_project_documents' => 'عرض مستندات المشروع',
                                                                                    'view_project_elevators' => 'عرض مصاعد المشروع',
                                                                                    'view_project_expenses' => 'عرض مصروفات المشروع',
                                                                                    'view_project_issues' => 'عرض مشاكل المشروع',
                                                                                    'view_project_milestones' => 'عرض معالم المشروع',
                                                                                    'view_project_payments' => 'عرض دفعات المشروع',
                                                                                    'view_project_phases' => 'عرض مراحل المشروع',
                                                                                    'view_project_tasks' => 'عرض مهام المشروع',
                                                                                    'view_project_team' => 'عرض فريق المشروع',
                                                                                    
                                                                                    // ترجمات المخزون والمشتريات
                                                                                    'branches' => 'الفروع',
                                                                                    'adjust_inventory_stock' => 'تعديل مخزون البضائع',
                                                                                    'apply_auto_purchase_recommendations' => 'تطبيق توصيات الشراء التلقائي',
                                                                                    'apply_seasonal_adjustments' => 'تطبيق التعديلات الموسمية',
                                                                                    'apply_smart_recommendations' => 'تطبيق التوصيات الذكية',
                                                                                    'approve_purchase_orders' => 'الموافقة على أوامر الشراء',
                                                                                    'cancel_purchase_orders' => 'إلغاء أوامر الشراء',
                                                                                    'create_auto_purchase_rule' => 'إنشاء قاعدة شراء تلقائي',
                                                                                    'create_inventory_batches' => 'إنشاء دفعات المخزون',
                                                                                    'create_inventory_categories' => 'إنشاء فئات المخزون',
                                                                                    'create_inventory_items' => 'إنشاء عناصر المخزون',
                                                                                    'create_inventory_serials' => 'إنشاء أرقام تسلسلية للمخزون',
                                                                                    'create_inventory_valuation' => 'إنشاء تقييم المخزون',
                                                                                    'create_purchase_orders' => 'إنشاء أوامر الشراء',
                                                                                    'create_recommended_rules' => 'إنشاء قواعد موصى بها',
                                                                                    'create_supplier_evaluations' => 'إنشاء تقييمات الموردين',
                                                                                    'create_suppliers' => 'إنشاء موردين',
                                                                                    'create_transaction_from_barcode' => 'إنشاء معاملة من الباركود',
                                                                                    'create_warehouses' => 'إنشاء مستودعات',
                                                                                    'delete_inventory_batches' => 'حذف دفعات المخزون',
                                                                                    'delete_inventory_categories' => 'حذف فئات المخزون',
                                                                                    'delete_inventory_items' => 'حذف عناصر المخزون',
                                                                                    'delete_inventory_serials' => 'حذف أرقام تسلسلية للمخزون',
                                                                                    'delete_inventory_valuation' => 'حذف تقييم المخزون',
                                                                                    'delete_purchase_orders' => 'حذف أوامر الشراء',
                                                                                    'delete_supplier_evaluations' => 'حذف تقييمات الموردين',
                                                                                    'delete_suppliers' => 'حذف الموردين',
                                                                                    'delete_warehouses' => 'حذف المستودعات',
                                                                                    'edit_inventory_batches' => 'تعديل دفعات المخزون',
                                                                                    'edit_inventory_categories' => 'تعديل فئات المخزون',
                                                                                    'edit_inventory_items' => 'تعديل عناصر المخزون',
                                                                                    'edit_inventory_serials' => 'تعديل أرقام تسلسلية للمخزون',
                                                                                    'edit_inventory_valuation' => 'تعديل تقييم المخزون',
                                                                                    'edit_purchase_orders' => 'تعديل أوامر الشراء',
                                                                                    'edit_supplier_evaluations' => 'تعديل تقييمات الموردين',
                                                                                    'edit_suppliers' => 'تعديل الموردين',
                                                                                    'edit_warehouses' => 'تعديل المستودعات',
                                                                                    'export_inventory_valuation' => 'تصدير تقييم المخزون',
                                                                                    'generate_inventory_barcode' => 'إنشاء باركود المخزون',
                                                                                    'print_inventory_barcode' => 'طباعة باركود المخزون',
                                                                                    'receive_purchase_orders' => 'استلام أوامر الشراء',
                                                                                    'scan_inventory_barcode' => 'مسح باركود المخزون',
                                                                                    'transfer_inventory_stock' => 'نقل مخزون البضائع',
                                                                                    'view_auto_purchase_analytics' => 'عرض تحليلات الشراء التلقائي',
                                                                                    'view_auto_purchase_forecast' => 'عرض توقعات الشراء التلقائي',
                                                                                    'view_auto_purchase_performance' => 'عرض أداء الشراء التلقائي',
                                                                                    'view_auto_purchase_recommendations' => 'عرض توصيات الشراء التلقائي',
                                                                                    'view_inventory_barcodes' => 'عرض باركود المخزون',
                                                                                    'view_inventory_batches' => 'عرض دفعات المخزون',
                                                                                    'view_inventory_categories' => 'عرض فئات المخزون',
                                                                                    'view_inventory_items' => 'عرض عناصر المخزون',
                                                                                    'view_inventory_reports' => 'عرض تقارير المخزون',
                                                                                    'view_inventory_serials' => 'عرض أرقام تسلسلية للمخزون',
                                                                                    'view_inventory_stock' => 'عرض مخزون البضائع',
                                                                                    'view_inventory_transactions' => 'عرض معاملات المخزون',
                                                                                    'view_inventory_valuation' => 'عرض تقييم المخزون',
                                                                                    'view_inventory_valuation_history' => 'عرض تاريخ تقييم المخزون',
                                                                                    'view_purchase_orders' => 'عرض أوامر الشراء',
                                                                                    'view_smart_recommendations' => 'عرض التوصيات الذكية',
                                                                                    'view_supplier_evaluations' => 'عرض تقييمات الموردين',
                                                                                    'view_suppliers' => 'عرض الموردين',
                                                                                    'view_warehouses' => 'عرض المستودعات',
                                                                                ];
                                                                                
                                                                                $permName = $permission->name;
                                                                                $permSlug = $permission->slug;
                                                                                $permGroup = $permission->group;
                                                                                
                                                                                // تحقق من وجود ترجمة مباشرة للاسم
                                                                                if (isset($directTranslations[$permName])) {
                                                                                    $translatedName = $directTranslations[$permName];
                                                                                } 
                                                                                // تحقق من وجود ترجمة مباشرة للمجموعة والاسم
                                                                                else if (isset($directTranslations[$permGroup . '.' . $permSlug])) {
                                                                                    $translatedName = $directTranslations[$permGroup . '.' . $permSlug];
                                                                                }
                                                                                // تحقق من وجود ترجمة مباشرة للاسم المختصر
                                                                                else if (isset($directTranslations[$permSlug])) {
                                                                                    $translatedName = $directTranslations[$permSlug];
                                                                                }
                                                                                else {
                                                                                    // إذا لم توجد ترجمة مباشرة، استخدم ملف الترجمة
                                                                                    if (strpos($permName, '.') !== false) {
                                                                                        $permKey = str_replace('.', '_', $permName);
                                                                                        $translatedName = __('permissions.'.$permKey);
                                                                                        if ($translatedName == 'permissions.'.$permKey) {
                                                                                            $translatedName = $permission->name;
                                                                                        }
                                                                                    } else {
                                                                                        // محاولة استخدام المجموعة والاسم المختصر
                                                                                        $groupSlugKey = $permGroup . '_' . $permSlug;
                                                                                        $translatedName = __('permissions.'.$groupSlugKey);
                                                                                        
                                                                                        if ($translatedName == 'permissions.'.$groupSlugKey) {
                                                                                            // محاولة استخدام الاسم المختصر فقط
                                                                                            $translatedName = __('permissions.'.$permSlug);
                                                                                            
                                                                                            if ($translatedName == 'permissions.'.$permSlug) {
                                                                                                // استخدام الاسم الأصلي كملاذ أخير
                                                                                                $translatedName = $permission->name;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            @endphp
                                                                            {{ $translatedName }}
                                                                            @if($permission->description)
                                                                                <i class="fas fa-info-circle text-info" data-toggle="tooltip" title="{{ $permission->description }}"></i>
                                                                            @endif
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @else
                                            <div class="alert alert-info">
                                                <i class="fas fa-info-circle ml-1"></i> لا توجد صلاحيات متاحة.
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-4 text-center">
                            <button type="submit" class="btn btn-primary px-4">
                                <i class="fas fa-save ml-1"></i> حفظ التغييرات
                            </button>
                            <a href="{{ route('roles.index') }}" class="btn btn-secondary px-4 mr-2">
                                <i class="fas fa-times ml-1"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // إزالة جميع مستمعي الأحداث السابقة
        $('.group-checkbox, .permission-checkbox').off('change');
        $('#select-all, #deselect-all').off('click');
        $('#permission-search').off('keyup');
        
        // منع التكرار
        let isProcessing = false;
        
        // وظيفة لتحديث حالة مربع اختيار المجموعة بدون تشغيل الأحداث
        function updateGroupCheckboxSilently(group) {
            if (!group) return;
            
            // استخدام معرف آمن للمجموعة
            const safeGroupId = group.replace(/[^a-zA-Z0-9]/g, '_');
            const groupCheckbox = document.getElementById(`group_${safeGroupId}`);
            
            if (groupCheckbox) {
                const totalPermissions = $(`.permission-checkbox[data-group="${group}"]`).length;
                const checkedPermissions = $(`.permission-checkbox[data-group="${group}"]:checked`).length;
                
                // تحديث حالة مربع اختيار المجموعة بدون تشغيل الحدث
                $(groupCheckbox).prop('checked', checkedPermissions === totalPermissions && totalPermissions > 0);
            }
        }
        
        // وظيفة لتحديث حالة مربعات اختيار الصلاحيات بدون تشغيل الأحداث
        function updatePermissionCheckboxesSilently(group, isChecked) {
            if (!group) return;
            
            // تحديث مربعات اختيار الصلاحيات بدون تشغيل الأحداث
            $(`.permission-checkbox[data-group="${group}"]`).prop('checked', isChecked);
        }
        
        // تحديث حالة مربعات اختيار المجموعات عند تحميل الصفحة
        $('.card.mb-3').each(function() {
            const group = $(this).data('group');
            if (group) {
                updateGroupCheckboxSilently(group);
            }
        });
        
        // معالج حدث تغيير مربع اختيار المجموعة
        $(document).on('change', '.group-checkbox', function(e) {
            if (isProcessing) {
                e.preventDefault();
                e.stopPropagation();
                return false;
            }
            
            isProcessing = true;
            
            try {
                const group = $(this).data('group');
                const isChecked = $(this).prop('checked');
                
                if (group) {
                    // تحديث مربعات اختيار الصلاحيات
                    updatePermissionCheckboxesSilently(group, isChecked);
                }
            } catch (error) {
                console.error('Error in group checkbox handler:', error);
            }
            
            // إنهاء حالة المعالجة
            setTimeout(function() {
                isProcessing = false;
            }, 100);
        });
        
        // معالج حدث تغيير مربع اختيار الصلاحية
        $(document).on('change', '.permission-checkbox', function(e) {
            if (isProcessing) {
                e.preventDefault();
                e.stopPropagation();
                return false;
            }
            
            isProcessing = true;
            
            try {
                const group = $(this).data('group');
                
                if (group) {
                    // تحديث حالة مربع اختيار المجموعة
                    updateGroupCheckboxSilently(group);
                }
            } catch (error) {
                console.error('Error in permission checkbox handler:', error);
            }
            
            // إنهاء حالة المعالجة
            setTimeout(function() {
                isProcessing = false;
            }, 100);
        });

        // تحديد الكل
        $('#select-all').on('click', function() {
            if (isProcessing) return;
            
            isProcessing = true;
            
            try {
                // تحديث جميع مربعات الاختيار بدون تشغيل الأحداث
                $('.permission-checkbox, .group-checkbox').prop('checked', true);
            } catch (error) {
                console.error('Error in select all handler:', error);
            }
            
            // إنهاء حالة المعالجة
            setTimeout(function() {
                isProcessing = false;
            }, 100);
        });

        // إلغاء تحديد الكل
        $('#deselect-all').on('click', function() {
            if (isProcessing) return;
            
            isProcessing = true;
            
            try {
                // إلغاء تحديد جميع مربعات الاختيار بدون تشغيل الأحداث
                $('.permission-checkbox, .group-checkbox').prop('checked', false);
            } catch (error) {
                console.error('Error in deselect all handler:', error);
            }
            
            // إنهاء حالة المعالجة
            setTimeout(function() {
                isProcessing = false;
            }, 100);
        });

        // وظيفة البحث في الصلاحيات
        $('#permission-search').on('keyup', function() {
            try {
                const searchTerm = $(this).val().toLowerCase();
                
                // إذا كان مصطلح البحث فارغًا، أظهر جميع المجموعات
                if (searchTerm === '') {
                    $('.card.mb-3').show();
                    $('.permission-checkbox').closest('.col-md-2').show();
                    return;
                }
                
                // أخفِ جميع المجموعات أولاً
                $('.card.mb-3').hide();
                
                // ابحث في كل صلاحية
                $('.permission-checkbox').each(function() {
                    try {
                        const permissionLabel = $(this).siblings('label').text().toLowerCase();
                        const permissionParent = $(this).closest('.card.mb-3');
                        
                        if (permissionLabel.includes(searchTerm)) {
                            // أظهر الصلاحية المطابقة
                            $(this).closest('.col-md-2').show();
                            // أظهر المجموعة الأم
                            permissionParent.show();
                        } else {
                            // أخفِ الصلاحية غير المطابقة
                            $(this).closest('.col-md-2').hide();
                        }
                    } catch (error) {
                        console.error('Error in permission search item:', error);
                    }
                });
            } catch (error) {
                console.error('Error in search handler:', error);
            }
        });

        // تفعيل التلميحات
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>
@endsection