@extends('layouts.modern')

@section('title', 'تعديل أدوار المستخدم: ' . $user->name)

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>تعديل أدوار المستخدم: {{ $user->name }}</span>
                    <a href="{{ route('roles.manage-users') }}" class="btn btn-sm btn-secondary">
                        <i class="fas fa-arrow-left"></i> العودة لقائمة المستخدمين
                    </a>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-4">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">معلومات المستخدم</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">الاسم</th>
                                            <td>{{ $user->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>البريد الإلكتروني</th>
                                            <td>{{ $user->email }}</td>
                                        </tr>
                                        <tr>
                                            <th>الشركة</th>
                                            <td>{{ $user->company ? $user->company->name : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الفرع</th>
                                            <td>{{ $user->branch ? $user->branch->name : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المسمى الوظيفي</th>
                                            <td>{{ $user->job_title ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($user->is_active)
                                                    <span class="badge badge-success">مفعل</span>
                                                @else
                                                    <span class="badge badge-danger">معطل</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">تعيين الأدوار</h5>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('roles.update-user-roles', $user) }}" method="POST">
                                        @csrf
                                        @method('PUT')

                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox mb-3">
                                                <input type="checkbox" class="custom-control-input" id="select_all">
                                                <label class="custom-control-label" for="select_all">
                                                    <strong>تحديد/إلغاء تحديد الكل</strong>
                                                </label>
                                            </div>
                                        </div>

                                        <div class="row">
                                            @foreach($roles as $role)
                                                <div class="col-md-4 mb-3">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input role-checkbox" id="role_{{ $role->id }}" name="roles[]" value="{{ $role->id }}" {{ in_array($role->id, $userRoles) ? 'checked' : '' }}>
                                                        <label class="custom-control-label" for="role_{{ $role->id }}">
                                                            {{ __('roles.' . $role->slug, ['name' => $role->name]) }}
                                                            @if($role->is_system_role)
                                                                <span class="badge badge-info">نظامي</span>
                                                            @endif
                                                        </label>
                                                        @if($role->description)
                                                            <small class="form-text text-muted">{{ Str::limit($role->description, 50) }}</small>
                                                        @endif
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>

                                        <div class="form-group mt-4">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-save"></i> حفظ التغييرات
                                            </button>
                                            <a href="{{ route('roles.manage-users') }}" class="btn btn-secondary">
                                                <i class="fas fa-times"></i> إلغاء
                                            </a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تحديد/إلغاء تحديد جميع الأدوار
        $('#select_all').on('change', function() {
            const isChecked = $(this).prop('checked');
            $('.role-checkbox').prop('checked', isChecked);
        });

        // تحديث حالة مربع اختيار "تحديد الكل" بناءً على حالة الأدوار
        $('.role-checkbox').on('change', function() {
            const totalRoles = $('.role-checkbox').length;
            const checkedRoles = $('.role-checkbox:checked').length;
            
            $('#select_all').prop('checked', checkedRoles === totalRoles);
        });

        // تحديث حالة مربع اختيار "تحديد الكل" عند تحميل الصفحة
        const totalRoles = $('.role-checkbox').length;
        const checkedRoles = $('.role-checkbox:checked').length;
        
        $('#select_all').prop('checked', checkedRoles === totalRoles && totalRoles > 0);
    });
</script>
@endsection