@extends('layouts.modern')

@section('title', 'إضافة دور جديد')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>إضافة دور جديد</span>
                    <a href="{{ route('roles.index') }}" class="btn btn-sm btn-secondary">
                        <i class="fas fa-arrow-left"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('roles.store') }}" method="POST">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h5 class="mb-0">معلومات الدور</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="name">اسم الدور <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
                                            @error('name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="slug">معرف الدور <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('slug') is-invalid @enderror" id="slug" name="slug" value="{{ old('slug') }}" required>
                                            <small class="form-text text-muted">يجب أن يكون المعرف فريداً ويتكون من أحرف إنجليزية صغيرة وأرقام وشرطات سفلية فقط.</small>
                                            @error('slug')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="description">وصف الدور</label>
                                            <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                                            @error('description')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="parent_id">الدور الأب</label>
                                            <select class="form-control @error('parent_id') is-invalid @enderror" id="parent_id" name="parent_id">
                                                <option value="">بدون أب</option>
                                                @foreach($roles as $parentRole)
                                                    <option value="{{ $parentRole->id }}" {{ old('parent_id') == $parentRole->id ? 'selected' : '' }}>
                                                        {{ $parentRole->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('parent_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="order">الترتيب</label>
                                            <input type="number" class="form-control @error('order') is-invalid @enderror" id="order" name="order" value="{{ old('order', 0) }}">
                                            @error('order')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', '1') == '1' ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="is_active">مفعل</label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="is_default" name="is_default" value="1" {{ old('is_default') == '1' ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="is_default">افتراضي للمستخدمين الجدد</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="mb-0">الصلاحيات</h5>
                                    </div>
                                    <div class="card-body">
                                        @if($permissions->count() > 0)
                                            <div class="mb-3">
                                                <input type="text" id="permission-search" class="form-control" placeholder="البحث عن صلاحيات...">
                                            </div>
                                            
                                            <div class="accordion" id="permissionsAccordion">
                                                @foreach($permissions as $group => $groupPermissions)
                                                    <div class="card mb-3 permission-group-card" data-group="{{ $group }}">
                                                        <div class="card-header bg-light" id="heading{{ Str::slug($group) }}">
                                                            <div class="d-flex justify-content-between align-items-center">
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input group-checkbox" id="group_{{ str_replace(' ', '_', $group) }}" data-group="{{ $group }}">
                                                                    <label class="custom-control-label" for="group_{{ str_replace(' ', '_', $group) }}">
                                                                        <strong>{{ $group ?: 'عام' }}</strong>
                                                                    </label>
                                                                </div>
                                                                <button class="btn btn-link btn-sm collapsed" type="button" data-toggle="collapse" data-target="#collapse{{ Str::slug($group) }}" aria-expanded="false" aria-controls="collapse{{ Str::slug($group) }}">
                                                                    <i class="fas fa-chevron-down"></i>
                                                                </button>
                                                            </div>
                                                        </div>
                                                        <div id="collapse{{ Str::slug($group) }}" class="collapse" aria-labelledby="heading{{ Str::slug($group) }}" data-parent="#permissionsAccordion">
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    @foreach($groupPermissions as $permission)
                                                                        <div class="col-md-6 permission-item" data-name="{{ $permission->name }}" data-slug="{{ $permission->slug }}">
                                                                            <div class="custom-control custom-checkbox mb-2">
                                                                                <input type="checkbox" class="custom-control-input permission-checkbox" id="permission_{{ $permission->id }}" name="permissions[]" value="{{ $permission->id }}" data-group="{{ $group }}" {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}>
                                                                                <label class="custom-control-label" for="permission_{{ $permission->id }}">
                                                                                    {{ $permission->name }}
                                                                                    @if($permission->description)
                                                                                        <i class="fas fa-info-circle" data-toggle="tooltip" title="{{ $permission->description }}"></i>
                                                                                    @endif
                                                                                </label>
                                                                            </div>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="alert alert-info">
                                                لا توجد صلاحيات متاحة.
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ
                            </button>
                            <a href="{{ route('roles.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // توليد المعرف تلقائياً من الاسم
        $('#name').on('input', function() {
            if (!$('#slug').data('manually-changed')) {
                const name = $(this).val();
                const slug = name.toLowerCase()
                    .replace(/\s+/g, '_')
                    .replace(/[^\w\s]/gi, '')
                    .replace(/_+/g, '_');
                $('#slug').val(slug);
            }
        });

        $('#slug').on('input', function() {
            $(this).data('manually-changed', true);
        });

        // إزالة جميع مستمعي الأحداث السابقة
        $('.group-checkbox, .permission-checkbox').off('change');
        
        // منع التكرار
        let isProcessing = false;
        
        // وظيفة لتحديث حالة مربع اختيار المجموعة بدون تشغيل الأحداث
        function updateGroupCheckboxSilently(group) {
            if (!group) return;
            
            // استخدام معرف آمن للمجموعة
            const safeGroupId = group.replace(/[^a-z0-9]/gi, '_');
            const groupCheckbox = document.getElementById(`group_${safeGroupId}`);
            
            if (groupCheckbox) {
                const totalPermissions = $(`.permission-checkbox[data-group="${group}"]`).length;
                const checkedPermissions = $(`.permission-checkbox[data-group="${group}"]:checked`).length;
                
                // تحديث حالة مربع اختيار المجموعة بدون تشغيل الحدث
                $(groupCheckbox).prop('checked', checkedPermissions === totalPermissions && totalPermissions > 0);
            }
        }
        
        // وظيفة لتحديث حالة مربعات اختيار الصلاحيات بدون تشغيل الأحداث
        function updatePermissionCheckboxesSilently(group, isChecked) {
            if (!group) return;
            
            // تحديث مربعات اختيار الصلاحيات بدون تشغيل الأحداث
            $(`.permission-checkbox[data-group="${group}"]`).prop('checked', isChecked);
        }
        
        // تحديث حالة مربعات اختيار المجموعات عند تحميل الصفحة
        $('.permission-group-card').each(function() {
            const group = $(this).data('group');
            if (group) {
                updateGroupCheckboxSilently(group);
            }
        });
        
        // معالج حدث تغيير مربع اختيار المجموعة
        $(document).on('change', '.group-checkbox', function(e) {
            if (isProcessing) {
                e.preventDefault();
                e.stopPropagation();
                return false;
            }
            
            isProcessing = true;
            
            try {
                const group = $(this).data('group');
                const isChecked = $(this).prop('checked');
                
                if (group) {
                    // تحديث مربعات اختيار الصلاحيات
                    updatePermissionCheckboxesSilently(group, isChecked);
                }
            } catch (error) {
                console.error('Error in group checkbox handler:', error);
            }
            
            // إنهاء حالة المعالجة
            setTimeout(function() {
                isProcessing = false;
            }, 100);
        });
        
        // معالج حدث تغيير مربع اختيار الصلاحية
        $(document).on('change', '.permission-checkbox', function(e) {
            if (isProcessing) {
                e.preventDefault();
                e.stopPropagation();
                return false;
            }
            
            isProcessing = true;
            
            try {
                const group = $(this).data('group');
                
                if (group) {
                    // تحديث حالة مربع اختيار المجموعة
                    updateGroupCheckboxSilently(group);
                }
            } catch (error) {
                console.error('Error in permission checkbox handler:', error);
            }
            
            // إنهاء حالة المعالجة
            setTimeout(function() {
                isProcessing = false;
            }, 100);
        });

        // البحث في الصلاحيات
        $('#permission-search').on('input', function() {
            const searchTerm = $(this).val().toLowerCase();
            
            if (searchTerm.length > 0) {
                // إظهار جميع المجموعات التي تحتوي على الصلاحيات المطابقة
                $('.permission-group-card').each(function() {
                    const group = $(this);
                    let hasMatch = false;
                    
                    group.find('.permission-item').each(function() {
                        try {
                            const permissionName = $(this).data('name') ? $(this).data('name').toString().toLowerCase() : '';
                            const permissionSlug = $(this).data('slug') ? $(this).data('slug').toString().toLowerCase() : '';
                            
                            if (permissionName.includes(searchTerm) || permissionSlug.includes(searchTerm)) {
                                $(this).show();
                                hasMatch = true;
                                
                                // فتح المجموعة إذا كانت مغلقة
                                const collapseId = group.find('.collapse').attr('id');
                                if (collapseId && !$('#' + collapseId).hasClass('show')) {
                                    // استخدام bootstrap collapse API بدلاً من click
                                    $('#' + collapseId).collapse('show');
                                }
                            } else {
                                $(this).hide();
                            }
                        } catch (error) {
                            console.error('Error in search handler:', error);
                        }
                    });
                    
                    if (hasMatch) {
                        group.show();
                    } else {
                        group.hide();
                    }
                });
            } else {
                // إعادة عرض جميع الصلاحيات والمجموعات
                $('.permission-group-card').show();
                $('.permission-item').show();
                
                // إغلاق جميع المجموعات
                $('.collapse.show').collapse('hide');
            }
        });

        // فتح المجموعة عند النقر على العنوان
        $('.card-header').on('click', function(e) {
            if (!$(e.target).is('input') && !$(e.target).is('label')) {
                // استخدام bootstrap collapse API بدلاً من click
                const collapseId = $(this).find('[data-toggle="collapse"]').attr('data-target');
                if (collapseId) {
                    $(collapseId).collapse('toggle');
                }
            }
        });

        // تفعيل tooltips
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>
@endsection