@extends('layouts.modern')

@section('title', 'تفاصيل الصلاحية: ' . $permission->name)

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>تفاصيل الصلاحية: {{ $permission->name }}</span>
                    <div>
                        <a href="{{ route('permissions.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للقائمة
                        </a>
                        <a href="{{ route('permissions.edit', $permission) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">معلومات الصلاحية</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">الاسم</th>
                                            <td>{{ $permission->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>المعرف</th>
                                            <td>{{ $permission->slug }}</td>
                                        </tr>
                                        <tr>
                                            <th>الوصف</th>
                                            <td>{{ $permission->description ?: 'لا يوجد وصف' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المجموعة</th>
                                            <td>{{ $permission->group ?: 'غير مصنفة' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الصلاحية الأب</th>
                                            <td>{{ $permission->parent ? $permission->parent->name : 'لا يوجد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>النوع</th>
                                            <td>{{ $permission->type ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المورد</th>
                                            <td>{{ $permission->resource ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الترتيب</th>
                                            <td>{{ $permission->order }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($permission->is_active)
                                                    <span class="badge badge-success">مفعلة</span>
                                                @else
                                                    <span class="badge badge-danger">معطلة</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $permission->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $permission->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            @if($permission->children->count() > 0)
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">الصلاحيات الفرعية</h5>
                                </div>
                                <div class="card-body">
                                    <ul class="list-group">
                                        @foreach($permission->children as $child)
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <div>
                                                    <a href="{{ route('permissions.show', $child) }}">{{ $child->name }}</a>
                                                </div>
                                                <div>
                                                    <span class="badge badge-primary badge-pill">{{ $child->roles()->count() }} دور</span>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            @endif
                        </div>

                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">الأدوار ({{ $roles->total() }})</h5>
                                </div>
                                <div class="card-body">
                                    @if($roles->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>الاسم</th>
                                                        <th>المعرف</th>
                                                        <th>الوصف</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($roles as $role)
                                                        <tr>
                                                            <td>
                                                                <a href="{{ route('roles.show', $role) }}">{{ $role->name }}</a>
                                                                @if($role->is_system_role)
                                                                    <span class="badge badge-info">نظامي</span>
                                                                @endif
                                                            </td>
                                                            <td>{{ $role->slug }}</td>
                                                            <td>{{ Str::limit($role->description, 50) }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="mt-3">
                                            {{ $roles->links() }}
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد أدوار مرتبطة بهذه الصلاحية.
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">المستخدمون المباشرون ({{ $directUsers->total() }})</h5>
                                </div>
                                <div class="card-body">
                                    @if($directUsers->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>الاسم</th>
                                                        <th>البريد الإلكتروني</th>
                                                        <th>الحالة</th>
                                                        <th>تاريخ الانتهاء</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($directUsers as $user)
                                                        <tr>
                                                            <td>
                                                                <a href="{{ route('users.show', $user) }}">{{ $user->name }}</a>
                                                            </td>
                                                            <td>{{ $user->email }}</td>
                                                            <td>
                                                                @php
                                                                    $directPermission = $user->directPermissions()
                                                                        ->where('permission_id', $permission->id)
                                                                        ->first();
                                                                @endphp
                                                                
                                                                @if($directPermission && $directPermission->granted)
                                                                    <span class="badge badge-success">ممنوحة</span>
                                                                @else
                                                                    <span class="badge badge-danger">ممنوعة</span>
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if($directPermission && $directPermission->expires_at)
                                                                    {{ \Carbon\Carbon::parse($directPermission->expires_at)->format('Y-m-d') }}
                                                                @else
                                                                    <span class="text-muted">غير محدد</span>
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="mt-3">
                                            {{ $directUsers->links() }}
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا يوجد مستخدمون مرتبطون مباشرة بهذه الصلاحية.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection