@foreach($children as $child)
    <tr>
        <td>
            <div style="padding-right: {{ $level * 20 }}px;">
                <i class="fas fa-level-down-alt fa-rotate-90 mr-2"></i>
                {{ $child->name }}
            </div>
        </td>
        <td>{{ $child->slug }}</td>
        <td>{{ $child->group ?: 'غير مصنف' }}</td>
        <td>{{ Str::limit($child->description, 50) }}</td>
        <td>{{ $child->type ?: 'عام' }}</td>
        <td>
            @if($child->is_active)
                <span class="badge badge-success">مفعل</span>
            @else
                <span class="badge badge-danger">معطل</span>
            @endif
        </td>
        <td>
            <div class="btn-group btn-group-sm">
                <a href="{{ route('permissions.show', $child) }}" class="btn btn-info">
                    <i class="fas fa-eye"></i>
                </a>
                <a href="{{ route('permissions.edit', $child) }}" class="btn btn-primary">
                    <i class="fas fa-edit"></i>
                </a>
                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal{{ $child->id }}">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
            
            <!-- Modal -->
            <div class="modal fade" id="deleteModal{{ $child->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $child->id }}" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteModalLabel{{ $child->id }}">تأكيد الحذف</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            هل أنت متأكد من حذف الصلاحية <strong>{{ $child->name }}</strong>؟
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                            <form action="{{ route('permissions.destroy', $child) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">حذف</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </td>
    </tr>
    
    @if($child->children->count() > 0)
        @include('admin.permissions.partials.child-permissions', ['children' => $child->children, 'level' => $level + 1])
    @endif
@endforeach