@extends('layouts.modern')

@section('title', 'إدارة صلاحيات المستخدمين')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>إدارة صلاحيات المستخدمين</span>
                    <a href="{{ route('dashboard') }}" class="btn btn-sm btn-secondary">
                        <i class="fas fa-arrow-left"></i> العودة للوحة التحكم
                    </a>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="mb-3">
                        <form action="{{ route('temp.permissions.manage-users') }}" method="GET" class="row g-3">
                            <div class="col-md-4">
                                <div class="input-group">
                                    <input type="text" class="form-control" name="search" placeholder="بحث بالاسم أو البريد الإلكتروني" value="{{ request('search') }}">
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="submit">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>الاسم</th>
                                    <th>البريد الإلكتروني</th>
                                    <th>الشركة</th>
                                    <th>الفرع</th>
                                    <th>الأدوار</th>
                                    <th>الصلاحيات المباشرة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($users as $user)
                                    <tr>
                                        <td>{{ $user->name }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td>{{ $user->company ? $user->company->name : 'غير محدد' }}</td>
                                        <td>{{ $user->branch ? $user->branch->name : 'غير محدد' }}</td>
                                        <td>
                                            @foreach($user->roles as $role)
                                                <span class="badge badge-info">{{ $role->name }}</span>
                                            @endforeach
                                        </td>
                                        <td>
                                            @php
                                                $directPermissionsCount = $user->directPermissions()->count();
                                            @endphp
                                            
                                            @if($directPermissionsCount > 0)
                                                <span class="badge badge-primary">{{ $directPermissionsCount }} صلاحية</span>
                                            @else
                                                <span class="badge badge-secondary">لا يوجد</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('temp.permissions.edit-user-permissions', $user) }}" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i> تعديل الصلاحيات
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $users->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection