@extends('layouts.modern')

@section('title', 'إدارة الصلاحيات')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>إدارة الصلاحيات</span>
                    <div>
                        <a href="{{ route('permissions.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> إضافة صلاحية جديدة
                        </a>
                        <a href="{{ route('permissions.generate-from-controllers') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-sync"></i> إنشاء من وحدات التحكم
                        </a>
                        <a href="{{ route('permissions.manage-users') }}" class="btn btn-sm btn-info">
                            <i class="fas fa-users"></i> إدارة صلاحيات المستخدمين
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>الاسم</th>
                                    <th>المعرف</th>
                                    <th>المجموعة</th>
                                    <th>الوصف</th>
                                    <th>النوع</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($permissions as $permission)
                                    <tr>
                                        <td>
                                            <strong>{{ $permission->name }}</strong>
                                        </td>
                                        <td>{{ $permission->slug }}</td>
                                        <td>{{ $permission->group ?: 'غير مصنف' }}</td>
                                        <td>{{ Str::limit($permission->description, 50) }}</td>
                                        <td>{{ $permission->type ?: 'عام' }}</td>
                                        <td>
                                            @if($permission->is_active)
                                                <span class="badge badge-success">مفعل</span>
                                            @else
                                                <span class="badge badge-danger">معطل</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('permissions.show', $permission) }}" class="btn btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('permissions.edit', $permission) }}" class="btn btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal{{ $permission->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                            
                                            <!-- Modal -->
                                            <div class="modal fade" id="deleteModal{{ $permission->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $permission->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $permission->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف الصلاحية <strong>{{ $permission->name }}</strong>؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('permissions.destroy', $permission) }}" method="POST" class="d-inline">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    
                                    @if($permission->children->count() > 0)
                                        @include('admin.permissions.partials.child-permissions', ['children' => $permission->children, 'level' => 1])
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection