@extends('layouts.modern')

@section('title', 'تعديل الصلاحية')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>تعديل الصلاحية: {{ $permission->name }}</span>
                    <a href="{{ route('permissions.index') }}" class="btn btn-sm btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form method="POST" action="{{ route('permissions.update', $permission) }}">
                        @csrf
                        @method('PUT')

                        <div class="form-group row">
                            <label for="name" class="col-md-3 col-form-label text-md-right">الاسم</label>
                            <div class="col-md-9">
                                <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name', $permission->name) }}" required autofocus>
                                @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="slug" class="col-md-3 col-form-label text-md-right">المعرف</label>
                            <div class="col-md-9">
                                <input id="slug" type="text" class="form-control @error('slug') is-invalid @enderror" name="slug" value="{{ old('slug', $permission->slug) }}" required>
                                <small class="form-text text-muted">المعرف يجب أن يكون فريداً ويتكون من أحرف إنجليزية صغيرة وأرقام وشرطات سفلية فقط.</small>
                                @error('slug')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="description" class="col-md-3 col-form-label text-md-right">الوصف</label>
                            <div class="col-md-9">
                                <textarea id="description" class="form-control @error('description') is-invalid @enderror" name="description" rows="3">{{ old('description', $permission->description) }}</textarea>
                                @error('description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="group" class="col-md-3 col-form-label text-md-right">المجموعة</label>
                            <div class="col-md-9">
                                <input id="group" type="text" class="form-control @error('group') is-invalid @enderror" name="group" value="{{ old('group', $permission->group) }}">
                                <small class="form-text text-muted">المجموعة تساعد في تنظيم الصلاحيات (مثال: المستخدمين، المنتجات، إلخ).</small>
                                @error('group')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="parent_id" class="col-md-3 col-form-label text-md-right">الصلاحية الأب</label>
                            <div class="col-md-9">
                                <select id="parent_id" class="form-control @error('parent_id') is-invalid @enderror" name="parent_id">
                                    <option value="">بدون أب</option>
                                    @foreach($permissions as $parent)
                                        <option value="{{ $parent->id }}" {{ old('parent_id', $permission->parent_id) == $parent->id ? 'selected' : '' }}>
                                            {{ $parent->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('parent_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="type" class="col-md-3 col-form-label text-md-right">النوع</label>
                            <div class="col-md-9">
                                <select id="type" class="form-control @error('type') is-invalid @enderror" name="type">
                                    <option value="">عام</option>
                                    <option value="crud" {{ old('type', $permission->type) == 'crud' ? 'selected' : '' }}>CRUD</option>
                                    <option value="action" {{ old('type', $permission->type) == 'action' ? 'selected' : '' }}>إجراء</option>
                                    <option value="view" {{ old('type', $permission->type) == 'view' ? 'selected' : '' }}>عرض</option>
                                    <option value="system" {{ old('type', $permission->type) == 'system' ? 'selected' : '' }}>نظام</option>
                                </select>
                                @error('type')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="resource" class="col-md-3 col-form-label text-md-right">المورد</label>
                            <div class="col-md-9">
                                <input id="resource" type="text" class="form-control @error('resource') is-invalid @enderror" name="resource" value="{{ old('resource', $permission->resource) }}">
                                <small class="form-text text-muted">المورد الذي تتعلق به الصلاحية (مثال: users، products، إلخ).</small>
                                @error('resource')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="order" class="col-md-3 col-form-label text-md-right">الترتيب</label>
                            <div class="col-md-9">
                                <input id="order" type="number" class="form-control @error('order') is-invalid @enderror" name="order" value="{{ old('order', $permission->order) }}">
                                @error('order')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-3 col-form-label text-md-right">الحالة</div>
                            <div class="col-md-9">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', $permission->is_active) ? 'checked' : '' }}>
                                    <label class="custom-control-label" for="is_active">مفعل</label>
                                </div>
                                @error('is_active')
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                            <div class="col-md-9 offset-md-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ التغييرات
                                </button>
                                <a href="{{ route('permissions.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection