@extends('layouts.modern')

@section('title', 'تعديل صلاحيات المستخدم: ' . $user->name)

@section('styles')
<link rel="stylesheet" href="{{ asset('css/permissions.css') }}">
<style>
    /* تحسين عرض مربعات الاختيار */
    .form-check-input {
        width: 1.2em;
        height: 1.2em;
        margin-left: 0.5em;
    }
    .form-check-label {
        margin-right: 1.8em;
        font-weight: normal;
    }
    /* تحسين عرض التبويبات */
    .nav-tabs .nav-link {
        padding: 0.5rem 1rem;
        font-weight: 600;
    }
    .nav-tabs .nav-link.active {
        background-color: #f8f9fa;
        border-bottom-color: #f8f9fa;
    }
    .tab-content {
        border: 1px solid #dee2e6;
        border-top: none;
        padding: 1rem;
        background-color: #f8f9fa;
    }
    /* تحسين عرض الجداول */
    .permissions-table th {
        background-color: #f0f0f0;
    }
    .permissions-table td {
        vertical-align: middle;
    }
    /* تحسين عرض البطاقات */
    .user-info-card {
        margin-bottom: 1rem;
    }
    .user-info-card .table {
        margin-bottom: 0;
    }
    /* تحسين عرض الأزرار */
    .action-buttons {
        position: sticky;
        bottom: 0;
        background-color: #fff;
        padding: 1rem 0;
        border-top: 1px solid #dee2e6;
        z-index: 100;
    }
    /* تنسيق القوائم المنسدلة */
    .permission-select {
        -webkit-appearance: menulist !important;
        -moz-appearance: menulist !important;
        appearance: menulist !important;
        opacity: 1 !important;
        visibility: visible !important;
    }
    .permission-select option {
        opacity: 1 !important;
        visibility: visible !important;
    }
    .permission-granted {
        background-color: #d4edda !important;
    }
    .permission-denied {
        background-color: #f8d7da !important;
    }
    .permission-default {
        background-color: #e9ecef !important;
    }
    .permission-inherited {
        background-color: #cce5ff !important;
    }
    /* أزرار تحديد الكل */
    .bulk-actions {
        margin-bottom: 15px;
        padding: 10px;
        background-color: #f8f9fa;
        border-radius: 5px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>تعديل صلاحيات المستخدم: {{ $user->name }}</span>
                    <a href="{{ route('temp.permissions.manage-users') }}" class="btn btn-sm btn-secondary">
                        <i class="fas fa-arrow-left"></i> العودة لقائمة المستخدمين
                    </a>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-4">
                            <!-- معلومات المستخدم -->
                            <div class="card user-info-card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات المستخدم</h5>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-bordered table-striped mb-0">
                                        <tr>
                                            <th style="width: 40%">الاسم</th>
                                            <td>{{ $user->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>البريد الإلكتروني</th>
                                            <td>{{ $user->email }}</td>
                                        </tr>
                                        <tr>
                                            <th>الشركة</th>
                                            <td>{{ $user->company ? $user->company->name : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الفرع</th>
                                            <td>{{ $user->branch ? $user->branch->name : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المسمى الوظيفي</th>
                                            <td>{{ $user->job_title ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($user->is_active)
                                                    <span class="badge bg-success">مفعل</span>
                                                @else
                                                    <span class="badge bg-danger">معطل</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <!-- الأدوار -->
                            <div class="card user-info-card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">الأدوار</h5>
                                </div>
                                <div class="card-body">
                                    @if($user->roles->count() > 0)
                                        <ul class="list-group">
                                            @foreach($user->roles as $role)
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    {{ $role->name }}
                                                    <a href="{{ route('roles.edit-user-roles', $user) }}" class="btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد أدوار مخصصة لهذا المستخدم.
                                        </div>
                                    @endif
                                </div>
                            </div>
                            
                            <!-- ملاحظة توضيحية -->
                            <div class="alert alert-info mt-3">
                                <i class="fas fa-info-circle"></i> الصلاحيات المظللة باللون الرمادي هي صلاحيات مكتسبة من الأدوار ولا يمكن تعديلها هنا.
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">تعيين الصلاحيات المباشرة</h5>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('temp.permissions.update-user-permissions', $user) }}" method="POST">
                                        @csrf
                                        @method('PUT')

                                        @if($permissions->count() > 0)
                                            <!-- تبويبات المجموعات -->
                                            <ul class="nav nav-tabs" id="permissionTabs" role="tablist">
                                                @foreach($permissions as $group => $groupPermissions)
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link {{ $loop->first ? 'active' : '' }}" 
                                                                id="tab-{{ Str::slug($group ?: 'general') }}" 
                                                                data-bs-toggle="tab" 
                                                                data-bs-target="#content-{{ Str::slug($group ?: 'general') }}" 
                                                                type="button" 
                                                                role="tab" 
                                                                aria-controls="content-{{ Str::slug($group ?: 'general') }}" 
                                                                aria-selected="{{ $loop->first ? 'true' : 'false' }}">
                                                            {{ $group ?: 'عام' }}
                                                        </button>
                                                    </li>
                                                @endforeach
                                            </ul>
                                            
                                            <!-- محتوى التبويبات -->
                                            <div class="tab-content" id="permissionTabsContent">
                                                @foreach($permissions as $group => $groupPermissions)
                                                    <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}" 
                                                         id="content-{{ Str::slug($group ?: 'general') }}" 
                                                         role="tabpanel" 
                                                         aria-labelledby="tab-{{ Str::slug($group ?: 'general') }}">
                                                        
                                                        <!-- أزرار تحديد الكل -->
                                                        <div class="bulk-actions">
                                                            <div class="btn-group" role="group">
                                                                <button type="button" class="btn btn-sm btn-success grant-all" data-group="{{ Str::slug($group ?: 'general') }}">
                                                                    <i class="fas fa-check-circle"></i> منح الكل
                                                                </button>
                                                                <button type="button" class="btn btn-sm btn-danger deny-all" data-group="{{ Str::slug($group ?: 'general') }}">
                                                                    <i class="fas fa-times-circle"></i> منع الكل
                                                                </button>
                                                                <button type="button" class="btn btn-sm btn-secondary reset-all" data-group="{{ Str::slug($group ?: 'general') }}">
                                                                    <i class="fas fa-undo"></i> إعادة للافتراضي
                                                                </button>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="table-responsive">
                                                            <table class="table table-bordered table-hover permissions-table">
                                                                <thead>
                                                                    <tr>
                                                                        <th>الصلاحية</th>
                                                                        <th style="width: 120px">الحالة</th>
                                                                        <th style="width: 180px">تاريخ الانتهاء</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    @foreach($groupPermissions as $permission)
                                                                        @php
                                                                            $isInherited = in_array($permission->id, $rolePermissions);
                                                                            $directPermission = $userPermissions[$permission->id] ?? null;
                                                                        @endphp
                                                                        <tr class="{{ $isInherited ? 'table-secondary' : '' }}">
                                                                            <td>
                                                                                <div class="d-flex align-items-center">
                                                                                    <span>{{ $permission->name }}</span>
                                                                                    @if($permission->description)
                                                                                        <i class="fas fa-info-circle ms-2" data-bs-toggle="tooltip" title="{{ $permission->description }}"></i>
                                                                                    @endif
                                                                                    @if($isInherited)
                                                                                        <span class="badge bg-info ms-2">من الأدوار</span>
                                                                                    @endif
                                                                                </div>
                                                                            </td>
                                                                            <td>
                                                                                <input type="hidden" name="permissions[{{ $permission->id }}][id]" value="{{ $permission->id }}">
                                                                                <select name="permissions[{{ $permission->id }}][granted]" class="form-select form-select-sm permission-select" data-permission-id="{{ $permission->id }}" {{ $isInherited ? 'disabled' : '' }}>
                                                                                    <option value="1" {{ isset($directPermission) && $directPermission->granted == 1 ? 'selected' : '' }}>ممنوحة</option>
                                                                                    <option value="0" {{ isset($directPermission) && $directPermission->granted == 0 ? 'selected' : '' }}>ممنوعة</option>
                                                                                    <option value="" {{ !isset($directPermission) ? 'selected' : '' }}>{{ $isInherited ? 'ممنوحة (من الأدوار)' : 'افتراضي' }}</option>
                                                                                </select>
                                                                            </td>
                                                                            <td>
                                                                                <input type="date" name="permissions[{{ $permission->id }}][expires_at]" class="form-control form-control-sm" value="{{ isset($directPermission) && $directPermission->expires_at ? \Carbon\Carbon::parse($directPermission->expires_at)->format('Y-m-d') : '' }}" {{ $isInherited ? 'disabled' : '' }}>
                                                                            </td>
                                                                        </tr>
                                                                    @endforeach
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="alert alert-warning">
                                                لا توجد صلاحيات متاحة في النظام.
                                            </div>
                                        @endif

                                        <div class="action-buttons text-center mt-4">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-save"></i> حفظ التغييرات
                                            </button>
                                            <a href="{{ route('temp.permissions.manage-users') }}" class="btn btn-secondary">
                                                <i class="fas fa-times"></i> إلغاء
                                            </a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تفعيل tooltips
        $('[data-bs-toggle="tooltip"]').tooltip();
        
        // حفظ التبويب النشط عند إعادة تحميل الصفحة
        $('button[data-bs-toggle="tab"]').on('shown.bs.tab', function (e) {
            localStorage.setItem('activePermissionTab', $(e.target).attr('id'));
        });
        
        // استعادة التبويب النشط
        var activeTab = localStorage.getItem('activePermissionTab');
        if (activeTab) {
            $('#' + activeTab).tab('show');
        }
        
        // تغيير لون الخلفية عند تغيير القيمة
        $('select[name^="permissions"]').on('change', function() {
            var value = $(this).val();
            if (value === '1') {
                $(this).removeClass('permission-denied permission-default permission-inherited').addClass('permission-granted');
            } else if (value === '0') {
                $(this).removeClass('permission-granted permission-default permission-inherited').addClass('permission-denied');
            } else {
                var isInherited = $(this).find('option:selected').text().includes('من الأدوار');
                $(this).removeClass('permission-granted permission-denied');
                if (isInherited) {
                    $(this).removeClass('permission-default').addClass('permission-inherited');
                } else {
                    $(this).removeClass('permission-inherited').addClass('permission-default');
                }
            }
        });
        
        // تطبيق الألوان عند تحميل الصفحة
        $('select[name^="permissions"]').each(function() {
            var value = $(this).val();
            if (value === '1') {
                $(this).removeClass('permission-denied permission-default permission-inherited').addClass('permission-granted');
            } else if (value === '0') {
                $(this).removeClass('permission-granted permission-default permission-inherited').addClass('permission-denied');
            } else {
                var isInherited = $(this).find('option:selected').text().includes('من الأدوار');
                $(this).removeClass('permission-granted permission-denied');
                if (isInherited) {
                    $(this).removeClass('permission-default').addClass('permission-inherited');
                } else {
                    $(this).removeClass('permission-inherited').addClass('permission-default');
                }
            }
        });
        
        // إضافة زر لتحديد كل الصلاحيات في التبويب الحالي
        $('.tab-pane').each(function() {
            var tabId = $(this).attr('id');
            var actionButtons = $('<div class="d-flex justify-content-end mb-3"></div>');
            
            var grantAllBtn = $('<button type="button" class="btn btn-sm btn-success ms-2">منح الكل</button>');
            var denyAllBtn = $('<button type="button" class="btn btn-sm btn-danger ms-2">منع الكل</button>');
            var defaultAllBtn = $('<button type="button" class="btn btn-sm btn-secondary">إعادة للافتراضي</button>');
            
            grantAllBtn.on('click', function() {
                $('#' + tabId + ' select[name^="permissions"]:not(:disabled)').val('1').trigger('change');
            });
            
            denyAllBtn.on('click', function() {
                $('#' + tabId + ' select[name^="permissions"]:not(:disabled)').val('0').trigger('change');
            });
            
            defaultAllBtn.on('click', function() {
                $('#' + tabId + ' select[name^="permissions"]:not(:disabled)').val('').trigger('change');
            });
            
            actionButtons.append(grantAllBtn).append(denyAllBtn).append(defaultAllBtn);
            $(this).prepend(actionButtons);
        });
        
        // تأكد من حفظ القيم المحددة عند إرسال النموذج
        $('form').on('submit', function() {
            // تأكد من أن جميع القوائم المنسدلة تحتفظ بقيمها المحددة
            $('select[name^="permissions"]').each(function() {
                var selectedValue = $(this).val();
                $(this).find('option[value="' + selectedValue + '"]').prop('selected', true);
            });
        });
    });
</script>
@endsection