@extends('layouts.modern')

@section('title', 'سجل تسجيل الدخول')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>سجل تسجيل الدخول</span>
                    <div>
                        @can('export_login_history')
                        <a href="{{ route('login-history.export') }}" class="btn btn-sm btn-success">
                            <i class="fas fa-file-export"></i> تصدير
                        </a>
                        @endcan
                        
                        @can('delete_login_history')
                        <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteOldModal">
                            <i class="fas fa-trash"></i> حذف السجلات القديمة
                        </button>
                        @endcan
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- فلاتر البحث -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <i class="fas fa-filter"></i> فلاتر البحث
                        </div>
                        <div class="card-body">
                            <form action="{{ route('login-history.index') }}" method="GET">
                                <div class="row">
                                    <div class="col-md-3 mb-3">
                                        <label for="user_id">المستخدم</label>
                                        <select name="user_id" id="user_id" class="form-control">
                                            <option value="">الكل</option>
                                            @foreach($users as $user)
                                                <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>
                                                    {{ $user->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="status">الحالة</label>
                                        <select name="status" id="status" class="form-control">
                                            <option value="">الكل</option>
                                            @foreach($statuses as $status)
                                                <option value="{{ $status }}" {{ request('status') == $status ? 'selected' : '' }}>
                                                    {{ $status }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="login_type">نوع تسجيل الدخول</label>
                                        <select name="login_type" id="login_type" class="form-control">
                                            <option value="">الكل</option>
                                            @foreach($loginTypes as $type)
                                                <option value="{{ $type }}" {{ request('login_type') == $type ? 'selected' : '' }}>
                                                    {{ $type }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="ip_address">عنوان IP</label>
                                        <input type="text" name="ip_address" id="ip_address" class="form-control" value="{{ request('ip_address') }}">
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="date_from">من تاريخ</label>
                                        <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="date_to">إلى تاريخ</label>
                                        <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                    </div>
                                    
                                    <div class="col-md-6 mb-3 d-flex align-items-end">
                                        <button type="submit" class="btn btn-primary me-2">
                                            <i class="fas fa-search"></i> بحث
                                        </button>
                                        <a href="{{ route('login-history.index') }}" class="btn btn-secondary">
                                            <i class="fas fa-redo"></i> إعادة تعيين
                                        </a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>المستخدم</th>
                                    <th>الحالة</th>
                                    <th>نوع تسجيل الدخول</th>
                                    <th>عنوان IP</th>
                                    <th>المتصفح</th>
                                    <th>نظام التشغيل</th>
                                    <th>الجهاز</th>
                                    <th>التاريخ</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($loginHistory as $login)
                                    <tr>
                                        <td>{{ $login->id }}</td>
                                        <td>
                                            @if($login->user)
                                                <a href="{{ route('users.show', $login->user) }}">{{ $login->user->name }}</a>
                                            @else
                                                <span class="text-muted">غير مسجل</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($login->status == 'success')
                                                <span class="badge bg-success">نجاح</span>
                                            @elseif($login->status == 'failed')
                                                <span class="badge bg-danger">فشل</span>
                                            @elseif($login->status == 'logout')
                                                <span class="badge bg-info">تسجيل خروج</span>
                                            @else
                                                <span class="badge bg-secondary">{{ $login->status }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $login->login_type }}</td>
                                        <td>{{ $login->ip_address }}</td>
                                        <td>{{ Str::limit($login->browser, 20) }}</td>
                                        <td>{{ Str::limit($login->operating_system, 20) }}</td>
                                        <td>{{ $login->device }}</td>
                                        <td>{{ $login->login_at->format('Y-m-d H:i:s') }}</td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('login-history.show', $login) }}" class="btn btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @can('delete_login_history')
                                                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal{{ $login->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                @endcan
                                            </div>
                                            
                                            <!-- Modal -->
                                            <div class="modal fade" id="deleteModal{{ $login->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $login->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $login->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف هذا السجل؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('login-history.destroy', $login) }}" method="POST" class="d-inline">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">لا توجد سجلات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $loginHistory->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal حذف السجلات القديمة -->
<div class="modal fade" id="deleteOldModal" tabindex="-1" role="dialog" aria-labelledby="deleteOldModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteOldModalLabel">حذف السجلات القديمة</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('login-history.delete-old') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="days">حذف السجلات الأقدم من</label>
                        <div class="input-group">
                            <input type="number" name="days" id="days" class="form-control" min="1" value="30" required>
                            <div class="input-group-append">
                                <span class="input-group-text">يوم</span>
                            </div>
                        </div>
                        <small class="form-text text-muted">سيتم حذف جميع السجلات التي مر عليها أكثر من العدد المحدد من الأيام.</small>
                    </div>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> تحذير: لا يمكن استعادة السجلات بعد حذفها.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">حذف</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection