@extends('layouts.modern')

@section('title', 'سجل النشاطات')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>سجل النشاطات</span>
                    <div>
                        @can('export_activity_logs')
                        <a href="{{ route('activity-logs.export') }}" class="btn btn-sm btn-success">
                            <i class="fas fa-file-export"></i> تصدير
                        </a>
                        @endcan
                        
                        @can('delete_activity_logs')
                        <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteOldModal">
                            <i class="fas fa-trash"></i> حذف السجلات القديمة
                        </button>
                        @endcan
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- فلاتر البحث -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <i class="fas fa-filter"></i> فلاتر البحث
                        </div>
                        <div class="card-body">
                            <form action="{{ route('activity-logs.index') }}" method="GET">
                                <div class="row">
                                    <div class="col-md-3 mb-3">
                                        <label for="user_id">المستخدم</label>
                                        <select name="user_id" id="user_id" class="form-control">
                                            <option value="">الكل</option>
                                            @foreach($users as $user)
                                                <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>
                                                    {{ $user->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="action">الإجراء</label>
                                        <select name="action" id="action" class="form-control">
                                            <option value="">الكل</option>
                                            @foreach($actions as $action)
                                                <option value="{{ $action }}" {{ request('action') == $action ? 'selected' : '' }}>
                                                    {{ $action }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="level">المستوى</label>
                                        <select name="level" id="level" class="form-control">
                                            <option value="">الكل</option>
                                            @foreach($levels as $level)
                                                <option value="{{ $level }}" {{ request('level') == $level ? 'selected' : '' }}>
                                                    {{ $level }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="subject_type">نوع الكائن</label>
                                        <select name="subject_type" id="subject_type" class="form-control">
                                            <option value="">الكل</option>
                                            @foreach($subjectTypes as $type)
                                                <option value="{{ $type }}" {{ request('subject_type') == $type ? 'selected' : '' }}>
                                                    {{ class_basename($type) }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="date_from">من تاريخ</label>
                                        <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="date_to">إلى تاريخ</label>
                                        <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                    </div>
                                    
                                    <div class="col-md-6 mb-3 d-flex align-items-end">
                                        <button type="submit" class="btn btn-primary me-2">
                                            <i class="fas fa-search"></i> بحث
                                        </button>
                                        <a href="{{ route('activity-logs.index') }}" class="btn btn-secondary">
                                            <i class="fas fa-redo"></i> إعادة تعيين
                                        </a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>المستخدم</th>
                                    <th>الإجراء</th>
                                    <th>الوصف</th>
                                    <th>المستوى</th>
                                    <th>عنوان IP</th>
                                    <th>التاريخ</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($logs as $log)
                                    <tr>
                                        <td>{{ $log->id }}</td>
                                        <td>
                                            @if($log->user)
                                                <a href="{{ route('users.show', $log->user) }}">{{ $log->user->name }}</a>
                                            @else
                                                <span class="text-muted">غير مسجل</span>
                                            @endif
                                        </td>
                                        <td>{{ $log->action }}</td>
                                        <td>{{ Str::limit($log->description, 50) }}</td>
                                        <td>
                                            @if($log->level == 'info')
                                                <span class="badge bg-info">معلومات</span>
                                            @elseif($log->level == 'warning')
                                                <span class="badge bg-warning">تحذير</span>
                                            @elseif($log->level == 'error')
                                                <span class="badge bg-danger">خطأ</span>
                                            @elseif($log->level == 'success')
                                                <span class="badge bg-success">نجاح</span>
                                            @else
                                                <span class="badge bg-secondary">{{ $log->level }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $log->ip_address }}</td>
                                        <td>{{ $log->created_at->format('Y-m-d H:i:s') }}</td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('activity-logs.show', $log) }}" class="btn btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @can('delete_activity_logs')
                                                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal{{ $log->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                @endcan
                                            </div>
                                            
                                            <!-- Modal -->
                                            <div class="modal fade" id="deleteModal{{ $log->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $log->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $log->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف هذا السجل؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('activity-logs.destroy', $log) }}" method="POST" class="d-inline">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد سجلات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $logs->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal حذف السجلات القديمة -->
<div class="modal fade" id="deleteOldModal" tabindex="-1" role="dialog" aria-labelledby="deleteOldModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteOldModalLabel">حذف السجلات القديمة</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('activity-logs.delete-old') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="days">حذف السجلات الأقدم من</label>
                        <div class="input-group">
                            <input type="number" name="days" id="days" class="form-control" min="1" value="30" required>
                            <div class="input-group-append">
                                <span class="input-group-text">يوم</span>
                            </div>
                        </div>
                        <small class="form-text text-muted">سيتم حذف جميع السجلات التي مر عليها أكثر من العدد المحدد من الأيام.</small>
                    </div>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> تحذير: لا يمكن استعادة السجلات بعد حذفها.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">حذف</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection