@extends('layouts.app')

@section('title', 'تقرير أرصدة الحسابات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تقرير أرصدة الحسابات</h3>
                    <div>
                        <a href="{{ route('chart-of-accounts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة إلى دليل الحسابات
                        </a>
                        <button onclick="window.print()" class="btn btn-info">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                        <a href="{{ route('account-balance-report.export') }}" class="btn btn-success">
                            <i class="fas fa-file-excel"></i> تصدير إلى Excel
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="account-balance-table">
                            <thead>
                                <tr>
                                    <th>رقم الحساب</th>
                                    <th>اسم الحساب</th>
                                    <th>تاريخ آخر حركة</th>
                                    <th>الرصيد النهائي</th>
                                    <th>نوع الرصيد</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $totalDebit = 0;
                                    $totalCredit = 0;
                                @endphp
                                
                                @foreach($accounts as $account)
                                    @php
                                        $balance = $account->current_balance;
                                        $balanceType = '';
                                        
                                        // تحديد نوع الرصيد بناءً على نوع الحساب
                                        if (in_array($account->account_type, ['asset', 'expense'])) {
                                            // الأصول والمصروفات: الرصيد الموجب يكون مدين، والسالب يكون دائن
                                            if ($balance > 0) {
                                                $balanceType = 'مدين';
                                                $totalDebit += $balance;
                                            } elseif ($balance < 0) {
                                                $balanceType = 'دائن';
                                                $totalCredit += abs($balance);
                                                $balance = abs($balance);
                                            }
                                        } else {
                                            // الخصوم والإيرادات وحقوق الملكية: الرصيد الموجب يكون دائن، والسالب يكون مدين
                                            if ($balance > 0) {
                                                $balanceType = 'دائن';
                                                $totalCredit += $balance;
                                            } elseif ($balance < 0) {
                                                $balanceType = 'مدين';
                                                $totalDebit += abs($balance);
                                                $balance = abs($balance);
                                            }
                                        }
                                    @endphp
                                    
                                    @if($balance != 0)
                                    <tr>
                                        <td>{{ $account->account_code }}</td>
                                        <td>{{ $account->name }}</td>
                                        <td>{{ $account->last_movement_date ? date('Y-m-d', strtotime($account->last_movement_date)) : 'لا توجد حركات' }}</td>
                                        <td class="text-left">{{ number_format($balance, 2) }} {{ $account->currency }}</td>
                                        <td>
                                            <span class="badge {{ $balanceType == 'مدين' ? 'badge-success' : 'badge-danger' }}">
                                                {{ $balanceType }}
                                            </span>
                                        </td>
                                    </tr>
                                    @endif
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="bg-light font-weight-bold">
                                    <td colspan="3" class="text-center">الإجمالي</td>
                                    <td class="text-left">
                                        <div>مدين: {{ number_format($totalDebit, 2) }}</div>
                                        <div>دائن: {{ number_format($totalCredit, 2) }}</div>
                                    </td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    @media print {
        .btn, form, .card-header, .main-header, .main-sidebar, .main-footer {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        .card-body {
            padding: 0 !important;
        }
        body {
            margin: 0;
            padding: 0;
            background: #fff;
        }
        .content-wrapper {
            background: #fff;
            margin: 0 !important;
            padding: 0 !important;
        }
    }
</style>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // تهيئة جدول البيانات
        $('#account-balance-table').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            },
            "dom": 'Bfrtip',
            "buttons": [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    });
</script>
@endpush