@extends('layouts.app')

@section('title', 'كشف حساب: ' . $account->name)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title">كشف حساب: {{ $account->account_code }} - {{ $account->name }}</h3>
                        <div>
                            <a href="{{ route('ledger.print', ['account_id' => $account->id, 'start_date' => $startDate, 'end_date' => $endDate]) }}" 
                               class="btn btn-secondary" target="_blank">
                                <i class="fas fa-print"></i> طباعة
                            </a>
                            <a href="{{ route('ledger.index') }}" class="btn btn-primary">
                                <i class="fas fa-search"></i> بحث جديد
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>الفترة:</strong> من {{ date('Y-m-d', strtotime($startDate)) }} إلى {{ date('Y-m-d', strtotime($endDate)) }}
                        </div>
                        <div class="col-md-6 text-left">
                            <strong>نوع الحساب:</strong> {{ $account->type }}
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead class="thead-dark">
                                <tr>
                                    <th>التاريخ</th>
                                    <th>رقم القيد</th>
                                    <th>البيان</th>
                                    <th>المرجع</th>
                                    <th>مدين</th>
                                    <th>دائن</th>
                                    <th>الرصيد</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- رصيد افتتاحي -->
                                <tr class="table-secondary">
                                    <td>{{ date('Y-m-d', strtotime($startDate)) }}</td>
                                    <td>-</td>
                                    <td><strong>رصيد افتتاحي</strong></td>
                                    <td>-</td>
                                    <td>-</td>
                                    <td>-</td>
                                    <td class="text-{{ $openingBalance >= 0 ? 'success' : 'danger' }}">
                                        <strong>{{ number_format(abs($openingBalance), 2) }} {{ $openingBalance >= 0 ? 'مدين' : 'دائن' }}</strong>
                                    </td>
                                </tr>
                                
                                @php
                                    $totalDebit = 0;
                                    $totalCredit = 0;
                                    $balance = $openingBalance;
                                @endphp
                                
                                @foreach($transactions as $transaction)
                                    @php
                                        $totalDebit += $transaction->debit;
                                        $totalCredit += $transaction->credit;
                                        $balance = $balance + $transaction->debit - $transaction->credit;
                                    @endphp
                                    <tr>
                                        <td>{{ date('Y-m-d', strtotime($transaction->journalEntry->entry_date)) }}</td>
                                        <td>
                                            <a href="{{ route('journal-entries.show', $transaction->journal_entry_id) }}" target="_blank">
                                                {{ $transaction->journal_entry_id }}
                                            </a>
                                        </td>
                                        <td>{{ $transaction->description ?? $transaction->journalEntry->description }}</td>
                                        <td>
                                            @if($transaction->reference_type)
                                                @if(strpos($transaction->reference_type, 'JournalEntry') !== false)
                                                    JE-{{ str_pad($transaction->reference_id, 6, '0', STR_PAD_LEFT) }}
                                                @else
                                                    {{ $transaction->reference_type }} #{{ $transaction->reference_id }}
                                                @endif
                                            @elseif($transaction->journalEntry->reference_type)
                                                @if(strpos($transaction->journalEntry->reference_type, 'JournalEntry') !== false)
                                                    JE-{{ str_pad($transaction->journalEntry->reference_id, 6, '0', STR_PAD_LEFT) }}
                                                @else
                                                    {{ $transaction->journalEntry->reference_type }} #{{ $transaction->journalEntry->reference_id }}
                                                @endif
                                            @elseif($transaction->journalEntry->reference_number)
                                                {{ $transaction->journalEntry->reference_number }}
                                            @else
                                                -
                                            @endif
                                        </td>
                                        <td class="text-right">{{ $transaction->debit > 0 ? number_format($transaction->debit, 2) : '-' }}</td>
                                        <td class="text-right">{{ $transaction->credit > 0 ? number_format($transaction->credit, 2) : '-' }}</td>
                                        <td class="text-{{ $balance >= 0 ? 'success' : 'danger' }}">
                                            {{ number_format(abs($balance), 2) }} {{ $balance >= 0 ? 'مدين' : 'دائن' }}
                                        </td>
                                    </tr>
                                @endforeach
                                
                                <!-- الإجماليات -->
                                <tr class="table-primary">
                                    <td colspan="4"><strong>إجمالي الحركة خلال الفترة</strong></td>
                                    <td class="text-right"><strong>{{ number_format($totalDebit, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($totalCredit, 2) }}</strong></td>
                                    <td class="text-{{ $balance >= 0 ? 'success' : 'danger' }}">
                                        <strong>{{ number_format(abs($balance), 2) }} {{ $balance >= 0 ? 'مدين' : 'دائن' }}</strong>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="alert alert-info">
                                <strong>ملاحظة:</strong> الأرصدة المدينة تظهر بالقيمة الموجبة والأرصدة الدائنة تظهر بالقيمة السالبة.
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <h5>ملخص الحساب</h5>
                                    <table class="table table-sm">
                                        <tr>
                                            <td>الرصيد الافتتاحي</td>
                                            <td class="text-{{ $openingBalance >= 0 ? 'success' : 'danger' }}">
                                                {{ number_format(abs($openingBalance), 2) }} {{ $openingBalance >= 0 ? 'مدين' : 'دائن' }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>إجمالي الحركات المدينة</td>
                                            <td>{{ number_format($totalDebit, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td>إجمالي الحركات الدائنة</td>
                                            <td>{{ number_format($totalCredit, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>الرصيد الختامي</strong></td>
                                            <td class="text-{{ $balance >= 0 ? 'success' : 'danger' }}">
                                                <strong>{{ number_format(abs($balance), 2) }} {{ $balance >= 0 ? 'مدين' : 'دائن' }}</strong>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection