<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>كشف حساب: {{ $account->name }}</title>
    <link rel="stylesheet" href="{{ asset('css/bootstrap.min.css') }}">
    <style>
        body {
            font-family: 'Cairo', sans-serif;
            padding: 20px;
        }
        .print-header {
            text-align: center;
            margin-bottom: 20px;
        }
        .company-info {
            margin-bottom: 20px;
        }
        .report-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .report-subtitle {
            font-size: 18px;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
        }
        .summary-table {
            width: 50%;
            margin-top: 20px;
            margin-right: auto;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                padding: 0;
                margin: 0;
            }
        }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 20px;">
        <button onclick="window.print()" class="btn btn-primary">طباعة</button>
        <button onclick="window.close()" class="btn btn-secondary">إغلاق</button>
    </div>

    <div class="print-header">
        <div class="company-info">
            <h2>شركة المصاعد للمقاولات</h2>
            <p>نظام المحاسبة - دفتر الأستاذ</p>
        </div>
        
        <div class="report-title">
            كشف حساب: {{ $account->account_code }} - {{ $account->name }}
        </div>
        
        <div class="report-subtitle">
            الفترة من {{ date('Y-m-d', strtotime($startDate)) }} إلى {{ date('Y-m-d', strtotime($endDate)) }}
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>التاريخ</th>
                <th>رقم القيد</th>
                <th>البيان</th>
                <th>المرجع</th>
                <th>مدين</th>
                <th>دائن</th>
                <th>الرصيد</th>
            </tr>
        </thead>
        <tbody>
            <!-- رصيد افتتاحي -->
            <tr style="background-color: #f2f2f2;">
                <td>{{ date('Y-m-d', strtotime($startDate)) }}</td>
                <td>-</td>
                <td><strong>رصيد افتتاحي</strong></td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>
                    <strong>{{ number_format(abs($openingBalance), 2) }} {{ $openingBalance >= 0 ? 'مدين' : 'دائن' }}</strong>
                </td>
            </tr>
            
            @php
                $totalDebit = 0;
                $totalCredit = 0;
                $balance = $openingBalance;
            @endphp
            
            @foreach($transactions as $transaction)
                @php
                    $totalDebit += $transaction->debit;
                    $totalCredit += $transaction->credit;
                    $balance = $balance + $transaction->debit - $transaction->credit;
                @endphp
                <tr>
                    <td>{{ date('Y-m-d', strtotime($transaction->journalEntry->entry_date)) }}</td>
                    <td>{{ $transaction->journal_entry_id }}</td>
                    <td>{{ $transaction->description ?? $transaction->journalEntry->description }}</td>
                    <td>
                        @if($transaction->reference_type)
                            {{ $transaction->reference_type }} #{{ $transaction->reference_id }}
                        @elseif($transaction->journalEntry->reference_type)
                            {{ $transaction->journalEntry->reference_type }} #{{ $transaction->journalEntry->reference_id }}
                        @else
                            -
                        @endif
                    </td>
                    <td class="text-right">{{ $transaction->debit > 0 ? number_format($transaction->debit, 2) : '-' }}</td>
                    <td class="text-right">{{ $transaction->credit > 0 ? number_format($transaction->credit, 2) : '-' }}</td>
                    <td>
                        {{ number_format(abs($balance), 2) }} {{ $balance >= 0 ? 'مدين' : 'دائن' }}
                    </td>
                </tr>
            @endforeach
            
            <!-- الإجماليات -->
            <tr style="background-color: #e6e6e6; font-weight: bold;">
                <td colspan="4"><strong>إجمالي الحركة خلال الفترة</strong></td>
                <td class="text-right"><strong>{{ number_format($totalDebit, 2) }}</strong></td>
                <td class="text-right"><strong>{{ number_format($totalCredit, 2) }}</strong></td>
                <td>
                    <strong>{{ number_format(abs($balance), 2) }} {{ $balance >= 0 ? 'مدين' : 'دائن' }}</strong>
                </td>
            </tr>
        </tbody>
    </table>

    <table class="summary-table">
        <tr>
            <td>الرصيد الافتتاحي</td>
            <td>{{ number_format(abs($openingBalance), 2) }} {{ $openingBalance >= 0 ? 'مدين' : 'دائن' }}</td>
        </tr>
        <tr>
            <td>إجمالي الحركات المدينة</td>
            <td>{{ number_format($totalDebit, 2) }}</td>
        </tr>
        <tr>
            <td>إجمالي الحركات الدائنة</td>
            <td>{{ number_format($totalCredit, 2) }}</td>
        </tr>
        <tr style="font-weight: bold;">
            <td>الرصيد الختامي</td>
            <td>{{ number_format(abs($balance), 2) }} {{ $balance >= 0 ? 'مدين' : 'دائن' }}</td>
        </tr>
    </table>

    <div class="footer">
        <p>تم إنشاء هذا التقرير بواسطة نظام المصاعد للمقاولات - {{ date('Y-m-d H:i') }}</p>
    </div>
</body>
</html>