@extends('layouts.app')

@section('title', 'عرض قالب قيد محاسبي')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تفاصيل قالب القيد المحاسبي</h3>
                    <div>
                        <a href="{{ route('journal-entries.create', ['template_id' => $template->id]) }}" class="btn btn-success">
                            <i class="fas fa-plus-circle"></i> إنشاء قيد من هذا القالب
                        </a>
                        @can('edit_journal_templates')
                        <a href="{{ route('journal-templates.edit', $template->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan
                        <a href="{{ route('journal-templates.index') }}" class="btn btn-secondary">
                            <i class="fas fa-list"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 30%">اسم القالب</th>
                                    <td>{{ $template->name }}</td>
                                </tr>
                                <tr>
                                    <th>الوصف</th>
                                    <td>{{ $template->description ?? 'لا يوجد وصف' }}</td>
                                </tr>
                                <tr>
                                    <th>تم إنشاؤه بواسطة</th>
                                    <td>{{ $template->creator->name ?? 'غير معروف' }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 30%">تاريخ الإنشاء</th>
                                    <td>{{ $template->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>آخر تحديث</th>
                                    <td>{{ $template->updated_at->format('Y-m-d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>عدد البنود</th>
                                    <td>{{ $template->items->count() }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    <h4 class="mt-4">بنود القالب</h4>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الحساب</th>
                                    <th>الوصف</th>
                                    <th>مدين</th>
                                    <th>دائن</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $totalDebit = 0;
                                    $totalCredit = 0;
                                @endphp
                                
                                @foreach($template->items as $index => $item)
                                    @php
                                        $totalDebit += $item->debit;
                                        $totalCredit += $item->credit;
                                    @endphp
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            {{ $item->account->account_code }} - {{ $item->account->name }}
                                        </td>
                                        <td>{{ $item->description ?? '-' }}</td>
                                        <td class="text-left">{{ number_format($item->debit, 2) }}</td>
                                        <td class="text-left">{{ number_format($item->credit, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="3" class="text-left">المجموع</th>
                                    <th class="text-left">{{ number_format($totalDebit, 2) }}</th>
                                    <th class="text-left">{{ number_format($totalCredit, 2) }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                    <h4 class="mt-4">القيود المحاسبية المنشأة من هذا القالب</h4>
                    @if($template->journalEntries && $template->journalEntries->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>رقم القيد</th>
                                        <th>التاريخ</th>
                                        <th>المرجع</th>
                                        <th>المبلغ</th>
                                        <th>الحالة</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($template->journalEntries as $index => $entry)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $entry->entry_number }}</td>
                                            <td>{{ $entry->entry_date->format('Y-m-d') }}</td>
                                            <td>{{ $entry->reference ?? '-' }}</td>
                                            <td>{{ number_format($entry->amount, 2) }}</td>
                                            <td>
                                                @if($entry->is_posted)
                                                    <span class="badge badge-success">مرحل</span>
                                                @else
                                                    <span class="badge badge-warning">غير مرحل</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('journal-entries.show', $entry->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            لم يتم إنشاء أي قيود محاسبية من هذا القالب بعد.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection